/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an AWS CodeBuild project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectDetails.Builder, AwsCodeBuildProjectDetails> {
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(AwsCodeBuildProjectDetails::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<AwsCodeBuildProjectEnvironment> ENVIRONMENT_FIELD = SdkField
            .<AwsCodeBuildProjectEnvironment> builder(MarshallingType.SDK_POJO).memberName("Environment")
            .getter(getter(AwsCodeBuildProjectDetails::environment)).setter(setter(Builder::environment))
            .constructor(AwsCodeBuildProjectEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsCodeBuildProjectDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsCodeBuildProjectSource> SOURCE_FIELD = SdkField
            .<AwsCodeBuildProjectSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(AwsCodeBuildProjectDetails::source)).setter(setter(Builder::source))
            .constructor(AwsCodeBuildProjectSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(AwsCodeBuildProjectDetails::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<AwsCodeBuildProjectVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<AwsCodeBuildProjectVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(AwsCodeBuildProjectDetails::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(AwsCodeBuildProjectVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD,
            ENVIRONMENT_FIELD, NAME_FIELD, SOURCE_FIELD, SERVICE_ROLE_FIELD, VPC_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String encryptionKey;

    private final AwsCodeBuildProjectEnvironment environment;

    private final String name;

    private final AwsCodeBuildProjectSource source;

    private final String serviceRole;

    private final AwsCodeBuildProjectVpcConfig vpcConfig;

    private AwsCodeBuildProjectDetails(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
        this.environment = builder.environment;
        this.name = builder.name;
        this.source = builder.source;
        this.serviceRole = builder.serviceRole;
        this.vpcConfig = builder.vpcConfig;
    }

    /**
     * <p>
     * The AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the build output artifacts.
     * </p>
     * <p>
     * You can specify either the ARN of the CMK or, if available, the CMK alias (using the format alias/alias-name).
     * </p>
     * 
     * @return The AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the build output
     *         artifacts.</p>
     *         <p>
     *         You can specify either the ARN of the CMK or, if available, the CMK alias (using the format
     *         alias/alias-name).
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * Information about the build environment for this build project.
     * </p>
     * 
     * @return Information about the build environment for this build project.
     */
    public final AwsCodeBuildProjectEnvironment environment() {
        return environment;
    }

    /**
     * <p>
     * The name of the build project.
     * </p>
     * 
     * @return The name of the build project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the build input source code for this build project.
     * </p>
     * 
     * @return Information about the build input source code for this build project.
     */
    public final AwsCodeBuildProjectSource source() {
        return source;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS
     * account.
     * </p>
     * 
     * @return The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of
     *         the AWS account.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Information about the VPC configuration that AWS CodeBuild accesses.
     * </p>
     * 
     * @return Information about the VPC configuration that AWS CodeBuild accesses.
     */
    public final AwsCodeBuildProjectVpcConfig vpcConfig() {
        return vpcConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectDetails)) {
            return false;
        }
        AwsCodeBuildProjectDetails other = (AwsCodeBuildProjectDetails) obj;
        return Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(environment(), other.environment())
                && Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(vpcConfig(), other.vpcConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectDetails").add("EncryptionKey", encryptionKey())
                .add("Environment", environment()).add("Name", name()).add("Source", source()).add("ServiceRole", serviceRole())
                .add("VpcConfig", vpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectDetails> {
        /**
         * <p>
         * The AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the build output
         * artifacts.
         * </p>
         * <p>
         * You can specify either the ARN of the CMK or, if available, the CMK alias (using the format
         * alias/alias-name).
         * </p>
         * 
         * @param encryptionKey
         *        The AWS Key Management Service (AWS KMS) customer master key (CMK) used to encrypt the build output
         *        artifacts.</p>
         *        <p>
         *        You can specify either the ARN of the CMK or, if available, the CMK alias (using the format
         *        alias/alias-name).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * 
         * @param environment
         *        Information about the build environment for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(AwsCodeBuildProjectEnvironment environment);

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCodeBuildProjectEnvironment.Builder} avoiding
         * the need to create one manually via {@link AwsCodeBuildProjectEnvironment#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectEnvironment.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(AwsCodeBuildProjectEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link AwsCodeBuildProjectEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(AwsCodeBuildProjectEnvironment)
         */
        default Builder environment(Consumer<AwsCodeBuildProjectEnvironment.Builder> environment) {
            return environment(AwsCodeBuildProjectEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The name of the build project.
         * </p>
         * 
         * @param name
         *        The name of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * 
         * @param source
         *        Information about the build input source code for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(AwsCodeBuildProjectSource source);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCodeBuildProjectSource.Builder} avoiding the
         * need to create one manually via {@link AwsCodeBuildProjectSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(AwsCodeBuildProjectSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link AwsCodeBuildProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(AwsCodeBuildProjectSource)
         */
        default Builder source(Consumer<AwsCodeBuildProjectSource.Builder> source) {
            return source(AwsCodeBuildProjectSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the
         * AWS account.
         * </p>
         * 
         * @param serviceRole
         *        The ARN of the IAM role that enables AWS CodeBuild to interact with dependent AWS services on behalf
         *        of the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Information about the VPC configuration that AWS CodeBuild accesses.
         * </p>
         * 
         * @param vpcConfig
         *        Information about the VPC configuration that AWS CodeBuild accesses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(AwsCodeBuildProjectVpcConfig vpcConfig);

        /**
         * <p>
         * Information about the VPC configuration that AWS CodeBuild accesses.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsCodeBuildProjectVpcConfig.Builder} avoiding
         * the need to create one manually via {@link AwsCodeBuildProjectVpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectVpcConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfig(AwsCodeBuildProjectVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link AwsCodeBuildProjectVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(AwsCodeBuildProjectVpcConfig)
         */
        default Builder vpcConfig(Consumer<AwsCodeBuildProjectVpcConfig.Builder> vpcConfig) {
            return vpcConfig(AwsCodeBuildProjectVpcConfig.builder().applyMutation(vpcConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String encryptionKey;

        private AwsCodeBuildProjectEnvironment environment;

        private String name;

        private AwsCodeBuildProjectSource source;

        private String serviceRole;

        private AwsCodeBuildProjectVpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectDetails model) {
            encryptionKey(model.encryptionKey);
            environment(model.environment);
            name(model.name);
            source(model.source);
            serviceRole(model.serviceRole);
            vpcConfig(model.vpcConfig);
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final AwsCodeBuildProjectEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(AwsCodeBuildProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(AwsCodeBuildProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final AwsCodeBuildProjectSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        @Override
        public final Builder source(AwsCodeBuildProjectSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(AwsCodeBuildProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final AwsCodeBuildProjectVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(AwsCodeBuildProjectVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(AwsCodeBuildProjectVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public AwsCodeBuildProjectDetails build() {
            return new AwsCodeBuildProjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
