/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the build input source code for this build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectSource.Builder, AwsCodeBuildProjectSource> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsCodeBuildProjectSource::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(AwsCodeBuildProjectSource::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final SdkField<Integer> GIT_CLONE_DEPTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("GitCloneDepth").getter(getter(AwsCodeBuildProjectSource::gitCloneDepth))
            .setter(setter(Builder::gitCloneDepth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitCloneDepth").build()).build();

    private static final SdkField<Boolean> INSECURE_SSL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InsecureSsl").getter(getter(AwsCodeBuildProjectSource::insecureSsl))
            .setter(setter(Builder::insecureSsl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsecureSsl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOCATION_FIELD,
            GIT_CLONE_DEPTH_FIELD, INSECURE_SSL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String location;

    private final Integer gitCloneDepth;

    private final Boolean insecureSsl;

    private AwsCodeBuildProjectSource(BuilderImpl builder) {
        this.type = builder.type;
        this.location = builder.location;
        this.gitCloneDepth = builder.gitCloneDepth;
        this.insecureSsl = builder.insecureSsl;
    }

    /**
     * <p>
     * The type of repository that contains the source code to be built. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BITBUCKET</code> - The source code is in a Bitbucket repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CODECOMMIT</code> - The source code is in an AWS CodeCommit repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline in AWS
     * CodePipeline.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GITHUB</code> - The source code is in a GitHub repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_SOURCE</code> - The project does not have input source code.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code> - The source code is in an S3 input bucket.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of repository that contains the source code to be built. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BITBUCKET</code> - The source code is in a Bitbucket repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CODECOMMIT</code> - The source code is in an AWS CodeCommit repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline in
     *         AWS CodePipeline.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GITHUB</code> - The source code is in a GitHub repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_SOURCE</code> - The project does not have input source code.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code> - The source code is in an S3 input bucket.
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Information about the location of the source code to be built.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For source code settings that are specified in the source action of a pipeline in AWS CodePipeline, location
     * should not be specified. If it is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline uses
     * the settings in a pipeline's source action instead of this value.
     * </p>
     * </li>
     * <li>
     * <p>
     * For source code in an AWS CodeCommit repository, the HTTPS clone URL to the repository that contains the source
     * code and the build spec file (for example,
     * <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).
     * </p>
     * </li>
     * <li>
     * <p>
     * For source code in an S3 input bucket, one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The path to the ZIP file that contains the source code (for example,
     * <code>bucket-name/path/to/object-name.zip</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The path to the folder that contains the source code (for example,
     * <code>bucket-name/path/to/source-code/folder/</code>).
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and the
     * build spec file.
     * </p>
     * </li>
     * <li>
     * <p>
     * For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and the
     * build spec file.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Information about the location of the source code to be built.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For source code settings that are specified in the source action of a pipeline in AWS CodePipeline,
     *         location should not be specified. If it is specified, AWS CodePipeline ignores it. This is because AWS
     *         CodePipeline uses the settings in a pipeline's source action instead of this value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For source code in an AWS CodeCommit repository, the HTTPS clone URL to the repository that contains the
     *         source code and the build spec file (for example,
     *         <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For source code in an S3 input bucket, one of the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The path to the ZIP file that contains the source code (for example,
     *         <code>bucket-name/path/to/object-name.zip</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The path to the folder that contains the source code (for example,
     *         <code>bucket-name/path/to/source-code/folder/</code>).
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source
     *         and the build spec file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source
     *         and the build spec file.
     *         </p>
     *         </li>
     */
    public final String location() {
        return location;
    }

    /**
     * <p>
     * Information about the Git clone depth for the build project.
     * </p>
     * 
     * @return Information about the Git clone depth for the build project.
     */
    public final Integer gitCloneDepth() {
        return gitCloneDepth;
    }

    /**
     * <p>
     * Whether to ignore SSL warnings while connecting to the project source code.
     * </p>
     * 
     * @return Whether to ignore SSL warnings while connecting to the project source code.
     */
    public final Boolean insecureSsl() {
        return insecureSsl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        hashCode = 31 * hashCode + Objects.hashCode(gitCloneDepth());
        hashCode = 31 * hashCode + Objects.hashCode(insecureSsl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectSource)) {
            return false;
        }
        AwsCodeBuildProjectSource other = (AwsCodeBuildProjectSource) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(location(), other.location())
                && Objects.equals(gitCloneDepth(), other.gitCloneDepth()) && Objects.equals(insecureSsl(), other.insecureSsl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectSource").add("Type", type()).add("Location", location())
                .add("GitCloneDepth", gitCloneDepth()).add("InsecureSsl", insecureSsl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        case "GitCloneDepth":
            return Optional.ofNullable(clazz.cast(gitCloneDepth()));
        case "InsecureSsl":
            return Optional.ofNullable(clazz.cast(insecureSsl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectSource, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectSource> {
        /**
         * <p>
         * The type of repository that contains the source code to be built. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BITBUCKET</code> - The source code is in a Bitbucket repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CODECOMMIT</code> - The source code is in an AWS CodeCommit repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline in AWS
         * CodePipeline.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GITHUB</code> - The source code is in a GitHub repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_SOURCE</code> - The project does not have input source code.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code> - The source code is in an S3 input bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of repository that contains the source code to be built. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BITBUCKET</code> - The source code is in a Bitbucket repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CODECOMMIT</code> - The source code is in an AWS CodeCommit repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CODEPIPELINE</code> - The source code settings are specified in the source action of a pipeline
         *        in AWS CodePipeline.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GITHUB</code> - The source code is in a GitHub repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GITHUB_ENTERPRISE</code> - The source code is in a GitHub Enterprise repository.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_SOURCE</code> - The project does not have input source code.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code> - The source code is in an S3 input bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Information about the location of the source code to be built.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For source code settings that are specified in the source action of a pipeline in AWS CodePipeline, location
         * should not be specified. If it is specified, AWS CodePipeline ignores it. This is because AWS CodePipeline
         * uses the settings in a pipeline's source action instead of this value.
         * </p>
         * </li>
         * <li>
         * <p>
         * For source code in an AWS CodeCommit repository, the HTTPS clone URL to the repository that contains the
         * source code and the build spec file (for example,
         * <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).
         * </p>
         * </li>
         * <li>
         * <p>
         * For source code in an S3 input bucket, one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The path to the ZIP file that contains the source code (for example,
         * <code>bucket-name/path/to/object-name.zip</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * The path to the folder that contains the source code (for example,
         * <code>bucket-name/path/to/source-code/folder/</code>).
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source and
         * the build spec file.
         * </p>
         * </li>
         * <li>
         * <p>
         * For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the source and
         * the build spec file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param location
         *        Information about the location of the source code to be built.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For source code settings that are specified in the source action of a pipeline in AWS CodePipeline,
         *        location should not be specified. If it is specified, AWS CodePipeline ignores it. This is because AWS
         *        CodePipeline uses the settings in a pipeline's source action instead of this value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For source code in an AWS CodeCommit repository, the HTTPS clone URL to the repository that contains
         *        the source code and the build spec file (for example,
         *        <code>https://git-codecommit.region-ID.amazonaws.com/v1/repos/repo-name</code> ).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For source code in an S3 input bucket, one of the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The path to the ZIP file that contains the source code (for example,
         *        <code>bucket-name/path/to/object-name.zip</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The path to the folder that contains the source code (for example,
         *        <code>bucket-name/path/to/source-code/folder/</code>).
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For source code in a GitHub repository, the HTTPS clone URL to the repository that contains the source
         *        and the build spec file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For source code in a Bitbucket repository, the HTTPS clone URL to the repository that contains the
         *        source and the build spec file.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        /**
         * <p>
         * Information about the Git clone depth for the build project.
         * </p>
         * 
         * @param gitCloneDepth
         *        Information about the Git clone depth for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gitCloneDepth(Integer gitCloneDepth);

        /**
         * <p>
         * Whether to ignore SSL warnings while connecting to the project source code.
         * </p>
         * 
         * @param insecureSsl
         *        Whether to ignore SSL warnings while connecting to the project source code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insecureSsl(Boolean insecureSsl);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String location;

        private Integer gitCloneDepth;

        private Boolean insecureSsl;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectSource model) {
            type(model.type);
            location(model.location);
            gitCloneDepth(model.gitCloneDepth);
            insecureSsl(model.insecureSsl);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final Integer getGitCloneDepth() {
            return gitCloneDepth;
        }

        @Override
        public final Builder gitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
            return this;
        }

        public final void setGitCloneDepth(Integer gitCloneDepth) {
            this.gitCloneDepth = gitCloneDepth;
        }

        public final Boolean getInsecureSsl() {
            return insecureSsl;
        }

        @Override
        public final Builder insecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
            return this;
        }

        public final void setInsecureSsl(Boolean insecureSsl) {
            this.insecureSsl = insecureSsl;
        }

        @Override
        public AwsCodeBuildProjectSource build() {
            return new AwsCodeBuildProjectSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
