/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the cross-origin resource sharing (CORS) configuration for the API. CORS is only supported for HTTP APIs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCorsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCorsConfiguration.Builder, AwsCorsConfiguration> {
    private static final SdkField<List<String>> ALLOW_ORIGINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowOrigins")
            .getter(getter(AwsCorsConfiguration::allowOrigins))
            .setter(setter(Builder::allowOrigins))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowOrigins").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ALLOW_CREDENTIALS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowCredentials").getter(getter(AwsCorsConfiguration::allowCredentials))
            .setter(setter(Builder::allowCredentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowCredentials").build()).build();

    private static final SdkField<List<String>> EXPOSE_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExposeHeaders")
            .getter(getter(AwsCorsConfiguration::exposeHeaders))
            .setter(setter(Builder::exposeHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExposeHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_AGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAge").getter(getter(AwsCorsConfiguration::maxAge)).setter(setter(Builder::maxAge))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAge").build()).build();

    private static final SdkField<List<String>> ALLOW_METHODS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowMethods")
            .getter(getter(AwsCorsConfiguration::allowMethods))
            .setter(setter(Builder::allowMethods))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowMethods").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOW_HEADERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowHeaders")
            .getter(getter(AwsCorsConfiguration::allowHeaders))
            .setter(setter(Builder::allowHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowHeaders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_ORIGINS_FIELD,
            ALLOW_CREDENTIALS_FIELD, EXPOSE_HEADERS_FIELD, MAX_AGE_FIELD, ALLOW_METHODS_FIELD, ALLOW_HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> allowOrigins;

    private final Boolean allowCredentials;

    private final List<String> exposeHeaders;

    private final Integer maxAge;

    private final List<String> allowMethods;

    private final List<String> allowHeaders;

    private AwsCorsConfiguration(BuilderImpl builder) {
        this.allowOrigins = builder.allowOrigins;
        this.allowCredentials = builder.allowCredentials;
        this.exposeHeaders = builder.exposeHeaders;
        this.maxAge = builder.maxAge;
        this.allowMethods = builder.allowMethods;
        this.allowHeaders = builder.allowHeaders;
    }

    /**
     * Returns true if the AllowOrigins property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowOrigins() {
        return allowOrigins != null && !(allowOrigins instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed origins for CORS requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowOrigins()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed origins for CORS requests.
     */
    public final List<String> allowOrigins() {
        return allowOrigins;
    }

    /**
     * <p>
     * Indicates whether the CORS request includes credentials.
     * </p>
     * 
     * @return Indicates whether the CORS request includes credentials.
     */
    public final Boolean allowCredentials() {
        return allowCredentials;
    }

    /**
     * Returns true if the ExposeHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasExposeHeaders() {
        return exposeHeaders != null && !(exposeHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The exposed headers for CORS requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExposeHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The exposed headers for CORS requests.
     */
    public final List<String> exposeHeaders() {
        return exposeHeaders;
    }

    /**
     * <p>
     * The number of seconds for which the browser caches preflight request results.
     * </p>
     * 
     * @return The number of seconds for which the browser caches preflight request results.
     */
    public final Integer maxAge() {
        return maxAge;
    }

    /**
     * Returns true if the AllowMethods property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowMethods() {
        return allowMethods != null && !(allowMethods instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed methods for CORS requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowMethods()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed methods for CORS requests.
     */
    public final List<String> allowMethods() {
        return allowMethods;
    }

    /**
     * Returns true if the AllowHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAllowHeaders() {
        return allowHeaders != null && !(allowHeaders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed headers for CORS requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The allowed headers for CORS requests.
     */
    public final List<String> allowHeaders() {
        return allowHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowOrigins() ? allowOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(allowCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasExposeHeaders() ? exposeHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxAge());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowMethods() ? allowMethods() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowHeaders() ? allowHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCorsConfiguration)) {
            return false;
        }
        AwsCorsConfiguration other = (AwsCorsConfiguration) obj;
        return hasAllowOrigins() == other.hasAllowOrigins() && Objects.equals(allowOrigins(), other.allowOrigins())
                && Objects.equals(allowCredentials(), other.allowCredentials()) && hasExposeHeaders() == other.hasExposeHeaders()
                && Objects.equals(exposeHeaders(), other.exposeHeaders()) && Objects.equals(maxAge(), other.maxAge())
                && hasAllowMethods() == other.hasAllowMethods() && Objects.equals(allowMethods(), other.allowMethods())
                && hasAllowHeaders() == other.hasAllowHeaders() && Objects.equals(allowHeaders(), other.allowHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCorsConfiguration").add("AllowOrigins", hasAllowOrigins() ? allowOrigins() : null)
                .add("AllowCredentials", allowCredentials()).add("ExposeHeaders", hasExposeHeaders() ? exposeHeaders() : null)
                .add("MaxAge", maxAge()).add("AllowMethods", hasAllowMethods() ? allowMethods() : null)
                .add("AllowHeaders", hasAllowHeaders() ? allowHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowOrigins":
            return Optional.ofNullable(clazz.cast(allowOrigins()));
        case "AllowCredentials":
            return Optional.ofNullable(clazz.cast(allowCredentials()));
        case "ExposeHeaders":
            return Optional.ofNullable(clazz.cast(exposeHeaders()));
        case "MaxAge":
            return Optional.ofNullable(clazz.cast(maxAge()));
        case "AllowMethods":
            return Optional.ofNullable(clazz.cast(allowMethods()));
        case "AllowHeaders":
            return Optional.ofNullable(clazz.cast(allowHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCorsConfiguration, T> g) {
        return obj -> g.apply((AwsCorsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCorsConfiguration> {
        /**
         * <p>
         * The allowed origins for CORS requests.
         * </p>
         * 
         * @param allowOrigins
         *        The allowed origins for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(Collection<String> allowOrigins);

        /**
         * <p>
         * The allowed origins for CORS requests.
         * </p>
         * 
         * @param allowOrigins
         *        The allowed origins for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowOrigins(String... allowOrigins);

        /**
         * <p>
         * Indicates whether the CORS request includes credentials.
         * </p>
         * 
         * @param allowCredentials
         *        Indicates whether the CORS request includes credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowCredentials(Boolean allowCredentials);

        /**
         * <p>
         * The exposed headers for CORS requests.
         * </p>
         * 
         * @param exposeHeaders
         *        The exposed headers for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(Collection<String> exposeHeaders);

        /**
         * <p>
         * The exposed headers for CORS requests.
         * </p>
         * 
         * @param exposeHeaders
         *        The exposed headers for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exposeHeaders(String... exposeHeaders);

        /**
         * <p>
         * The number of seconds for which the browser caches preflight request results.
         * </p>
         * 
         * @param maxAge
         *        The number of seconds for which the browser caches preflight request results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAge(Integer maxAge);

        /**
         * <p>
         * The allowed methods for CORS requests.
         * </p>
         * 
         * @param allowMethods
         *        The allowed methods for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(Collection<String> allowMethods);

        /**
         * <p>
         * The allowed methods for CORS requests.
         * </p>
         * 
         * @param allowMethods
         *        The allowed methods for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMethods(String... allowMethods);

        /**
         * <p>
         * The allowed headers for CORS requests.
         * </p>
         * 
         * @param allowHeaders
         *        The allowed headers for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(Collection<String> allowHeaders);

        /**
         * <p>
         * The allowed headers for CORS requests.
         * </p>
         * 
         * @param allowHeaders
         *        The allowed headers for CORS requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowHeaders(String... allowHeaders);
    }

    static final class BuilderImpl implements Builder {
        private List<String> allowOrigins = DefaultSdkAutoConstructList.getInstance();

        private Boolean allowCredentials;

        private List<String> exposeHeaders = DefaultSdkAutoConstructList.getInstance();

        private Integer maxAge;

        private List<String> allowMethods = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowHeaders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCorsConfiguration model) {
            allowOrigins(model.allowOrigins);
            allowCredentials(model.allowCredentials);
            exposeHeaders(model.exposeHeaders);
            maxAge(model.maxAge);
            allowMethods(model.allowMethods);
            allowHeaders(model.allowHeaders);
        }

        public final Collection<String> getAllowOrigins() {
            if (allowOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return allowOrigins;
        }

        @Override
        public final Builder allowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = NonEmptyStringListCopier.copy(allowOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowOrigins(String... allowOrigins) {
            allowOrigins(Arrays.asList(allowOrigins));
            return this;
        }

        public final void setAllowOrigins(Collection<String> allowOrigins) {
            this.allowOrigins = NonEmptyStringListCopier.copy(allowOrigins);
        }

        public final Boolean getAllowCredentials() {
            return allowCredentials;
        }

        @Override
        public final Builder allowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
            return this;
        }

        public final void setAllowCredentials(Boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        public final Collection<String> getExposeHeaders() {
            if (exposeHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return exposeHeaders;
        }

        @Override
        public final Builder exposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = NonEmptyStringListCopier.copy(exposeHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exposeHeaders(String... exposeHeaders) {
            exposeHeaders(Arrays.asList(exposeHeaders));
            return this;
        }

        public final void setExposeHeaders(Collection<String> exposeHeaders) {
            this.exposeHeaders = NonEmptyStringListCopier.copy(exposeHeaders);
        }

        public final Integer getMaxAge() {
            return maxAge;
        }

        @Override
        public final Builder maxAge(Integer maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public final void setMaxAge(Integer maxAge) {
            this.maxAge = maxAge;
        }

        public final Collection<String> getAllowMethods() {
            if (allowMethods instanceof SdkAutoConstructList) {
                return null;
            }
            return allowMethods;
        }

        @Override
        public final Builder allowMethods(Collection<String> allowMethods) {
            this.allowMethods = NonEmptyStringListCopier.copy(allowMethods);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowMethods(String... allowMethods) {
            allowMethods(Arrays.asList(allowMethods));
            return this;
        }

        public final void setAllowMethods(Collection<String> allowMethods) {
            this.allowMethods = NonEmptyStringListCopier.copy(allowMethods);
        }

        public final Collection<String> getAllowHeaders() {
            if (allowHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return allowHeaders;
        }

        @Override
        public final Builder allowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = NonEmptyStringListCopier.copy(allowHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowHeaders(String... allowHeaders) {
            allowHeaders(Arrays.asList(allowHeaders));
            return this;
        }

        public final void setAllowHeaders(Collection<String> allowHeaders) {
            this.allowHeaders = NonEmptyStringListCopier.copy(allowHeaders);
        }

        @Override
        public AwsCorsConfiguration build() {
            return new AwsCorsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
