/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An IP permission for an EC2 security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2SecurityGroupIpPermission implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2SecurityGroupIpPermission.Builder, AwsEc2SecurityGroupIpPermission> {
    private static final SdkField<String> IP_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpProtocol").getter(getter(AwsEc2SecurityGroupIpPermission::ipProtocol))
            .setter(setter(Builder::ipProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpProtocol").build()).build();

    private static final SdkField<Integer> FROM_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FromPort").getter(getter(AwsEc2SecurityGroupIpPermission::fromPort)).setter(setter(Builder::fromPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromPort").build()).build();

    private static final SdkField<Integer> TO_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ToPort").getter(getter(AwsEc2SecurityGroupIpPermission::toPort)).setter(setter(Builder::toPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToPort").build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupUserIdGroupPair>> USER_ID_GROUP_PAIRS_FIELD = SdkField
            .<List<AwsEc2SecurityGroupUserIdGroupPair>> builder(MarshallingType.LIST)
            .memberName("UserIdGroupPairs")
            .getter(getter(AwsEc2SecurityGroupIpPermission::userIdGroupPairs))
            .setter(setter(Builder::userIdGroupPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserIdGroupPairs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupUserIdGroupPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupUserIdGroupPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupIpRange>> IP_RANGES_FIELD = SdkField
            .<List<AwsEc2SecurityGroupIpRange>> builder(MarshallingType.LIST)
            .memberName("IpRanges")
            .getter(getter(AwsEc2SecurityGroupIpPermission::ipRanges))
            .setter(setter(Builder::ipRanges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupIpRange> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupIpRange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupIpv6Range>> IPV6_RANGES_FIELD = SdkField
            .<List<AwsEc2SecurityGroupIpv6Range>> builder(MarshallingType.LIST)
            .memberName("Ipv6Ranges")
            .getter(getter(AwsEc2SecurityGroupIpPermission::ipv6Ranges))
            .setter(setter(Builder::ipv6Ranges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Ranges").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupIpv6Range> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupIpv6Range::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEc2SecurityGroupPrefixListId>> PREFIX_LIST_IDS_FIELD = SdkField
            .<List<AwsEc2SecurityGroupPrefixListId>> builder(MarshallingType.LIST)
            .memberName("PrefixListIds")
            .getter(getter(AwsEc2SecurityGroupIpPermission::prefixListIds))
            .setter(setter(Builder::prefixListIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrefixListIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2SecurityGroupPrefixListId> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2SecurityGroupPrefixListId::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IP_PROTOCOL_FIELD, FROM_PORT_FIELD, TO_PORT_FIELD, USER_ID_GROUP_PAIRS_FIELD,
                    IP_RANGES_FIELD, IPV6_RANGES_FIELD, PREFIX_LIST_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipProtocol;

    private final Integer fromPort;

    private final Integer toPort;

    private final List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs;

    private final List<AwsEc2SecurityGroupIpRange> ipRanges;

    private final List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges;

    private final List<AwsEc2SecurityGroupPrefixListId> prefixListIds;

    private AwsEc2SecurityGroupIpPermission(BuilderImpl builder) {
        this.ipProtocol = builder.ipProtocol;
        this.fromPort = builder.fromPort;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipRanges = builder.ipRanges;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
    }

    /**
     * <p>
     * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.
     * </p>
     * <p>
     * [VPC only] Use <code>-1</code> to specify all protocols.
     * </p>
     * <p>
     * When authorizing security group rules, specifying -1 or a protocol number other than <code>tcp</code>,
     * <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any port
     * range you specify.
     * </p>
     * <p>
     * For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.
     * </p>
     * <p>
     * For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types and codes
     * is allowed.
     * </p>
     * 
     * @return The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
     *         number.</p>
     *         <p>
     *         [VPC only] Use <code>-1</code> to specify all protocols.
     *         </p>
     *         <p>
     *         When authorizing security group rules, specifying -1 or a protocol number other than <code>tcp</code>,
     *         <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of
     *         any port range you specify.
     *         </p>
     *         <p>
     *         For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.
     *         </p>
     *         <p>
     *         For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types
     *         and codes is allowed.
     */
    public final String ipProtocol() {
        return ipProtocol;
    }

    /**
     * <p>
     * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
     * </p>
     * <p>
     * A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * </p>
     * 
     * @return The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.</p>
     *         <p>
     *         A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all
     *         codes.
     */
    public final Integer fromPort() {
        return fromPort;
    }

    /**
     * <p>
     * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
     * </p>
     * <p>
     * A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     * </p>
     * 
     * @return The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.</p>
     *         <p>
     *         A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all
     *         codes.
     */
    public final Integer toPort() {
        return toPort;
    }

    /**
     * Returns true if the UserIdGroupPairs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasUserIdGroupPairs() {
        return userIdGroupPairs != null && !(userIdGroupPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The security group and AWS account ID pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserIdGroupPairs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The security group and AWS account ID pairs.
     */
    public final List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs() {
        return userIdGroupPairs;
    }

    /**
     * Returns true if the IpRanges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpRanges() {
        return ipRanges != null && !(ipRanges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpRanges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv4 ranges.
     */
    public final List<AwsEc2SecurityGroupIpRange> ipRanges() {
        return ipRanges;
    }

    /**
     * Returns true if the Ipv6Ranges property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIpv6Ranges() {
        return ipv6Ranges != null && !(ipv6Ranges instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv6 ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIpv6Ranges()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The IPv6 ranges.
     */
    public final List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges() {
        return ipv6Ranges;
    }

    /**
     * Returns true if the PrefixListIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPrefixListIds() {
        return prefixListIds != null && !(prefixListIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access through
     * a VPC endpoint from instances associated with the security group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrefixListIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
     *         through a VPC endpoint from instances associated with the security group.
     */
    public final List<AwsEc2SecurityGroupPrefixListId> prefixListIds() {
        return prefixListIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(toPort());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserIdGroupPairs() ? userIdGroupPairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRanges() ? ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Ranges() ? ipv6Ranges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrefixListIds() ? prefixListIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2SecurityGroupIpPermission)) {
            return false;
        }
        AwsEc2SecurityGroupIpPermission other = (AwsEc2SecurityGroupIpPermission) obj;
        return Objects.equals(ipProtocol(), other.ipProtocol()) && Objects.equals(fromPort(), other.fromPort())
                && Objects.equals(toPort(), other.toPort()) && hasUserIdGroupPairs() == other.hasUserIdGroupPairs()
                && Objects.equals(userIdGroupPairs(), other.userIdGroupPairs()) && hasIpRanges() == other.hasIpRanges()
                && Objects.equals(ipRanges(), other.ipRanges()) && hasIpv6Ranges() == other.hasIpv6Ranges()
                && Objects.equals(ipv6Ranges(), other.ipv6Ranges()) && hasPrefixListIds() == other.hasPrefixListIds()
                && Objects.equals(prefixListIds(), other.prefixListIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2SecurityGroupIpPermission").add("IpProtocol", ipProtocol()).add("FromPort", fromPort())
                .add("ToPort", toPort()).add("UserIdGroupPairs", hasUserIdGroupPairs() ? userIdGroupPairs() : null)
                .add("IpRanges", hasIpRanges() ? ipRanges() : null).add("Ipv6Ranges", hasIpv6Ranges() ? ipv6Ranges() : null)
                .add("PrefixListIds", hasPrefixListIds() ? prefixListIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpProtocol":
            return Optional.ofNullable(clazz.cast(ipProtocol()));
        case "FromPort":
            return Optional.ofNullable(clazz.cast(fromPort()));
        case "ToPort":
            return Optional.ofNullable(clazz.cast(toPort()));
        case "UserIdGroupPairs":
            return Optional.ofNullable(clazz.cast(userIdGroupPairs()));
        case "IpRanges":
            return Optional.ofNullable(clazz.cast(ipRanges()));
        case "Ipv6Ranges":
            return Optional.ofNullable(clazz.cast(ipv6Ranges()));
        case "PrefixListIds":
            return Optional.ofNullable(clazz.cast(prefixListIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2SecurityGroupIpPermission, T> g) {
        return obj -> g.apply((AwsEc2SecurityGroupIpPermission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2SecurityGroupIpPermission> {
        /**
         * <p>
         * The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or number.
         * </p>
         * <p>
         * [VPC only] Use <code>-1</code> to specify all protocols.
         * </p>
         * <p>
         * When authorizing security group rules, specifying -1 or a protocol number other than <code>tcp</code>,
         * <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of any
         * port range you specify.
         * </p>
         * <p>
         * For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.
         * </p>
         * <p>
         * For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types and
         * codes is allowed.
         * </p>
         * 
         * @param ipProtocol
         *        The IP protocol name (<code>tcp</code>, <code>udp</code>, <code>icmp</code>, <code>icmpv6</code>) or
         *        number.</p>
         *        <p>
         *        [VPC only] Use <code>-1</code> to specify all protocols.
         *        </p>
         *        <p>
         *        When authorizing security group rules, specifying -1 or a protocol number other than <code>tcp</code>,
         *        <code>udp</code>, <code>icmp</code>, or <code>icmpv6</code> allows traffic on all ports, regardless of
         *        any port range you specify.
         *        </p>
         *        <p>
         *        For <code>tcp</code>, <code>udp</code>, and <code>icmp</code>, you must specify a port range.
         *        </p>
         *        <p>
         *        For <code>icmpv6</code>, the port range is optional. If you omit the port range, traffic for all types
         *        and codes is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipProtocol(String ipProtocol);

        /**
         * <p>
         * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.
         * </p>
         * <p>
         * A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all
         * codes.
         * </p>
         * 
         * @param fromPort
         *        The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number.</p>
         *        <p>
         *        A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify
         *        all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromPort(Integer fromPort);

        /**
         * <p>
         * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.
         * </p>
         * <p>
         * A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all
         * codes.
         * </p>
         * 
         * @param toPort
         *        The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code.</p>
         *        <p>
         *        A value of -1 indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify
         *        all codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toPort(Integer toPort);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * 
         * @param userIdGroupPairs
         *        The security group and AWS account ID pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userIdGroupPairs(AwsEc2SecurityGroupUserIdGroupPair... userIdGroupPairs);

        /**
         * <p>
         * The security group and AWS account ID pairs.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEc2SecurityGroupUserIdGroupPair>.Builder} avoiding the need to create one manually via {@link List
         * <AwsEc2SecurityGroupUserIdGroupPair>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupUserIdGroupPair>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #userIdGroupPairs(List<AwsEc2SecurityGroupUserIdGroupPair>)}.
         * 
         * @param userIdGroupPairs
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupUserIdGroupPair>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userIdGroupPairs(List<AwsEc2SecurityGroupUserIdGroupPair>)
         */
        Builder userIdGroupPairs(Consumer<AwsEc2SecurityGroupUserIdGroupPair.Builder>... userIdGroupPairs);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * 
         * @param ipRanges
         *        The IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(Collection<AwsEc2SecurityGroupIpRange> ipRanges);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * 
         * @param ipRanges
         *        The IPv4 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRanges(AwsEc2SecurityGroupIpRange... ipRanges);

        /**
         * <p>
         * The IPv4 ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2SecurityGroupIpRange>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2SecurityGroupIpRange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupIpRange>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipRanges(List<AwsEc2SecurityGroupIpRange>)}.
         * 
         * @param ipRanges
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupIpRange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRanges(List<AwsEc2SecurityGroupIpRange>)
         */
        Builder ipRanges(Consumer<AwsEc2SecurityGroupIpRange.Builder>... ipRanges);

        /**
         * <p>
         * The IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        The IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range> ipv6Ranges);

        /**
         * <p>
         * The IPv6 ranges.
         * </p>
         * 
         * @param ipv6Ranges
         *        The IPv6 ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Ranges(AwsEc2SecurityGroupIpv6Range... ipv6Ranges);

        /**
         * <p>
         * The IPv6 ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2SecurityGroupIpv6Range>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2SecurityGroupIpv6Range>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupIpv6Range>.Builder#build()} is called
         * immediately and its result is passed to {@link #ipv6Ranges(List<AwsEc2SecurityGroupIpv6Range>)}.
         * 
         * @param ipv6Ranges
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupIpv6Range>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Ranges(List<AwsEc2SecurityGroupIpv6Range>)
         */
        Builder ipv6Ranges(Consumer<AwsEc2SecurityGroupIpv6Range.Builder>... ipv6Ranges);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to
         *        access through a VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(Collection<AwsEc2SecurityGroupPrefixListId> prefixListIds);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * 
         * @param prefixListIds
         *        [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to
         *        access through a VPC endpoint from instances associated with the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefixListIds(AwsEc2SecurityGroupPrefixListId... prefixListIds);

        /**
         * <p>
         * [VPC only] The prefix list IDs for an AWS service. With outbound rules, this is the AWS service to access
         * through a VPC endpoint from instances associated with the security group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsEc2SecurityGroupPrefixListId>.Builder}
         * avoiding the need to create one manually via {@link List<AwsEc2SecurityGroupPrefixListId>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsEc2SecurityGroupPrefixListId>.Builder#build()} is called
         * immediately and its result is passed to {@link #prefixListIds(List<AwsEc2SecurityGroupPrefixListId>)}.
         * 
         * @param prefixListIds
         *        a consumer that will call methods on {@link List<AwsEc2SecurityGroupPrefixListId>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #prefixListIds(List<AwsEc2SecurityGroupPrefixListId>)
         */
        Builder prefixListIds(Consumer<AwsEc2SecurityGroupPrefixListId.Builder>... prefixListIds);
    }

    static final class BuilderImpl implements Builder {
        private String ipProtocol;

        private Integer fromPort;

        private Integer toPort;

        private List<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEc2SecurityGroupIpRange> ipRanges = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEc2SecurityGroupIpv6Range> ipv6Ranges = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEc2SecurityGroupPrefixListId> prefixListIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2SecurityGroupIpPermission model) {
            ipProtocol(model.ipProtocol);
            fromPort(model.fromPort);
            toPort(model.toPort);
            userIdGroupPairs(model.userIdGroupPairs);
            ipRanges(model.ipRanges);
            ipv6Ranges(model.ipv6Ranges);
            prefixListIds(model.prefixListIds);
        }

        public final String getIpProtocol() {
            return ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Integer getFromPort() {
            return fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final Integer getToPort() {
            return toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final List<AwsEc2SecurityGroupUserIdGroupPair.Builder> getUserIdGroupPairs() {
            List<AwsEc2SecurityGroupUserIdGroupPair.Builder> result = AwsEc2SecurityGroupUserIdGroupPairListCopier
                    .copyToBuilder(this.userIdGroupPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = AwsEc2SecurityGroupUserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(AwsEc2SecurityGroupUserIdGroupPair... userIdGroupPairs) {
            userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<AwsEc2SecurityGroupUserIdGroupPair.Builder>... userIdGroupPairs) {
            userIdGroupPairs(Stream.of(userIdGroupPairs)
                    .map(c -> AwsEc2SecurityGroupUserIdGroupPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<AwsEc2SecurityGroupUserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = AwsEc2SecurityGroupUserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        public final List<AwsEc2SecurityGroupIpRange.Builder> getIpRanges() {
            List<AwsEc2SecurityGroupIpRange.Builder> result = AwsEc2SecurityGroupIpRangeListCopier.copyToBuilder(this.ipRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipRanges(Collection<AwsEc2SecurityGroupIpRange> ipRanges) {
            this.ipRanges = AwsEc2SecurityGroupIpRangeListCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(AwsEc2SecurityGroupIpRange... ipRanges) {
            ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<AwsEc2SecurityGroupIpRange.Builder>... ipRanges) {
            ipRanges(Stream.of(ipRanges).map(c -> AwsEc2SecurityGroupIpRange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpRanges(Collection<AwsEc2SecurityGroupIpRange.BuilderImpl> ipRanges) {
            this.ipRanges = AwsEc2SecurityGroupIpRangeListCopier.copyFromBuilder(ipRanges);
        }

        public final List<AwsEc2SecurityGroupIpv6Range.Builder> getIpv6Ranges() {
            List<AwsEc2SecurityGroupIpv6Range.Builder> result = AwsEc2SecurityGroupIpv6RangeListCopier
                    .copyToBuilder(this.ipv6Ranges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder ipv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range> ipv6Ranges) {
            this.ipv6Ranges = AwsEc2SecurityGroupIpv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(AwsEc2SecurityGroupIpv6Range... ipv6Ranges) {
            ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Consumer<AwsEc2SecurityGroupIpv6Range.Builder>... ipv6Ranges) {
            ipv6Ranges(Stream.of(ipv6Ranges).map(c -> AwsEc2SecurityGroupIpv6Range.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Ranges(Collection<AwsEc2SecurityGroupIpv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = AwsEc2SecurityGroupIpv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final List<AwsEc2SecurityGroupPrefixListId.Builder> getPrefixListIds() {
            List<AwsEc2SecurityGroupPrefixListId.Builder> result = AwsEc2SecurityGroupPrefixListIdListCopier
                    .copyToBuilder(this.prefixListIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder prefixListIds(Collection<AwsEc2SecurityGroupPrefixListId> prefixListIds) {
            this.prefixListIds = AwsEc2SecurityGroupPrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(AwsEc2SecurityGroupPrefixListId... prefixListIds) {
            prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(Consumer<AwsEc2SecurityGroupPrefixListId.Builder>... prefixListIds) {
            prefixListIds(Stream.of(prefixListIds).map(c -> AwsEc2SecurityGroupPrefixListId.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixListIds(Collection<AwsEc2SecurityGroupPrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = AwsEc2SecurityGroupPrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        @Override
        public AwsEc2SecurityGroupIpPermission build() {
            return new AwsEc2SecurityGroupIpPermission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
