/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default capacity provider strategy for the cluster. The default capacity provider strategy is used when services
 * or tasks are run without a specified launch type or capacity provider strategy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsClusterDefaultCapacityProviderStrategyDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder, AwsEcsClusterDefaultCapacityProviderStrategyDetails> {
    private static final SdkField<Integer> BASE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Base")
            .getter(getter(AwsEcsClusterDefaultCapacityProviderStrategyDetails::base)).setter(setter(Builder::base))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Base").build()).build();

    private static final SdkField<String> CAPACITY_PROVIDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityProvider").getter(getter(AwsEcsClusterDefaultCapacityProviderStrategyDetails::capacityProvider))
            .setter(setter(Builder::capacityProvider))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProvider").build()).build();

    private static final SdkField<Integer> WEIGHT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Weight").getter(getter(AwsEcsClusterDefaultCapacityProviderStrategyDetails::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_FIELD,
            CAPACITY_PROVIDER_FIELD, WEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer base;

    private final String capacityProvider;

    private final Integer weight;

    private AwsEcsClusterDefaultCapacityProviderStrategyDetails(BuilderImpl builder) {
        this.base = builder.base;
        this.capacityProvider = builder.capacityProvider;
        this.weight = builder.weight;
    }

    /**
     * <p>
     * The minimum number of tasks to run on the specified capacity provider.
     * </p>
     * 
     * @return The minimum number of tasks to run on the specified capacity provider.
     */
    public final Integer base() {
        return base;
    }

    /**
     * <p>
     * The name of the capacity provider.
     * </p>
     * 
     * @return The name of the capacity provider.
     */
    public final String capacityProvider() {
        return capacityProvider;
    }

    /**
     * <p>
     * The relative percentage of the total number of tasks launched that should use the capacity provider.
     * </p>
     * 
     * @return The relative percentage of the total number of tasks launched that should use the capacity provider.
     */
    public final Integer weight() {
        return weight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(base());
        hashCode = 31 * hashCode + Objects.hashCode(capacityProvider());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterDefaultCapacityProviderStrategyDetails)) {
            return false;
        }
        AwsEcsClusterDefaultCapacityProviderStrategyDetails other = (AwsEcsClusterDefaultCapacityProviderStrategyDetails) obj;
        return Objects.equals(base(), other.base()) && Objects.equals(capacityProvider(), other.capacityProvider())
                && Objects.equals(weight(), other.weight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsClusterDefaultCapacityProviderStrategyDetails").add("Base", base())
                .add("CapacityProvider", capacityProvider()).add("Weight", weight()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Base":
            return Optional.ofNullable(clazz.cast(base()));
        case "CapacityProvider":
            return Optional.ofNullable(clazz.cast(capacityProvider()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsClusterDefaultCapacityProviderStrategyDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterDefaultCapacityProviderStrategyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsClusterDefaultCapacityProviderStrategyDetails> {
        /**
         * <p>
         * The minimum number of tasks to run on the specified capacity provider.
         * </p>
         * 
         * @param base
         *        The minimum number of tasks to run on the specified capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder base(Integer base);

        /**
         * <p>
         * The name of the capacity provider.
         * </p>
         * 
         * @param capacityProvider
         *        The name of the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProvider(String capacityProvider);

        /**
         * <p>
         * The relative percentage of the total number of tasks launched that should use the capacity provider.
         * </p>
         * 
         * @param weight
         *        The relative percentage of the total number of tasks launched that should use the capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Integer weight);
    }

    static final class BuilderImpl implements Builder {
        private Integer base;

        private String capacityProvider;

        private Integer weight;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterDefaultCapacityProviderStrategyDetails model) {
            base(model.base);
            capacityProvider(model.capacityProvider);
            weight(model.weight);
        }

        public final Integer getBase() {
            return base;
        }

        @Override
        public final Builder base(Integer base) {
            this.base = base;
            return this;
        }

        public final void setBase(Integer base) {
            this.base = base;
        }

        public final String getCapacityProvider() {
            return capacityProvider;
        }

        @Override
        public final Builder capacityProvider(String capacityProvider) {
            this.capacityProvider = capacityProvider;
            return this;
        }

        public final void setCapacityProvider(String capacityProvider) {
            this.capacityProvider = capacityProvider;
        }

        public final Integer getWeight() {
            return weight;
        }

        @Override
        public final Builder weight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public final void setWeight(Integer weight) {
            this.weight = weight;
        }

        @Override
        public AwsEcsClusterDefaultCapacityProviderStrategyDetails build() {
            return new AwsEcsClusterDefaultCapacityProviderStrategyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
