/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container health check command and associated configuration parameters for the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails> {
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Command")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::command))
            .setter(setter(Builder::command))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Interval").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::interval))
            .setter(setter(Builder::interval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Interval").build()).build();

    private static final SdkField<Integer> RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Retries").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::retries))
            .setter(setter(Builder::retries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retries").build()).build();

    private static final SdkField<Integer> START_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartPeriod").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::startPeriod))
            .setter(setter(Builder::startPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPeriod").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails::timeout))
            .setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_FIELD, INTERVAL_FIELD,
            RETRIES_FIELD, START_PERIOD_FIELD, TIMEOUT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> command;

    private final Integer interval;

    private final Integer retries;

    private final Integer startPeriod;

    private final Integer timeout;

    private AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(BuilderImpl builder) {
        this.command = builder.command;
        this.interval = builder.interval;
        this.retries = builder.retries;
        this.startPeriod = builder.startPeriod;
        this.timeout = builder.timeout;
    }

    /**
     * Returns true if the Command property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCommand() {
        return command != null && !(command instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The command that the container runs to determine whether it is healthy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCommand()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The command that the container runs to determine whether it is healthy.
     */
    public final List<String> command() {
        return command;
    }

    /**
     * <p>
     * The time period in seconds between each health check execution. The default value is 30 seconds.
     * </p>
     * 
     * @return The time period in seconds between each health check execution. The default value is 30 seconds.
     */
    public final Integer interval() {
        return interval;
    }

    /**
     * <p>
     * The number of times to retry a failed health check before the container is considered unhealthy. The default
     * value is 3.
     * </p>
     * 
     * @return The number of times to retry a failed health check before the container is considered unhealthy. The
     *         default value is 3.
     */
    public final Integer retries() {
        return retries;
    }

    /**
     * <p>
     * The optional grace period in seconds that allows containers time to bootstrap before failed health checks count
     * towards the maximum number of retries.
     * </p>
     * 
     * @return The optional grace period in seconds that allows containers time to bootstrap before failed health checks
     *         count towards the maximum number of retries.
     */
    public final Integer startPeriod() {
        return startPeriod;
    }

    /**
     * <p>
     * The time period in seconds to wait for a health check to succeed before it is considered a failure. The default
     * value is 5.
     * </p>
     * 
     * @return The time period in seconds to wait for a health check to succeed before it is considered a failure. The
     *         default value is 5.
     */
    public final Integer timeout() {
        return timeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCommand() ? command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interval());
        hashCode = 31 * hashCode + Objects.hashCode(retries());
        hashCode = 31 * hashCode + Objects.hashCode(startPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails other = (AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) obj;
        return hasCommand() == other.hasCommand() && Objects.equals(command(), other.command())
                && Objects.equals(interval(), other.interval()) && Objects.equals(retries(), other.retries())
                && Objects.equals(startPeriod(), other.startPeriod()) && Objects.equals(timeout(), other.timeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails")
                .add("Command", hasCommand() ? command() : null).add("Interval", interval()).add("Retries", retries())
                .add("StartPeriod", startPeriod()).add("Timeout", timeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Interval":
            return Optional.ofNullable(clazz.cast(interval()));
        case "Retries":
            return Optional.ofNullable(clazz.cast(retries()));
        case "StartPeriod":
            return Optional.ofNullable(clazz.cast(startPeriod()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails> {
        /**
         * <p>
         * The command that the container runs to determine whether it is healthy.
         * </p>
         * 
         * @param command
         *        The command that the container runs to determine whether it is healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(Collection<String> command);

        /**
         * <p>
         * The command that the container runs to determine whether it is healthy.
         * </p>
         * 
         * @param command
         *        The command that the container runs to determine whether it is healthy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(String... command);

        /**
         * <p>
         * The time period in seconds between each health check execution. The default value is 30 seconds.
         * </p>
         * 
         * @param interval
         *        The time period in seconds between each health check execution. The default value is 30 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interval(Integer interval);

        /**
         * <p>
         * The number of times to retry a failed health check before the container is considered unhealthy. The default
         * value is 3.
         * </p>
         * 
         * @param retries
         *        The number of times to retry a failed health check before the container is considered unhealthy. The
         *        default value is 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retries(Integer retries);

        /**
         * <p>
         * The optional grace period in seconds that allows containers time to bootstrap before failed health checks
         * count towards the maximum number of retries.
         * </p>
         * 
         * @param startPeriod
         *        The optional grace period in seconds that allows containers time to bootstrap before failed health
         *        checks count towards the maximum number of retries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startPeriod(Integer startPeriod);

        /**
         * <p>
         * The time period in seconds to wait for a health check to succeed before it is considered a failure. The
         * default value is 5.
         * </p>
         * 
         * @param timeout
         *        The time period in seconds to wait for a health check to succeed before it is considered a failure.
         *        The default value is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);
    }

    static final class BuilderImpl implements Builder {
        private List<String> command = DefaultSdkAutoConstructList.getInstance();

        private Integer interval;

        private Integer retries;

        private Integer startPeriod;

        private Integer timeout;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails model) {
            command(model.command);
            interval(model.interval);
            retries(model.retries);
            startPeriod(model.startPeriod);
            timeout(model.timeout);
        }

        public final Collection<String> getCommand() {
            if (command instanceof SdkAutoConstructList) {
                return null;
            }
            return command;
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = NonEmptyStringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String... command) {
            command(Arrays.asList(command));
            return this;
        }

        public final void setCommand(Collection<String> command) {
            this.command = NonEmptyStringListCopier.copy(command);
        }

        public final Integer getInterval() {
            return interval;
        }

        @Override
        public final Builder interval(Integer interval) {
            this.interval = interval;
            return this;
        }

        public final void setInterval(Integer interval) {
            this.interval = interval;
        }

        public final Integer getRetries() {
            return retries;
        }

        @Override
        public final Builder retries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public final void setRetries(Integer retries) {
            this.retries = retries;
        }

        public final Integer getStartPeriod() {
            return startPeriod;
        }

        @Override
        public final Builder startPeriod(Integer startPeriod) {
            this.startPeriod = startPeriod;
            return this;
        }

        public final void setStartPeriod(Integer startPeriod) {
            this.startPeriod = startPeriod;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
