/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log configuration specification for the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails> {
    private static final SdkField<String> LOG_DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogDriver").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails::logDriver))
            .setter(setter(Builder::logDriver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDriver").build()).build();

    private static final SdkField<Map<String, String>> OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Options")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>> SECRET_OPTIONS_FIELD = SdkField
            .<List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>> builder(MarshallingType.LIST)
            .memberName("SecretOptions")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails::secretOptions))
            .setter(setter(Builder::secretOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DRIVER_FIELD,
            OPTIONS_FIELD, SECRET_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logDriver;

    private final Map<String, String> options;

    private final List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> secretOptions;

    private AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(BuilderImpl builder) {
        this.logDriver = builder.logDriver;
        this.options = builder.options;
        this.secretOptions = builder.secretOptions;
    }

    /**
     * <p>
     * The log driver to use for the container.
     * </p>
     * 
     * @return The log driver to use for the container.
     */
    public final String logDriver() {
        return logDriver;
    }

    /**
     * Returns true if the Options property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or greater on
     * your container instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or
     *         greater on your container instance.
     */
    public final Map<String, String> options() {
        return options;
    }

    /**
     * Returns true if the SecretOptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSecretOptions() {
        return secretOptions != null && !(secretOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The secrets to pass to the log configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSecretOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The secrets to pass to the log configuration.
     */
    public final List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> secretOptions() {
        return secretOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logDriver());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecretOptions() ? secretOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails other = (AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) obj;
        return Objects.equals(logDriver(), other.logDriver()) && hasOptions() == other.hasOptions()
                && Objects.equals(options(), other.options()) && hasSecretOptions() == other.hasSecretOptions()
                && Objects.equals(secretOptions(), other.secretOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails").add("LogDriver", logDriver())
                .add("Options", hasOptions() ? options() : null)
                .add("SecretOptions", hasSecretOptions() ? secretOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogDriver":
            return Optional.ofNullable(clazz.cast(logDriver()));
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "SecretOptions":
            return Optional.ofNullable(clazz.cast(secretOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails> {
        /**
         * <p>
         * The log driver to use for the container.
         * </p>
         * 
         * @param logDriver
         *        The log driver to use for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDriver(String logDriver);

        /**
         * <p>
         * The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or
         * greater on your container instance.
         * </p>
         * 
         * @param options
         *        The configuration options to send to the log driver. Requires version 1.19 of the Docker Remote API or
         *        greater on your container instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Map<String, String> options);

        /**
         * <p>
         * The secrets to pass to the log configuration.
         * </p>
         * 
         * @param secretOptions
         *        The secrets to pass to the log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretOptions(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> secretOptions);

        /**
         * <p>
         * The secrets to pass to the log configuration.
         * </p>
         * 
         * @param secretOptions
         *        The secrets to pass to the log configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretOptions(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails... secretOptions);

        /**
         * <p>
         * The secrets to pass to the log configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>.Builder} avoiding the need to
         * create one manually via {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #secretOptions(List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>)}.
         * 
         * @param secretOptions
         *        a consumer that will call methods on {@link List
         *        <AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretOptions(List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails>)
         */
        Builder secretOptions(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.Builder>... secretOptions);
    }

    static final class BuilderImpl implements Builder {
        private String logDriver;

        private Map<String, String> options = DefaultSdkAutoConstructMap.getInstance();

        private List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> secretOptions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails model) {
            logDriver(model.logDriver);
            options(model.options);
            secretOptions(model.secretOptions);
        }

        public final String getLogDriver() {
            return logDriver;
        }

        @Override
        public final Builder logDriver(String logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        public final void setLogDriver(String logDriver) {
            this.logDriver = logDriver;
        }

        public final Map<String, String> getOptions() {
            if (options instanceof SdkAutoConstructMap) {
                return null;
            }
            return options;
        }

        @Override
        public final Builder options(Map<String, String> options) {
            this.options = FieldMapCopier.copy(options);
            return this;
        }

        public final void setOptions(Map<String, String> options) {
            this.options = FieldMapCopier.copy(options);
        }

        public final List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.Builder> getSecretOptions() {
            List<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.Builder> result = AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsListCopier
                    .copyToBuilder(this.secretOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder secretOptions(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails> secretOptions) {
            this.secretOptions = AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsListCopier
                    .copy(secretOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretOptions(
                AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails... secretOptions) {
            secretOptions(Arrays.asList(secretOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secretOptions(
                Consumer<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.Builder>... secretOptions) {
            secretOptions(Stream
                    .of(secretOptions)
                    .map(c -> AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.builder()
                            .applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSecretOptions(
                Collection<AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsDetails.BuilderImpl> secretOptions) {
            this.secretOptions = AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationSecretOptionsListCopier
                    .copyFromBuilder(secretOptions);
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
