/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A port mapping for the container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> {
    private static final SdkField<Integer> CONTAINER_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ContainerPort")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails::containerPort))
            .setter(setter(Builder::containerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerPort").build()).build();

    private static final SdkField<Integer> HOST_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HostPort").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails::hostPort))
            .setter(setter(Builder::hostPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostPort").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails::protocol))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_PORT_FIELD,
            HOST_PORT_FIELD, PROTOCOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer containerPort;

    private final Integer hostPort;

    private final String protocol;

    private AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(BuilderImpl builder) {
        this.containerPort = builder.containerPort;
        this.hostPort = builder.hostPort;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The port number on the container that is bound to the user-specified or automatically assigned host port.
     * </p>
     * 
     * @return The port number on the container that is bound to the user-specified or automatically assigned host port.
     */
    public final Integer containerPort() {
        return containerPort;
    }

    /**
     * <p>
     * The port number on the container instance to reserve for the container.
     * </p>
     * 
     * @return The port number on the container instance to reserve for the container.
     */
    public final Integer hostPort() {
        return hostPort;
    }

    /**
     * <p>
     * The protocol used for the port mapping. The default is <code>tcp</code>.
     * </p>
     * 
     * @return The protocol used for the port mapping. The default is <code>tcp</code>.
     */
    public final String protocol() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerPort());
        hashCode = 31 * hashCode + Objects.hashCode(hostPort());
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) obj;
        return Objects.equals(containerPort(), other.containerPort()) && Objects.equals(hostPort(), other.hostPort())
                && Objects.equals(protocol(), other.protocol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails")
                .add("ContainerPort", containerPort()).add("HostPort", hostPort()).add("Protocol", protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerPort":
            return Optional.ofNullable(clazz.cast(containerPort()));
        case "HostPort":
            return Optional.ofNullable(clazz.cast(hostPort()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails> {
        /**
         * <p>
         * The port number on the container that is bound to the user-specified or automatically assigned host port.
         * </p>
         * 
         * @param containerPort
         *        The port number on the container that is bound to the user-specified or automatically assigned host
         *        port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerPort(Integer containerPort);

        /**
         * <p>
         * The port number on the container instance to reserve for the container.
         * </p>
         * 
         * @param hostPort
         *        The port number on the container instance to reserve for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostPort(Integer hostPort);

        /**
         * <p>
         * The protocol used for the port mapping. The default is <code>tcp</code>.
         * </p>
         * 
         * @param protocol
         *        The protocol used for the port mapping. The default is <code>tcp</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);
    }

    static final class BuilderImpl implements Builder {
        private Integer containerPort;

        private Integer hostPort;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails model) {
            containerPort(model.containerPort);
            hostPort(model.hostPort);
            protocol(model.protocol);
        }

        public final Integer getContainerPort() {
            return containerPort;
        }

        @Override
        public final Builder containerPort(Integer containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        public final void setContainerPort(Integer containerPort) {
            this.containerPort = containerPort;
        }

        public final Integer getHostPort() {
            return hostPort;
        }

        @Override
        public final Builder hostPort(Integer hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        public final void setHostPort(Integer hostPort) {
            this.hostPort = hostPort;
        }

        public final String getProtocol() {
            return protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
