/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource to assign to a container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String value;

    private AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
    }

    /**
     * <p>
     * The type of resource to assign to a container.
     * </p>
     * 
     * @return The type of resource to assign to a container.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The value for the specified resource type.
     * </p>
     * <p>
     * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for the
     * container.
     * </p>
     * <p>
     * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an entry
     * in <code>InferenceAccelerators</code>.
     * </p>
     * 
     * @return The value for the specified resource type.</p>
     *         <p>
     *         For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves
     *         for the container.
     *         </p>
     *         <p>
     *         For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an
     *         entry in <code>InferenceAccelerators</code>.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails").add("Type", type())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails> {
        /**
         * <p>
         * The type of resource to assign to a container.
         * </p>
         * 
         * @param type
         *        The type of resource to assign to a container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The value for the specified resource type.
         * </p>
         * <p>
         * For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves for
         * the container.
         * </p>
         * <p>
         * For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of an
         * entry in <code>InferenceAccelerators</code>.
         * </p>
         * 
         * @param value
         *        The value for the specified resource type.</p>
         *        <p>
         *        For <code>GPU</code>, the value is the number of physical GPUs the Amazon ECS container agent reserves
         *        for the container.
         *        </p>
         *        <p>
         *        For <code>InferenceAccelerator</code>, the value should match the <code>DeviceName</code> attribute of
         *        an entry in <code>InferenceAccelerators</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails model) {
            type(model.type);
            value(model.value);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
