/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Elastic Inference accelerator to use for the containers in the task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionInferenceAcceleratorsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder, AwsEcsTaskDefinitionInferenceAcceleratorsDetails> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(AwsEcsTaskDefinitionInferenceAcceleratorsDetails::deviceName))
            .setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceType").getter(getter(AwsEcsTaskDefinitionInferenceAcceleratorsDetails::deviceType))
            .setter(setter(Builder::deviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            DEVICE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String deviceType;

    private AwsEcsTaskDefinitionInferenceAcceleratorsDetails(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.deviceType = builder.deviceType;
    }

    /**
     * <p>
     * The Elastic Inference accelerator device name.
     * </p>
     * 
     * @return The Elastic Inference accelerator device name.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The Elastic Inference accelerator type to use.
     * </p>
     * 
     * @return The Elastic Inference accelerator type to use.
     */
    public final String deviceType() {
        return deviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionInferenceAcceleratorsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionInferenceAcceleratorsDetails other = (AwsEcsTaskDefinitionInferenceAcceleratorsDetails) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(deviceType(), other.deviceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionInferenceAcceleratorsDetails").add("DeviceName", deviceName())
                .add("DeviceType", deviceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DeviceType":
            return Optional.ofNullable(clazz.cast(deviceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionInferenceAcceleratorsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionInferenceAcceleratorsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionInferenceAcceleratorsDetails> {
        /**
         * <p>
         * The Elastic Inference accelerator device name.
         * </p>
         * 
         * @param deviceName
         *        The Elastic Inference accelerator device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The Elastic Inference accelerator type to use.
         * </p>
         * 
         * @param deviceType
         *        The Elastic Inference accelerator type to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceType(String deviceType);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String deviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionInferenceAcceleratorsDetails model) {
            deviceName(model.deviceName);
            deviceType(model.deviceType);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDeviceType() {
            return deviceType;
        }

        @Override
        public final Builder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @Override
        public AwsEcsTaskDefinitionInferenceAcceleratorsDetails build() {
            return new AwsEcsTaskDefinitionInferenceAcceleratorsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
