/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data volume to mount from another container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionVolumesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionVolumesDetails.Builder, AwsEcsTaskDefinitionVolumesDetails> {
    private static final SdkField<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> DOCKER_VOLUME_CONFIGURATION_FIELD = SdkField
            .<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DockerVolumeConfiguration")
            .getter(getter(AwsEcsTaskDefinitionVolumesDetails::dockerVolumeConfiguration))
            .setter(setter(Builder::dockerVolumeConfiguration))
            .constructor(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DockerVolumeConfiguration").build())
            .build();

    private static final SdkField<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails> EFS_VOLUME_CONFIGURATION_FIELD = SdkField
            .<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EfsVolumeConfiguration").getter(getter(AwsEcsTaskDefinitionVolumesDetails::efsVolumeConfiguration))
            .setter(setter(Builder::efsVolumeConfiguration))
            .constructor(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EfsVolumeConfiguration").build())
            .build();

    private static final SdkField<AwsEcsTaskDefinitionVolumesHostDetails> HOST_FIELD = SdkField
            .<AwsEcsTaskDefinitionVolumesHostDetails> builder(MarshallingType.SDK_POJO).memberName("Host")
            .getter(getter(AwsEcsTaskDefinitionVolumesDetails::host)).setter(setter(Builder::host))
            .constructor(AwsEcsTaskDefinitionVolumesHostDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsTaskDefinitionVolumesDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOCKER_VOLUME_CONFIGURATION_FIELD, EFS_VOLUME_CONFIGURATION_FIELD, HOST_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails dockerVolumeConfiguration;

    private final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails efsVolumeConfiguration;

    private final AwsEcsTaskDefinitionVolumesHostDetails host;

    private final String name;

    private AwsEcsTaskDefinitionVolumesDetails(BuilderImpl builder) {
        this.dockerVolumeConfiguration = builder.dockerVolumeConfiguration;
        this.efsVolumeConfiguration = builder.efsVolumeConfiguration;
        this.host = builder.host;
        this.name = builder.name;
    }

    /**
     * <p>
     * Information about a Docker volume.
     * </p>
     * 
     * @return Information about a Docker volume.
     */
    public final AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails dockerVolumeConfiguration() {
        return dockerVolumeConfiguration;
    }

    /**
     * <p>
     * Information about the Amazon Elastic File System file system that is used for task storage.
     * </p>
     * 
     * @return Information about the Amazon Elastic File System file system that is used for task storage.
     */
    public final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails efsVolumeConfiguration() {
        return efsVolumeConfiguration;
    }

    /**
     * <p>
     * Information about a bind mount host volume.
     * </p>
     * 
     * @return Information about a bind mount host volume.
     */
    public final AwsEcsTaskDefinitionVolumesHostDetails host() {
        return host;
    }

    /**
     * <p>
     * The name of the data volume.
     * </p>
     * 
     * @return The name of the data volume.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dockerVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(efsVolumeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionVolumesDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionVolumesDetails other = (AwsEcsTaskDefinitionVolumesDetails) obj;
        return Objects.equals(dockerVolumeConfiguration(), other.dockerVolumeConfiguration())
                && Objects.equals(efsVolumeConfiguration(), other.efsVolumeConfiguration())
                && Objects.equals(host(), other.host()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionVolumesDetails")
                .add("DockerVolumeConfiguration", dockerVolumeConfiguration())
                .add("EfsVolumeConfiguration", efsVolumeConfiguration()).add("Host", host()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DockerVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(dockerVolumeConfiguration()));
        case "EfsVolumeConfiguration":
            return Optional.ofNullable(clazz.cast(efsVolumeConfiguration()));
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionVolumesDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionVolumesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesDetails> {
        /**
         * <p>
         * Information about a Docker volume.
         * </p>
         * 
         * @param dockerVolumeConfiguration
         *        Information about a Docker volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dockerVolumeConfiguration(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails dockerVolumeConfiguration);

        /**
         * <p>
         * Information about a Docker volume.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #dockerVolumeConfiguration(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)}.
         * 
         * @param dockerVolumeConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dockerVolumeConfiguration(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)
         */
        default Builder dockerVolumeConfiguration(
                Consumer<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder> dockerVolumeConfiguration) {
            return dockerVolumeConfiguration(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.builder()
                    .applyMutation(dockerVolumeConfiguration).build());
        }

        /**
         * <p>
         * Information about the Amazon Elastic File System file system that is used for task storage.
         * </p>
         * 
         * @param efsVolumeConfiguration
         *        Information about the Amazon Elastic File System file system that is used for task storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efsVolumeConfiguration(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails efsVolumeConfiguration);

        /**
         * <p>
         * Information about the Amazon Elastic File System file system that is used for task storage.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #efsVolumeConfiguration(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)}.
         * 
         * @param efsVolumeConfiguration
         *        a consumer that will call methods on
         *        {@link AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efsVolumeConfiguration(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails)
         */
        default Builder efsVolumeConfiguration(
                Consumer<AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder> efsVolumeConfiguration) {
            return efsVolumeConfiguration(AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.builder()
                    .applyMutation(efsVolumeConfiguration).build());
        }

        /**
         * <p>
         * Information about a bind mount host volume.
         * </p>
         * 
         * @param host
         *        Information about a bind mount host volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(AwsEcsTaskDefinitionVolumesHostDetails host);

        /**
         * <p>
         * Information about a bind mount host volume.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsEcsTaskDefinitionVolumesHostDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEcsTaskDefinitionVolumesHostDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsEcsTaskDefinitionVolumesHostDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #host(AwsEcsTaskDefinitionVolumesHostDetails)}.
         * 
         * @param host
         *        a consumer that will call methods on {@link AwsEcsTaskDefinitionVolumesHostDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #host(AwsEcsTaskDefinitionVolumesHostDetails)
         */
        default Builder host(Consumer<AwsEcsTaskDefinitionVolumesHostDetails.Builder> host) {
            return host(AwsEcsTaskDefinitionVolumesHostDetails.builder().applyMutation(host).build());
        }

        /**
         * <p>
         * The name of the data volume.
         * </p>
         * 
         * @param name
         *        The name of the data volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails dockerVolumeConfiguration;

        private AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails efsVolumeConfiguration;

        private AwsEcsTaskDefinitionVolumesHostDetails host;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionVolumesDetails model) {
            dockerVolumeConfiguration(model.dockerVolumeConfiguration);
            efsVolumeConfiguration(model.efsVolumeConfiguration);
            host(model.host);
            name(model.name);
        }

        public final AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder getDockerVolumeConfiguration() {
            return dockerVolumeConfiguration != null ? dockerVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dockerVolumeConfiguration(
                AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration;
            return this;
        }

        public final void setDockerVolumeConfiguration(
                AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.BuilderImpl dockerVolumeConfiguration) {
            this.dockerVolumeConfiguration = dockerVolumeConfiguration != null ? dockerVolumeConfiguration.build() : null;
        }

        public final AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.Builder getEfsVolumeConfiguration() {
            return efsVolumeConfiguration != null ? efsVolumeConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder efsVolumeConfiguration(
                AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration;
            return this;
        }

        public final void setEfsVolumeConfiguration(
                AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails.BuilderImpl efsVolumeConfiguration) {
            this.efsVolumeConfiguration = efsVolumeConfiguration != null ? efsVolumeConfiguration.build() : null;
        }

        public final AwsEcsTaskDefinitionVolumesHostDetails.Builder getHost() {
            return host != null ? host.toBuilder() : null;
        }

        @Override
        public final Builder host(AwsEcsTaskDefinitionVolumesHostDetails host) {
            this.host = host;
            return this;
        }

        public final void setHost(AwsEcsTaskDefinitionVolumesHostDetails.BuilderImpl host) {
            this.host = host != null ? host.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public AwsEcsTaskDefinitionVolumesDetails build() {
            return new AwsEcsTaskDefinitionVolumesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
