/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Docker volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.Builder, AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> {
    private static final SdkField<Boolean> AUTOPROVISION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Autoprovision")
            .getter(getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::autoprovision))
            .setter(setter(Builder::autoprovision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Autoprovision").build()).build();

    private static final SdkField<String> DRIVER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Driver")
            .getter(getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::driver)).setter(setter(Builder::driver))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Driver").build()).build();

    private static final SdkField<Map<String, String>> DRIVER_OPTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("DriverOpts")
            .getter(getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::driverOpts))
            .setter(setter(Builder::driverOpts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DriverOpts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Labels")
            .getter(getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Scope")
            .getter(getter(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails::scope)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOPROVISION_FIELD,
            DRIVER_FIELD, DRIVER_OPTS_FIELD, LABELS_FIELD, SCOPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoprovision;

    private final String driver;

    private final Map<String, String> driverOpts;

    private final Map<String, String> labels;

    private final String scope;

    private AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(BuilderImpl builder) {
        this.autoprovision = builder.autoprovision;
        this.driver = builder.driver;
        this.driverOpts = builder.driverOpts;
        this.labels = builder.labels;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * Whether to create the Docker volume automatically if it does not already exist.
     * </p>
     * 
     * @return Whether to create the Docker volume automatically if it does not already exist.
     */
    public final Boolean autoprovision() {
        return autoprovision;
    }

    /**
     * <p>
     * The Docker volume driver to use.
     * </p>
     * 
     * @return The Docker volume driver to use.
     */
    public final String driver() {
        return driver;
    }

    /**
     * Returns true if the DriverOpts property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDriverOpts() {
        return driverOpts != null && !(driverOpts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of Docker driver-specific options that are passed through.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDriverOpts()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of Docker driver-specific options that are passed through.
     */
    public final Map<String, String> driverOpts() {
        return driverOpts;
    }

    /**
     * Returns true if the Labels property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom metadata to add to the Docker volume.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLabels()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Custom metadata to add to the Docker volume.
     */
    public final Map<String, String> labels() {
        return labels;
    }

    /**
     * <p>
     * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are
     * provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are shared
     * persist after the task stops.
     * </p>
     * 
     * @return The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task
     *         are provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that
     *         are shared persist after the task stops.
     */
    public final String scope() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoprovision());
        hashCode = 31 * hashCode + Objects.hashCode(driver());
        hashCode = 31 * hashCode + Objects.hashCode(hasDriverOpts() ? driverOpts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scope());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails other = (AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) obj;
        return Objects.equals(autoprovision(), other.autoprovision()) && Objects.equals(driver(), other.driver())
                && hasDriverOpts() == other.hasDriverOpts() && Objects.equals(driverOpts(), other.driverOpts())
                && hasLabels() == other.hasLabels() && Objects.equals(labels(), other.labels())
                && Objects.equals(scope(), other.scope());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails")
                .add("Autoprovision", autoprovision()).add("Driver", driver())
                .add("DriverOpts", hasDriverOpts() ? driverOpts() : null).add("Labels", hasLabels() ? labels() : null)
                .add("Scope", scope()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Autoprovision":
            return Optional.ofNullable(clazz.cast(autoprovision()));
        case "Driver":
            return Optional.ofNullable(clazz.cast(driver()));
        case "DriverOpts":
            return Optional.ofNullable(clazz.cast(driverOpts()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        case "Scope":
            return Optional.ofNullable(clazz.cast(scope()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails> {
        /**
         * <p>
         * Whether to create the Docker volume automatically if it does not already exist.
         * </p>
         * 
         * @param autoprovision
         *        Whether to create the Docker volume automatically if it does not already exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoprovision(Boolean autoprovision);

        /**
         * <p>
         * The Docker volume driver to use.
         * </p>
         * 
         * @param driver
         *        The Docker volume driver to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driver(String driver);

        /**
         * <p>
         * A map of Docker driver-specific options that are passed through.
         * </p>
         * 
         * @param driverOpts
         *        A map of Docker driver-specific options that are passed through.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder driverOpts(Map<String, String> driverOpts);

        /**
         * <p>
         * Custom metadata to add to the Docker volume.
         * </p>
         * 
         * @param labels
         *        Custom metadata to add to the Docker volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Map<String, String> labels);

        /**
         * <p>
         * The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a task are
         * provisioned automatically when the task starts and destroyed when the task stops. Docker volumes that are
         * shared persist after the task stops.
         * </p>
         * 
         * @param scope
         *        The scope for the Docker volume that determines its lifecycle. Docker volumes that are scoped to a
         *        task are provisioned automatically when the task starts and destroyed when the task stops. Docker
         *        volumes that are shared persist after the task stops.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scope(String scope);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoprovision;

        private String driver;

        private Map<String, String> driverOpts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> labels = DefaultSdkAutoConstructMap.getInstance();

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails model) {
            autoprovision(model.autoprovision);
            driver(model.driver);
            driverOpts(model.driverOpts);
            labels(model.labels);
            scope(model.scope);
        }

        public final Boolean getAutoprovision() {
            return autoprovision;
        }

        @Override
        public final Builder autoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
            return this;
        }

        public final void setAutoprovision(Boolean autoprovision) {
            this.autoprovision = autoprovision;
        }

        public final String getDriver() {
            return driver;
        }

        @Override
        public final Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public final void setDriver(String driver) {
            this.driver = driver;
        }

        public final Map<String, String> getDriverOpts() {
            if (driverOpts instanceof SdkAutoConstructMap) {
                return null;
            }
            return driverOpts;
        }

        @Override
        public final Builder driverOpts(Map<String, String> driverOpts) {
            this.driverOpts = FieldMapCopier.copy(driverOpts);
            return this;
        }

        public final void setDriverOpts(Map<String, String> driverOpts) {
            this.driverOpts = FieldMapCopier.copy(driverOpts);
        }

        public final Map<String, String> getLabels() {
            if (labels instanceof SdkAutoConstructMap) {
                return null;
            }
            return labels;
        }

        @Override
        public final Builder labels(Map<String, String> labels) {
            this.labels = FieldMapCopier.copy(labels);
            return this;
        }

        public final void setLabels(Map<String, String> labels) {
            this.labels = FieldMapCopier.copy(labels);
        }

        public final String getScope() {
            return scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails build() {
            return new AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
