/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM role, including all of the role's policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamRoleDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamRoleDetails.Builder, AwsIamRoleDetails> {
    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumeRolePolicyDocument").getter(getter(AwsIamRoleDetails::assumeRolePolicyDocument))
            .setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<List<AwsIamAttachedManagedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AwsIamAttachedManagedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(AwsIamRoleDetails::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamAttachedManagedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamAttachedManagedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamRoleDetails::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<List<AwsIamInstanceProfile>> INSTANCE_PROFILE_LIST_FIELD = SdkField
            .<List<AwsIamInstanceProfile>> builder(MarshallingType.LIST)
            .memberName("InstanceProfileList")
            .getter(getter(AwsIamRoleDetails::instanceProfileList))
            .setter(setter(Builder::instanceProfileList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamInstanceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamInstanceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsIamPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<AwsIamPermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(AwsIamRoleDetails::permissionsBoundary)).setter(setter(Builder::permissionsBoundary))
            .constructor(AwsIamPermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoleId")
            .getter(getter(AwsIamRoleDetails::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(AwsIamRoleDetails::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<List<AwsIamRolePolicy>> ROLE_POLICY_LIST_FIELD = SdkField
            .<List<AwsIamRolePolicy>> builder(MarshallingType.LIST)
            .memberName("RolePolicyList")
            .getter(getter(AwsIamRoleDetails::rolePolicyList))
            .setter(setter(Builder::rolePolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolePolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamRolePolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamRolePolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionDuration").getter(getter(AwsIamRoleDetails::maxSessionDuration))
            .setter(setter(Builder::maxSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build())
            .build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamRoleDetails::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSUME_ROLE_POLICY_DOCUMENT_FIELD, ATTACHED_MANAGED_POLICIES_FIELD, CREATE_DATE_FIELD, INSTANCE_PROFILE_LIST_FIELD,
            PERMISSIONS_BOUNDARY_FIELD, ROLE_ID_FIELD, ROLE_NAME_FIELD, ROLE_POLICY_LIST_FIELD, MAX_SESSION_DURATION_FIELD,
            PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String assumeRolePolicyDocument;

    private final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies;

    private final String createDate;

    private final List<AwsIamInstanceProfile> instanceProfileList;

    private final AwsIamPermissionsBoundary permissionsBoundary;

    private final String roleId;

    private final String roleName;

    private final List<AwsIamRolePolicy> rolePolicyList;

    private final Integer maxSessionDuration;

    private final String path;

    private AwsIamRoleDetails(BuilderImpl builder) {
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.createDate = builder.createDate;
        this.instanceProfileList = builder.instanceProfileList;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.roleId = builder.roleId;
        this.roleName = builder.roleName;
        this.rolePolicyList = builder.rolePolicyList;
        this.maxSessionDuration = builder.maxSessionDuration;
        this.path = builder.path;
    }

    /**
     * <p>
     * The trust policy that grants permission to assume the role.
     * </p>
     * 
     * @return The trust policy that grants permission to assume the role.
     */
    public final String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * Returns true if the AttachedManagedPolicies property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of the managed policies that are attached to the role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachedManagedPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of the managed policies that are attached to the role.
     */
    public final List<AwsIamAttachedManagedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * Indicates when the role was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the role was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * Returns true if the InstanceProfileList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInstanceProfileList() {
        return instanceProfileList != null && !(instanceProfileList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of instance profiles that contain this role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceProfileList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of instance profiles that contain this role.
     */
    public final List<AwsIamInstanceProfile> instanceProfileList() {
        return instanceProfileList;
    }

    /**
     * Returns the value of the PermissionsBoundary property for this object.
     * 
     * @return The value of the PermissionsBoundary property for this object.
     */
    public final AwsIamPermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * <p>
     * The stable and unique string identifying the role.
     * </p>
     * 
     * @return The stable and unique string identifying the role.
     */
    public final String roleId() {
        return roleId;
    }

    /**
     * <p>
     * The friendly name that identifies the role.
     * </p>
     * 
     * @return The friendly name that identifies the role.
     */
    public final String roleName() {
        return roleName;
    }

    /**
     * Returns true if the RolePolicyList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRolePolicyList() {
        return rolePolicyList != null && !(rolePolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of inline policies that are embedded in the role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRolePolicyList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of inline policies that are embedded in the role.
     */
    public final List<AwsIamRolePolicy> rolePolicyList() {
        return rolePolicyList;
    }

    /**
     * <p>
     * The maximum session duration (in seconds) that you want to set for the specified role.
     * </p>
     * 
     * @return The maximum session duration (in seconds) that you want to set for the specified role.
     */
    public final Integer maxSessionDuration() {
        return maxSessionDuration;
    }

    /**
     * <p>
     * The path to the role.
     * </p>
     * 
     * @return The path to the role.
     */
    public final String path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachedManagedPolicies() ? attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceProfileList() ? instanceProfileList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(hasRolePolicyList() ? rolePolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamRoleDetails)) {
            return false;
        }
        AwsIamRoleDetails other = (AwsIamRoleDetails) obj;
        return Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies()
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(createDate(), other.createDate()) && hasInstanceProfileList() == other.hasInstanceProfileList()
                && Objects.equals(instanceProfileList(), other.instanceProfileList())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && Objects.equals(roleId(), other.roleId())
                && Objects.equals(roleName(), other.roleName()) && hasRolePolicyList() == other.hasRolePolicyList()
                && Objects.equals(rolePolicyList(), other.rolePolicyList())
                && Objects.equals(maxSessionDuration(), other.maxSessionDuration()) && Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamRoleDetails").add("AssumeRolePolicyDocument", assumeRolePolicyDocument())
                .add("AttachedManagedPolicies", hasAttachedManagedPolicies() ? attachedManagedPolicies() : null)
                .add("CreateDate", createDate())
                .add("InstanceProfileList", hasInstanceProfileList() ? instanceProfileList() : null)
                .add("PermissionsBoundary", permissionsBoundary()).add("RoleId", roleId()).add("RoleName", roleName())
                .add("RolePolicyList", hasRolePolicyList() ? rolePolicyList() : null)
                .add("MaxSessionDuration", maxSessionDuration()).add("Path", path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "InstanceProfileList":
            return Optional.ofNullable(clazz.cast(instanceProfileList()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RolePolicyList":
            return Optional.ofNullable(clazz.cast(rolePolicyList()));
        case "MaxSessionDuration":
            return Optional.ofNullable(clazz.cast(maxSessionDuration()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamRoleDetails, T> g) {
        return obj -> g.apply((AwsIamRoleDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamRoleDetails> {
        /**
         * <p>
         * The trust policy that grants permission to assume the role.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The trust policy that grants permission to assume the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * The list of the managed policies that are attached to the role.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        The list of the managed policies that are attached to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * The list of the managed policies that are attached to the role.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        The list of the managed policies that are attached to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * The list of the managed policies that are attached to the role.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsIamAttachedManagedPolicy>.Builder}
         * avoiding the need to create one manually via {@link List<AwsIamAttachedManagedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsIamAttachedManagedPolicy>.Builder#build()} is called
         * immediately and its result is passed to {@link #attachedManagedPolicies(List<AwsIamAttachedManagedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on {@link List<AwsIamAttachedManagedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(List<AwsIamAttachedManagedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * Indicates when the role was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createDate
         *        Indicates when the role was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The list of instance profiles that contain this role.
         * </p>
         * 
         * @param instanceProfileList
         *        The list of instance profiles that contain this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileList(Collection<AwsIamInstanceProfile> instanceProfileList);

        /**
         * <p>
         * The list of instance profiles that contain this role.
         * </p>
         * 
         * @param instanceProfileList
         *        The list of instance profiles that contain this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileList(AwsIamInstanceProfile... instanceProfileList);

        /**
         * <p>
         * The list of instance profiles that contain this role.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsIamInstanceProfile>.Builder} avoiding
         * the need to create one manually via {@link List<AwsIamInstanceProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsIamInstanceProfile>.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceProfileList(List<AwsIamInstanceProfile>)}.
         * 
         * @param instanceProfileList
         *        a consumer that will call methods on {@link List<AwsIamInstanceProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfileList(List<AwsIamInstanceProfile>)
         */
        Builder instanceProfileList(Consumer<AwsIamInstanceProfile.Builder>... instanceProfileList);

        /**
         * Sets the value of the PermissionsBoundary property for this object.
         *
         * @param permissionsBoundary
         *        The new value for the PermissionsBoundary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(AwsIamPermissionsBoundary permissionsBoundary);

        /**
         * Sets the value of the PermissionsBoundary property for this object.
         *
         * This is a convenience that creates an instance of the {@link AwsIamPermissionsBoundary.Builder} avoiding the
         * need to create one manually via {@link AwsIamPermissionsBoundary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamPermissionsBoundary.Builder#build()} is called immediately
         * and its result is passed to {@link #permissionsBoundary(AwsIamPermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link AwsIamPermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(AwsIamPermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<AwsIamPermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(AwsIamPermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }

        /**
         * <p>
         * The stable and unique string identifying the role.
         * </p>
         * 
         * @param roleId
         *        The stable and unique string identifying the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);

        /**
         * <p>
         * The friendly name that identifies the role.
         * </p>
         * 
         * @param roleName
         *        The friendly name that identifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The list of inline policies that are embedded in the role.
         * </p>
         * 
         * @param rolePolicyList
         *        The list of inline policies that are embedded in the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolePolicyList(Collection<AwsIamRolePolicy> rolePolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the role.
         * </p>
         * 
         * @param rolePolicyList
         *        The list of inline policies that are embedded in the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolePolicyList(AwsIamRolePolicy... rolePolicyList);

        /**
         * <p>
         * The list of inline policies that are embedded in the role.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsIamRolePolicy>.Builder} avoiding the
         * need to create one manually via {@link List<AwsIamRolePolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsIamRolePolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #rolePolicyList(List<AwsIamRolePolicy>)}.
         * 
         * @param rolePolicyList
         *        a consumer that will call methods on {@link List<AwsIamRolePolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rolePolicyList(List<AwsIamRolePolicy>)
         */
        Builder rolePolicyList(Consumer<AwsIamRolePolicy.Builder>... rolePolicyList);

        /**
         * <p>
         * The maximum session duration (in seconds) that you want to set for the specified role.
         * </p>
         * 
         * @param maxSessionDuration
         *        The maximum session duration (in seconds) that you want to set for the specified role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionDuration(Integer maxSessionDuration);

        /**
         * <p>
         * The path to the role.
         * </p>
         * 
         * @param path
         *        The path to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);
    }

    static final class BuilderImpl implements Builder {
        private String assumeRolePolicyDocument;

        private List<AwsIamAttachedManagedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private String createDate;

        private List<AwsIamInstanceProfile> instanceProfileList = DefaultSdkAutoConstructList.getInstance();

        private AwsIamPermissionsBoundary permissionsBoundary;

        private String roleId;

        private String roleName;

        private List<AwsIamRolePolicy> rolePolicyList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxSessionDuration;

        private String path;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamRoleDetails model) {
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            attachedManagedPolicies(model.attachedManagedPolicies);
            createDate(model.createDate);
            instanceProfileList(model.instanceProfileList);
            permissionsBoundary(model.permissionsBoundary);
            roleId(model.roleId);
            roleName(model.roleName);
            rolePolicyList(model.rolePolicyList);
            maxSessionDuration(model.maxSessionDuration);
            path(model.path);
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final List<AwsIamAttachedManagedPolicy.Builder> getAttachedManagedPolicies() {
            List<AwsIamAttachedManagedPolicy.Builder> result = AwsIamAttachedManagedPolicyListCopier
                    .copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AwsIamAttachedManagedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AwsIamAttachedManagedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AwsIamAttachedManagedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AwsIamAttachedManagedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = AwsIamAttachedManagedPolicyListCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public final String getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public final List<AwsIamInstanceProfile.Builder> getInstanceProfileList() {
            List<AwsIamInstanceProfile.Builder> result = AwsIamInstanceProfileListCopier.copyToBuilder(this.instanceProfileList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder instanceProfileList(Collection<AwsIamInstanceProfile> instanceProfileList) {
            this.instanceProfileList = AwsIamInstanceProfileListCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(AwsIamInstanceProfile... instanceProfileList) {
            instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(Consumer<AwsIamInstanceProfile.Builder>... instanceProfileList) {
            instanceProfileList(Stream.of(instanceProfileList).map(c -> AwsIamInstanceProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfileList(Collection<AwsIamInstanceProfile.BuilderImpl> instanceProfileList) {
            this.instanceProfileList = AwsIamInstanceProfileListCopier.copyFromBuilder(instanceProfileList);
        }

        public final AwsIamPermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AwsIamPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AwsIamPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public final String getRoleId() {
            return roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final List<AwsIamRolePolicy.Builder> getRolePolicyList() {
            List<AwsIamRolePolicy.Builder> result = AwsIamRolePolicyListCopier.copyToBuilder(this.rolePolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rolePolicyList(Collection<AwsIamRolePolicy> rolePolicyList) {
            this.rolePolicyList = AwsIamRolePolicyListCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(AwsIamRolePolicy... rolePolicyList) {
            rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(Consumer<AwsIamRolePolicy.Builder>... rolePolicyList) {
            rolePolicyList(Stream.of(rolePolicyList).map(c -> AwsIamRolePolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRolePolicyList(Collection<AwsIamRolePolicy.BuilderImpl> rolePolicyList) {
            this.rolePolicyList = AwsIamRolePolicyListCopier.copyFromBuilder(rolePolicyList);
        }

        public final Integer getMaxSessionDuration() {
            return maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public AwsIamRoleDetails build() {
            return new AwsIamRoleDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
