/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a function's configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsLambdaFunctionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsLambdaFunctionDetails.Builder, AwsLambdaFunctionDetails> {
    private static final SdkField<AwsLambdaFunctionCode> CODE_FIELD = SdkField
            .<AwsLambdaFunctionCode> builder(MarshallingType.SDK_POJO).memberName("Code")
            .getter(getter(AwsLambdaFunctionDetails::code)).setter(setter(Builder::code))
            .constructor(AwsLambdaFunctionCode::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> CODE_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodeSha256").getter(getter(AwsLambdaFunctionDetails::codeSha256)).setter(setter(Builder::codeSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSha256").build()).build();

    private static final SdkField<AwsLambdaFunctionDeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField
            .<AwsLambdaFunctionDeadLetterConfig> builder(MarshallingType.SDK_POJO).memberName("DeadLetterConfig")
            .getter(getter(AwsLambdaFunctionDetails::deadLetterConfig)).setter(setter(Builder::deadLetterConfig))
            .constructor(AwsLambdaFunctionDeadLetterConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()).build();

    private static final SdkField<AwsLambdaFunctionEnvironment> ENVIRONMENT_FIELD = SdkField
            .<AwsLambdaFunctionEnvironment> builder(MarshallingType.SDK_POJO).memberName("Environment")
            .getter(getter(AwsLambdaFunctionDetails::environment)).setter(setter(Builder::environment))
            .constructor(AwsLambdaFunctionEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FunctionName").getter(getter(AwsLambdaFunctionDetails::functionName))
            .setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionName").build()).build();

    private static final SdkField<String> HANDLER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Handler")
            .getter(getter(AwsLambdaFunctionDetails::handler)).setter(setter(Builder::handler))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Handler").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(AwsLambdaFunctionDetails::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModified").getter(getter(AwsLambdaFunctionDetails::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()).build();

    private static final SdkField<List<AwsLambdaFunctionLayer>> LAYERS_FIELD = SdkField
            .<List<AwsLambdaFunctionLayer>> builder(MarshallingType.LIST)
            .memberName("Layers")
            .getter(getter(AwsLambdaFunctionDetails::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsLambdaFunctionLayer> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsLambdaFunctionLayer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MASTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterArn").getter(getter(AwsLambdaFunctionDetails::masterArn)).setter(setter(Builder::masterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterArn").build()).build();

    private static final SdkField<Integer> MEMORY_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemorySize").getter(getter(AwsLambdaFunctionDetails::memorySize)).setter(setter(Builder::memorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemorySize").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RevisionId").getter(getter(AwsLambdaFunctionDetails::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevisionId").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(AwsLambdaFunctionDetails::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Runtime")
            .getter(getter(AwsLambdaFunctionDetails::runtime)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runtime").build()).build();

    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Timeout").getter(getter(AwsLambdaFunctionDetails::timeout)).setter(setter(Builder::timeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()).build();

    private static final SdkField<AwsLambdaFunctionTracingConfig> TRACING_CONFIG_FIELD = SdkField
            .<AwsLambdaFunctionTracingConfig> builder(MarshallingType.SDK_POJO).memberName("TracingConfig")
            .getter(getter(AwsLambdaFunctionDetails::tracingConfig)).setter(setter(Builder::tracingConfig))
            .constructor(AwsLambdaFunctionTracingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TracingConfig").build()).build();

    private static final SdkField<AwsLambdaFunctionVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<AwsLambdaFunctionVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(AwsLambdaFunctionDetails::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(AwsLambdaFunctionVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(AwsLambdaFunctionDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, CODE_SHA256_FIELD,
            DEAD_LETTER_CONFIG_FIELD, ENVIRONMENT_FIELD, FUNCTION_NAME_FIELD, HANDLER_FIELD, KMS_KEY_ARN_FIELD,
            LAST_MODIFIED_FIELD, LAYERS_FIELD, MASTER_ARN_FIELD, MEMORY_SIZE_FIELD, REVISION_ID_FIELD, ROLE_FIELD, RUNTIME_FIELD,
            TIMEOUT_FIELD, TRACING_CONFIG_FIELD, VPC_CONFIG_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsLambdaFunctionCode code;

    private final String codeSha256;

    private final AwsLambdaFunctionDeadLetterConfig deadLetterConfig;

    private final AwsLambdaFunctionEnvironment environment;

    private final String functionName;

    private final String handler;

    private final String kmsKeyArn;

    private final String lastModified;

    private final List<AwsLambdaFunctionLayer> layers;

    private final String masterArn;

    private final Integer memorySize;

    private final String revisionId;

    private final String role;

    private final String runtime;

    private final Integer timeout;

    private final AwsLambdaFunctionTracingConfig tracingConfig;

    private final AwsLambdaFunctionVpcConfig vpcConfig;

    private final String version;

    private AwsLambdaFunctionDetails(BuilderImpl builder) {
        this.code = builder.code;
        this.codeSha256 = builder.codeSha256;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.environment = builder.environment;
        this.functionName = builder.functionName;
        this.handler = builder.handler;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.lastModified = builder.lastModified;
        this.layers = builder.layers;
        this.masterArn = builder.masterArn;
        this.memorySize = builder.memorySize;
        this.revisionId = builder.revisionId;
        this.role = builder.role;
        this.runtime = builder.runtime;
        this.timeout = builder.timeout;
        this.tracingConfig = builder.tracingConfig;
        this.vpcConfig = builder.vpcConfig;
        this.version = builder.version;
    }

    /**
     * <p>
     * An <code>AwsLambdaFunctionCode</code> object.
     * </p>
     * 
     * @return An <code>AwsLambdaFunctionCode</code> object.
     */
    public final AwsLambdaFunctionCode code() {
        return code;
    }

    /**
     * <p>
     * The SHA256 hash of the function's deployment package.
     * </p>
     * 
     * @return The SHA256 hash of the function's deployment package.
     */
    public final String codeSha256() {
        return codeSha256;
    }

    /**
     * <p>
     * The function's dead letter queue.
     * </p>
     * 
     * @return The function's dead letter queue.
     */
    public final AwsLambdaFunctionDeadLetterConfig deadLetterConfig() {
        return deadLetterConfig;
    }

    /**
     * <p>
     * The function's environment variables.
     * </p>
     * 
     * @return The function's environment variables.
     */
    public final AwsLambdaFunctionEnvironment environment() {
        return environment;
    }

    /**
     * <p>
     * The name of the function.
     * </p>
     * 
     * @return The name of the function.
     */
    public final String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The function that Lambda calls to begin executing your function.
     * </p>
     * 
     * @return The function that Lambda calls to begin executing your function.
     */
    public final String handler() {
        return handler;
    }

    /**
     * <p>
     * The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
     * configured a customer managed CMK.
     * </p>
     * 
     * @return The KMS key that's used to encrypt the function's environment variables. This key is only returned if
     *         you've configured a customer managed CMK.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * <p>
     * Indicates when the function was last updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the function was last updated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String lastModified() {
        return lastModified;
    }

    /**
     * Returns true if the Layers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The function's layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLayers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The function's layers.
     */
    public final List<AwsLambdaFunctionLayer> layers() {
        return layers;
    }

    /**
     * <p>
     * For Lambda@Edge functions, the ARN of the master function.
     * </p>
     * 
     * @return For Lambda@Edge functions, the ARN of the master function.
     */
    public final String masterArn() {
        return masterArn;
    }

    /**
     * <p>
     * The memory that is allocated to the function.
     * </p>
     * 
     * @return The memory that is allocated to the function.
     */
    public final Integer memorySize() {
        return memorySize;
    }

    /**
     * <p>
     * The latest updated revision of the function or alias.
     * </p>
     * 
     * @return The latest updated revision of the function or alias.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The function's execution role.
     * </p>
     * 
     * @return The function's execution role.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The runtime environment for the Lambda function.
     * </p>
     * 
     * @return The runtime environment for the Lambda function.
     */
    public final String runtime() {
        return runtime;
    }

    /**
     * <p>
     * The amount of time that Lambda allows a function to run before stopping it.
     * </p>
     * 
     * @return The amount of time that Lambda allows a function to run before stopping it.
     */
    public final Integer timeout() {
        return timeout;
    }

    /**
     * <p>
     * The function's AWS X-Ray tracing configuration.
     * </p>
     * 
     * @return The function's AWS X-Ray tracing configuration.
     */
    public final AwsLambdaFunctionTracingConfig tracingConfig() {
        return tracingConfig;
    }

    /**
     * <p>
     * The function's networking configuration.
     * </p>
     * 
     * @return The function's networking configuration.
     */
    public final AwsLambdaFunctionVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The version of the Lambda function.
     * </p>
     * 
     * @return The version of the Lambda function.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(codeSha256());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(handler());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(masterArn());
        hashCode = 31 * hashCode + Objects.hashCode(memorySize());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(timeout());
        hashCode = 31 * hashCode + Objects.hashCode(tracingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLambdaFunctionDetails)) {
            return false;
        }
        AwsLambdaFunctionDetails other = (AwsLambdaFunctionDetails) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(codeSha256(), other.codeSha256())
                && Objects.equals(deadLetterConfig(), other.deadLetterConfig())
                && Objects.equals(environment(), other.environment()) && Objects.equals(functionName(), other.functionName())
                && Objects.equals(handler(), other.handler()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && Objects.equals(lastModified(), other.lastModified()) && hasLayers() == other.hasLayers()
                && Objects.equals(layers(), other.layers()) && Objects.equals(masterArn(), other.masterArn())
                && Objects.equals(memorySize(), other.memorySize()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(role(), other.role()) && Objects.equals(runtime(), other.runtime())
                && Objects.equals(timeout(), other.timeout()) && Objects.equals(tracingConfig(), other.tracingConfig())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsLambdaFunctionDetails").add("Code", code()).add("CodeSha256", codeSha256())
                .add("DeadLetterConfig", deadLetterConfig()).add("Environment", environment())
                .add("FunctionName", functionName()).add("Handler", handler()).add("KmsKeyArn", kmsKeyArn())
                .add("LastModified", lastModified()).add("Layers", hasLayers() ? layers() : null).add("MasterArn", masterArn())
                .add("MemorySize", memorySize()).add("RevisionId", revisionId()).add("Role", role()).add("Runtime", runtime())
                .add("Timeout", timeout()).add("TracingConfig", tracingConfig()).add("VpcConfig", vpcConfig())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "CodeSha256":
            return Optional.ofNullable(clazz.cast(codeSha256()));
        case "DeadLetterConfig":
            return Optional.ofNullable(clazz.cast(deadLetterConfig()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "FunctionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "Handler":
            return Optional.ofNullable(clazz.cast(handler()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        case "MasterArn":
            return Optional.ofNullable(clazz.cast(masterArn()));
        case "MemorySize":
            return Optional.ofNullable(clazz.cast(memorySize()));
        case "RevisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "Runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "Timeout":
            return Optional.ofNullable(clazz.cast(timeout()));
        case "TracingConfig":
            return Optional.ofNullable(clazz.cast(tracingConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsLambdaFunctionDetails, T> g) {
        return obj -> g.apply((AwsLambdaFunctionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsLambdaFunctionDetails> {
        /**
         * <p>
         * An <code>AwsLambdaFunctionCode</code> object.
         * </p>
         * 
         * @param code
         *        An <code>AwsLambdaFunctionCode</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(AwsLambdaFunctionCode code);

        /**
         * <p>
         * An <code>AwsLambdaFunctionCode</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionCode.Builder} avoiding the need
         * to create one manually via {@link AwsLambdaFunctionCode#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionCode.Builder#build()} is called immediately and
         * its result is passed to {@link #code(AwsLambdaFunctionCode)}.
         * 
         * @param code
         *        a consumer that will call methods on {@link AwsLambdaFunctionCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #code(AwsLambdaFunctionCode)
         */
        default Builder code(Consumer<AwsLambdaFunctionCode.Builder> code) {
            return code(AwsLambdaFunctionCode.builder().applyMutation(code).build());
        }

        /**
         * <p>
         * The SHA256 hash of the function's deployment package.
         * </p>
         * 
         * @param codeSha256
         *        The SHA256 hash of the function's deployment package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeSha256(String codeSha256);

        /**
         * <p>
         * The function's dead letter queue.
         * </p>
         * 
         * @param deadLetterConfig
         *        The function's dead letter queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterConfig(AwsLambdaFunctionDeadLetterConfig deadLetterConfig);

        /**
         * <p>
         * The function's dead letter queue.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionDeadLetterConfig.Builder}
         * avoiding the need to create one manually via {@link AwsLambdaFunctionDeadLetterConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionDeadLetterConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #deadLetterConfig(AwsLambdaFunctionDeadLetterConfig)}.
         * 
         * @param deadLetterConfig
         *        a consumer that will call methods on {@link AwsLambdaFunctionDeadLetterConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deadLetterConfig(AwsLambdaFunctionDeadLetterConfig)
         */
        default Builder deadLetterConfig(Consumer<AwsLambdaFunctionDeadLetterConfig.Builder> deadLetterConfig) {
            return deadLetterConfig(AwsLambdaFunctionDeadLetterConfig.builder().applyMutation(deadLetterConfig).build());
        }

        /**
         * <p>
         * The function's environment variables.
         * </p>
         * 
         * @param environment
         *        The function's environment variables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(AwsLambdaFunctionEnvironment environment);

        /**
         * <p>
         * The function's environment variables.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionEnvironment.Builder} avoiding
         * the need to create one manually via {@link AwsLambdaFunctionEnvironment#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionEnvironment.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(AwsLambdaFunctionEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link AwsLambdaFunctionEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(AwsLambdaFunctionEnvironment)
         */
        default Builder environment(Consumer<AwsLambdaFunctionEnvironment.Builder> environment) {
            return environment(AwsLambdaFunctionEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The name of the function.
         * </p>
         * 
         * @param functionName
         *        The name of the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The function that Lambda calls to begin executing your function.
         * </p>
         * 
         * @param handler
         *        The function that Lambda calls to begin executing your function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder handler(String handler);

        /**
         * <p>
         * The KMS key that's used to encrypt the function's environment variables. This key is only returned if you've
         * configured a customer managed CMK.
         * </p>
         * 
         * @param kmsKeyArn
         *        The KMS key that's used to encrypt the function's environment variables. This key is only returned if
         *        you've configured a customer managed CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * Indicates when the function was last updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param lastModified
         *        Indicates when the function was last updated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(String lastModified);

        /**
         * <p>
         * The function's layers.
         * </p>
         * 
         * @param layers
         *        The function's layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<AwsLambdaFunctionLayer> layers);

        /**
         * <p>
         * The function's layers.
         * </p>
         * 
         * @param layers
         *        The function's layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(AwsLambdaFunctionLayer... layers);

        /**
         * <p>
         * The function's layers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsLambdaFunctionLayer>.Builder} avoiding
         * the need to create one manually via {@link List<AwsLambdaFunctionLayer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsLambdaFunctionLayer>.Builder#build()} is called
         * immediately and its result is passed to {@link #layers(List<AwsLambdaFunctionLayer>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link List<AwsLambdaFunctionLayer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(List<AwsLambdaFunctionLayer>)
         */
        Builder layers(Consumer<AwsLambdaFunctionLayer.Builder>... layers);

        /**
         * <p>
         * For Lambda@Edge functions, the ARN of the master function.
         * </p>
         * 
         * @param masterArn
         *        For Lambda@Edge functions, the ARN of the master function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterArn(String masterArn);

        /**
         * <p>
         * The memory that is allocated to the function.
         * </p>
         * 
         * @param memorySize
         *        The memory that is allocated to the function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memorySize(Integer memorySize);

        /**
         * <p>
         * The latest updated revision of the function or alias.
         * </p>
         * 
         * @param revisionId
         *        The latest updated revision of the function or alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The function's execution role.
         * </p>
         * 
         * @param role
         *        The function's execution role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The runtime environment for the Lambda function.
         * </p>
         * 
         * @param runtime
         *        The runtime environment for the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The amount of time that Lambda allows a function to run before stopping it.
         * </p>
         * 
         * @param timeout
         *        The amount of time that Lambda allows a function to run before stopping it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeout(Integer timeout);

        /**
         * <p>
         * The function's AWS X-Ray tracing configuration.
         * </p>
         * 
         * @param tracingConfig
         *        The function's AWS X-Ray tracing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tracingConfig(AwsLambdaFunctionTracingConfig tracingConfig);

        /**
         * <p>
         * The function's AWS X-Ray tracing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionTracingConfig.Builder} avoiding
         * the need to create one manually via {@link AwsLambdaFunctionTracingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionTracingConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #tracingConfig(AwsLambdaFunctionTracingConfig)}.
         * 
         * @param tracingConfig
         *        a consumer that will call methods on {@link AwsLambdaFunctionTracingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tracingConfig(AwsLambdaFunctionTracingConfig)
         */
        default Builder tracingConfig(Consumer<AwsLambdaFunctionTracingConfig.Builder> tracingConfig) {
            return tracingConfig(AwsLambdaFunctionTracingConfig.builder().applyMutation(tracingConfig).build());
        }

        /**
         * <p>
         * The function's networking configuration.
         * </p>
         * 
         * @param vpcConfig
         *        The function's networking configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(AwsLambdaFunctionVpcConfig vpcConfig);

        /**
         * <p>
         * The function's networking configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaFunctionVpcConfig.Builder} avoiding the
         * need to create one manually via {@link AwsLambdaFunctionVpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaFunctionVpcConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConfig(AwsLambdaFunctionVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link AwsLambdaFunctionVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(AwsLambdaFunctionVpcConfig)
         */
        default Builder vpcConfig(Consumer<AwsLambdaFunctionVpcConfig.Builder> vpcConfig) {
            return vpcConfig(AwsLambdaFunctionVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The version of the Lambda function.
         * </p>
         * 
         * @param version
         *        The version of the Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private AwsLambdaFunctionCode code;

        private String codeSha256;

        private AwsLambdaFunctionDeadLetterConfig deadLetterConfig;

        private AwsLambdaFunctionEnvironment environment;

        private String functionName;

        private String handler;

        private String kmsKeyArn;

        private String lastModified;

        private List<AwsLambdaFunctionLayer> layers = DefaultSdkAutoConstructList.getInstance();

        private String masterArn;

        private Integer memorySize;

        private String revisionId;

        private String role;

        private String runtime;

        private Integer timeout;

        private AwsLambdaFunctionTracingConfig tracingConfig;

        private AwsLambdaFunctionVpcConfig vpcConfig;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLambdaFunctionDetails model) {
            code(model.code);
            codeSha256(model.codeSha256);
            deadLetterConfig(model.deadLetterConfig);
            environment(model.environment);
            functionName(model.functionName);
            handler(model.handler);
            kmsKeyArn(model.kmsKeyArn);
            lastModified(model.lastModified);
            layers(model.layers);
            masterArn(model.masterArn);
            memorySize(model.memorySize);
            revisionId(model.revisionId);
            role(model.role);
            runtime(model.runtime);
            timeout(model.timeout);
            tracingConfig(model.tracingConfig);
            vpcConfig(model.vpcConfig);
            version(model.version);
        }

        public final AwsLambdaFunctionCode.Builder getCode() {
            return code != null ? code.toBuilder() : null;
        }

        @Override
        public final Builder code(AwsLambdaFunctionCode code) {
            this.code = code;
            return this;
        }

        public final void setCode(AwsLambdaFunctionCode.BuilderImpl code) {
            this.code = code != null ? code.build() : null;
        }

        public final String getCodeSha256() {
            return codeSha256;
        }

        @Override
        public final Builder codeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
            return this;
        }

        public final void setCodeSha256(String codeSha256) {
            this.codeSha256 = codeSha256;
        }

        public final AwsLambdaFunctionDeadLetterConfig.Builder getDeadLetterConfig() {
            return deadLetterConfig != null ? deadLetterConfig.toBuilder() : null;
        }

        @Override
        public final Builder deadLetterConfig(AwsLambdaFunctionDeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final void setDeadLetterConfig(AwsLambdaFunctionDeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        public final AwsLambdaFunctionEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        @Override
        public final Builder environment(AwsLambdaFunctionEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final void setEnvironment(AwsLambdaFunctionEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getHandler() {
            return handler;
        }

        @Override
        public final Builder handler(String handler) {
            this.handler = handler;
            return this;
        }

        public final void setHandler(String handler) {
            this.handler = handler;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final String getLastModified() {
            return lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public final List<AwsLambdaFunctionLayer.Builder> getLayers() {
            List<AwsLambdaFunctionLayer.Builder> result = AwsLambdaFunctionLayerListCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder layers(Collection<AwsLambdaFunctionLayer> layers) {
            this.layers = AwsLambdaFunctionLayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(AwsLambdaFunctionLayer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<AwsLambdaFunctionLayer.Builder>... layers) {
            layers(Stream.of(layers).map(c -> AwsLambdaFunctionLayer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<AwsLambdaFunctionLayer.BuilderImpl> layers) {
            this.layers = AwsLambdaFunctionLayerListCopier.copyFromBuilder(layers);
        }

        public final String getMasterArn() {
            return masterArn;
        }

        @Override
        public final Builder masterArn(String masterArn) {
            this.masterArn = masterArn;
            return this;
        }

        public final void setMasterArn(String masterArn) {
            this.masterArn = masterArn;
        }

        public final Integer getMemorySize() {
            return memorySize;
        }

        @Override
        public final Builder memorySize(Integer memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        public final void setMemorySize(Integer memorySize) {
            this.memorySize = memorySize;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getRuntime() {
            return runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public final Integer getTimeout() {
            return timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public final AwsLambdaFunctionTracingConfig.Builder getTracingConfig() {
            return tracingConfig != null ? tracingConfig.toBuilder() : null;
        }

        @Override
        public final Builder tracingConfig(AwsLambdaFunctionTracingConfig tracingConfig) {
            this.tracingConfig = tracingConfig;
            return this;
        }

        public final void setTracingConfig(AwsLambdaFunctionTracingConfig.BuilderImpl tracingConfig) {
            this.tracingConfig = tracingConfig != null ? tracingConfig.build() : null;
        }

        public final AwsLambdaFunctionVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(AwsLambdaFunctionVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(AwsLambdaFunctionVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public AwsLambdaFunctionDetails build() {
            return new AwsLambdaFunctionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
