/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A VPC security group that the cluster belongs to, if the cluster is in a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterVpcSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterVpcSecurityGroup.Builder, AwsRedshiftClusterVpcSecurityGroup> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRedshiftClusterVpcSecurityGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VPC_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcSecurityGroupId").getter(getter(AwsRedshiftClusterVpcSecurityGroup::vpcSecurityGroupId))
            .setter(setter(Builder::vpcSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            VPC_SECURITY_GROUP_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String vpcSecurityGroupId;

    private AwsRedshiftClusterVpcSecurityGroup(BuilderImpl builder) {
        this.status = builder.status;
        this.vpcSecurityGroupId = builder.vpcSecurityGroupId;
    }

    /**
     * <p>
     * The status of the VPC security group.
     * </p>
     * 
     * @return The status of the VPC security group.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The identifier of the VPC security group.
     * </p>
     * 
     * @return The identifier of the VPC security group.
     */
    public final String vpcSecurityGroupId() {
        return vpcSecurityGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterVpcSecurityGroup)) {
            return false;
        }
        AwsRedshiftClusterVpcSecurityGroup other = (AwsRedshiftClusterVpcSecurityGroup) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(vpcSecurityGroupId(), other.vpcSecurityGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterVpcSecurityGroup").add("Status", status())
                .add("VpcSecurityGroupId", vpcSecurityGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "VpcSecurityGroupId":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterVpcSecurityGroup, T> g) {
        return obj -> g.apply((AwsRedshiftClusterVpcSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterVpcSecurityGroup> {
        /**
         * <p>
         * The status of the VPC security group.
         * </p>
         * 
         * @param status
         *        The status of the VPC security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The identifier of the VPC security group.
         * </p>
         * 
         * @param vpcSecurityGroupId
         *        The identifier of the VPC security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupId(String vpcSecurityGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String vpcSecurityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterVpcSecurityGroup model) {
            status(model.status);
            vpcSecurityGroupId(model.vpcSecurityGroupId);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getVpcSecurityGroupId() {
            return vpcSecurityGroupId;
        }

        @Override
        public final Builder vpcSecurityGroupId(String vpcSecurityGroupId) {
            this.vpcSecurityGroupId = vpcSecurityGroupId;
            return this;
        }

        public final void setVpcSecurityGroupId(String vpcSecurityGroupId) {
            this.vpcSecurityGroupId = vpcSecurityGroupId;
        }

        @Override
        public AwsRedshiftClusterVpcSecurityGroup build() {
            return new AwsRedshiftClusterVpcSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
