/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value to use for the filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails> TAG_FIELD = SdkField
            .<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Tag").getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails::tag))
            .setter(setter(Builder::tag))
            .constructor(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails::type))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, TAG_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails tag;

    private final String type;

    private AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.tag = builder.tag;
        this.type = builder.type;
    }

    /**
     * <p>
     * Prefix text for matching objects.
     * </p>
     * 
     * @return Prefix text for matching objects.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * A tag that is assigned to matching objects.
     * </p>
     * 
     * @return A tag that is assigned to matching objects.
     */
    public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails tag() {
        return tag;
    }

    /**
     * <p>
     * The type of filter value.
     * </p>
     * 
     * @return The type of filter value.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(tag());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(tag(), other.tag())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails")
                .add("Prefix", prefix()).add("Tag", tag()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Tag":
            return Optional.ofNullable(clazz.cast(tag()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails> {
        /**
         * <p>
         * Prefix text for matching objects.
         * </p>
         * 
         * @param prefix
         *        Prefix text for matching objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * A tag that is assigned to matching objects.
         * </p>
         * 
         * @param tag
         *        A tag that is assigned to matching objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails tag);

        /**
         * <p>
         * A tag that is assigned to matching objects.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.Builder} avoiding the
         * need to create one manually via
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails)}.
         * 
         * @param tag
         *        a consumer that will call methods on
         *        {@link AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails)
         */
        default Builder tag(Consumer<AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.Builder> tag) {
            return tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.builder().applyMutation(tag)
                    .build());
        }

        /**
         * <p>
         * The type of filter value.
         * </p>
         * 
         * @param type
         *        The type of filter value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails tag;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails model) {
            prefix(model.prefix);
            tag(model.tag);
            type(model.type);
        }

        public final String getPrefix() {
            return prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.Builder getTag() {
            return tag != null ? tag.toBuilder() : null;
        }

        @Override
        public final Builder tag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails tag) {
            this.tag = tag;
            return this;
        }

        public final void setTag(AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsTagDetails.BuilderImpl tag) {
            this.tag = tag != null ? tag.build() : null;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesFilterPredicateOperandsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
