/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A transition rule that describes when noncurrent objects transition to a specified storage class.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> {
    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Days")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails::days))
            .setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails::storageClass))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD,
            STORAGE_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer days;

    private final String storageClass;

    private AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(BuilderImpl builder) {
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
     * </p>
     * 
     * @return The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
     */
    public final Integer days() {
        return days;
    }

    /**
     * <p>
     * The class of storage to change the object to after the object is noncurrent for the specified number of days.
     * </p>
     * 
     * @return The class of storage to change the object to after the object is noncurrent for the specified number of
     *         days.
     */
    public final String storageClass() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails) obj;
        return Objects.equals(days(), other.days()) && Objects.equals(storageClass(), other.storageClass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails")
                .add("Days", days()).add("StorageClass", storageClass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Days":
            return Optional.ofNullable(clazz.cast(days()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails> {
        /**
         * <p>
         * The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
         * </p>
         * 
         * @param days
         *        The number of days that an object is noncurrent before Amazon S3 can perform the associated action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * <p>
         * The class of storage to change the object to after the object is noncurrent for the specified number of days.
         * </p>
         * 
         * @param storageClass
         *        The class of storage to change the object to after the object is noncurrent for the specified number
         *        of days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(String storageClass);
    }

    static final class BuilderImpl implements Builder {
        private Integer days;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails model) {
            days(model.days);
            storageClass(model.storageClass);
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesNoncurrentVersionTransitionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
