/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A rule for when objects transition to specific storage classes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails.Builder, AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> {
    private static final SdkField<String> DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Date")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Days")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails::days)).setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageClass")
            .getter(getter(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails::storageClass))
            .setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, DAYS_FIELD,
            STORAGE_CLASS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String date;

    private final Integer days;

    private final String storageClass;

    private AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(BuilderImpl builder) {
        this.date = builder.date;
        this.days = builder.days;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * A date on which to transition objects to the specified storage class. If you provide <code>Date</code>, you
     * cannot provide <code>Days</code>.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return A date on which to transition objects to the specified storage class. If you provide <code>Date</code>,
     *         you cannot provide <code>Days</code>.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String date() {
        return date;
    }

    /**
     * <p>
     * The number of days after which to transition the object to the specified storage class. If you provide
     * <code>Days</code>, you cannot provide <code>Date</code>.
     * </p>
     * 
     * @return The number of days after which to transition the object to the specified storage class. If you provide
     *         <code>Days</code>, you cannot provide <code>Date</code>.
     */
    public final Integer days() {
        return days;
    }

    /**
     * <p>
     * The storage class to transition the object to.
     * </p>
     * 
     * @return The storage class to transition the object to.
     */
    public final String storageClass() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(days());
        hashCode = 31 * hashCode + Objects.hashCode(storageClass());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails)) {
            return false;
        }
        AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails other = (AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(days(), other.days())
                && Objects.equals(storageClass(), other.storageClass());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails").add("Date", date())
                .add("Days", days()).add("StorageClass", storageClass()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "Days":
            return Optional.ofNullable(clazz.cast(days()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClass()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails, T> g) {
        return obj -> g.apply((AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails> {
        /**
         * <p>
         * A date on which to transition objects to the specified storage class. If you provide <code>Date</code>, you
         * cannot provide <code>Days</code>.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param date
         *        A date on which to transition objects to the specified storage class. If you provide <code>Date</code>
         *        , you cannot provide <code>Days</code>.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(String date);

        /**
         * <p>
         * The number of days after which to transition the object to the specified storage class. If you provide
         * <code>Days</code>, you cannot provide <code>Date</code>.
         * </p>
         * 
         * @param days
         *        The number of days after which to transition the object to the specified storage class. If you provide
         *        <code>Days</code>, you cannot provide <code>Date</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);

        /**
         * <p>
         * The storage class to transition the object to.
         * </p>
         * 
         * @param storageClass
         *        The storage class to transition the object to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageClass(String storageClass);
    }

    static final class BuilderImpl implements Builder {
        private String date;

        private Integer days;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails model) {
            date(model.date);
            days(model.days);
            storageClass(model.storageClass);
        }

        public final String getDate() {
            return date;
        }

        @Override
        public final Builder date(String date) {
            this.date = date;
            return this;
        }

        public final void setDate(String date) {
            this.date = date;
        }

        public final Integer getDays() {
            return days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails build() {
            return new AwsS3BucketBucketLifecycleConfigurationRulesTransitionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
