/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data about a queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSqsQueueDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSqsQueueDetails.Builder, AwsSqsQueueDetails> {
    private static final SdkField<Integer> KMS_DATA_KEY_REUSE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("KmsDataKeyReusePeriodSeconds")
            .getter(getter(AwsSqsQueueDetails::kmsDataKeyReusePeriodSeconds))
            .setter(setter(Builder::kmsDataKeyReusePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsDataKeyReusePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsMasterKeyId").getter(getter(AwsSqsQueueDetails::kmsMasterKeyId))
            .setter(setter(Builder::kmsMasterKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsMasterKeyId").build()).build();

    private static final SdkField<String> QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueName").getter(getter(AwsSqsQueueDetails::queueName)).setter(setter(Builder::queueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueName").build()).build();

    private static final SdkField<String> DEAD_LETTER_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeadLetterTargetArn").getter(getter(AwsSqsQueueDetails::deadLetterTargetArn))
            .setter(setter(Builder::deadLetterTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterTargetArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            KMS_DATA_KEY_REUSE_PERIOD_SECONDS_FIELD, KMS_MASTER_KEY_ID_FIELD, QUEUE_NAME_FIELD, DEAD_LETTER_TARGET_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer kmsDataKeyReusePeriodSeconds;

    private final String kmsMasterKeyId;

    private final String queueName;

    private final String deadLetterTargetArn;

    private AwsSqsQueueDetails(BuilderImpl builder) {
        this.kmsDataKeyReusePeriodSeconds = builder.kmsDataKeyReusePeriodSeconds;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
        this.queueName = builder.queueName;
        this.deadLetterTargetArn = builder.deadLetterTargetArn;
    }

    /**
     * <p>
     * The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages before
     * calling AWS KMS again.
     * </p>
     * 
     * @return The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages
     *         before calling AWS KMS again.
     */
    public final Integer kmsDataKeyReusePeriodSeconds() {
        return kmsDataKeyReusePeriodSeconds;
    }

    /**
     * <p>
     * The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
     * </p>
     * 
     * @return The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
     */
    public final String kmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    /**
     * <p>
     * The name of the new queue.
     * </p>
     * 
     * @return The name of the new queue.
     */
    public final String queueName() {
        return queueName;
    }

    /**
     * <p>
     * The ARN of the dead-letter queue to which Amazon SQS moves messages after the value of
     * <code>maxReceiveCount</code> is exceeded.
     * </p>
     * 
     * @return The ARN of the dead-letter queue to which Amazon SQS moves messages after the value of
     *         <code>maxReceiveCount</code> is exceeded.
     */
    public final String deadLetterTargetArn() {
        return deadLetterTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kmsDataKeyReusePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(kmsMasterKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(queueName());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterTargetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSqsQueueDetails)) {
            return false;
        }
        AwsSqsQueueDetails other = (AwsSqsQueueDetails) obj;
        return Objects.equals(kmsDataKeyReusePeriodSeconds(), other.kmsDataKeyReusePeriodSeconds())
                && Objects.equals(kmsMasterKeyId(), other.kmsMasterKeyId()) && Objects.equals(queueName(), other.queueName())
                && Objects.equals(deadLetterTargetArn(), other.deadLetterTargetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSqsQueueDetails").add("KmsDataKeyReusePeriodSeconds", kmsDataKeyReusePeriodSeconds())
                .add("KmsMasterKeyId", kmsMasterKeyId()).add("QueueName", queueName())
                .add("DeadLetterTargetArn", deadLetterTargetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KmsDataKeyReusePeriodSeconds":
            return Optional.ofNullable(clazz.cast(kmsDataKeyReusePeriodSeconds()));
        case "KmsMasterKeyId":
            return Optional.ofNullable(clazz.cast(kmsMasterKeyId()));
        case "QueueName":
            return Optional.ofNullable(clazz.cast(queueName()));
        case "DeadLetterTargetArn":
            return Optional.ofNullable(clazz.cast(deadLetterTargetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSqsQueueDetails, T> g) {
        return obj -> g.apply((AwsSqsQueueDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSqsQueueDetails> {
        /**
         * <p>
         * The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt messages
         * before calling AWS KMS again.
         * </p>
         * 
         * @param kmsDataKeyReusePeriodSeconds
         *        The length of time, in seconds, for which Amazon SQS can reuse a data key to encrypt or decrypt
         *        messages before calling AWS KMS again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds);

        /**
         * <p>
         * The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
         * </p>
         * 
         * @param kmsMasterKeyId
         *        The ID of an AWS managed customer master key (CMK) for Amazon SQS or a custom CMK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsMasterKeyId(String kmsMasterKeyId);

        /**
         * <p>
         * The name of the new queue.
         * </p>
         * 
         * @param queueName
         *        The name of the new queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueName(String queueName);

        /**
         * <p>
         * The ARN of the dead-letter queue to which Amazon SQS moves messages after the value of
         * <code>maxReceiveCount</code> is exceeded.
         * </p>
         * 
         * @param deadLetterTargetArn
         *        The ARN of the dead-letter queue to which Amazon SQS moves messages after the value of
         *        <code>maxReceiveCount</code> is exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterTargetArn(String deadLetterTargetArn);
    }

    static final class BuilderImpl implements Builder {
        private Integer kmsDataKeyReusePeriodSeconds;

        private String kmsMasterKeyId;

        private String queueName;

        private String deadLetterTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSqsQueueDetails model) {
            kmsDataKeyReusePeriodSeconds(model.kmsDataKeyReusePeriodSeconds);
            kmsMasterKeyId(model.kmsMasterKeyId);
            queueName(model.queueName);
            deadLetterTargetArn(model.deadLetterTargetArn);
        }

        public final Integer getKmsDataKeyReusePeriodSeconds() {
            return kmsDataKeyReusePeriodSeconds;
        }

        @Override
        public final Builder kmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
            this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
            return this;
        }

        public final void setKmsDataKeyReusePeriodSeconds(Integer kmsDataKeyReusePeriodSeconds) {
            this.kmsDataKeyReusePeriodSeconds = kmsDataKeyReusePeriodSeconds;
        }

        public final String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        @Override
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public final String getQueueName() {
            return queueName;
        }

        @Override
        public final Builder queueName(String queueName) {
            this.queueName = queueName;
            return this;
        }

        public final void setQueueName(String queueName) {
            this.queueName = queueName;
        }

        public final String getDeadLetterTargetArn() {
            return deadLetterTargetArn;
        }

        @Override
        public final Builder deadLetterTargetArn(String deadLetterTargetArn) {
            this.deadLetterTargetArn = deadLetterTargetArn;
            return this;
        }

        public final void setDeadLetterTargetArn(String deadLetterTargetArn) {
            this.deadLetterTargetArn = deadLetterTargetArn;
        }

        @Override
        public AwsSqsQueueDetails build() {
            return new AwsSqsQueueDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
