/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the state of a patch on an instance based on the patch baseline that was used to patch the
 * instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsSsmPatchComplianceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsSsmPatchComplianceDetails.Builder, AwsSsmPatchComplianceDetails> {
    private static final SdkField<AwsSsmPatch> PATCH_FIELD = SdkField.<AwsSsmPatch> builder(MarshallingType.SDK_POJO)
            .memberName("Patch").getter(getter(AwsSsmPatchComplianceDetails::patch)).setter(setter(Builder::patch))
            .constructor(AwsSsmPatch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patch").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsSsmPatch patch;

    private AwsSsmPatchComplianceDetails(BuilderImpl builder) {
        this.patch = builder.patch;
    }

    /**
     * <p>
     * Information about the status of a patch.
     * </p>
     * 
     * @return Information about the status of a patch.
     */
    public final AwsSsmPatch patch() {
        return patch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(patch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsSsmPatchComplianceDetails)) {
            return false;
        }
        AwsSsmPatchComplianceDetails other = (AwsSsmPatchComplianceDetails) obj;
        return Objects.equals(patch(), other.patch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsSsmPatchComplianceDetails").add("Patch", patch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patch":
            return Optional.ofNullable(clazz.cast(patch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsSsmPatchComplianceDetails, T> g) {
        return obj -> g.apply((AwsSsmPatchComplianceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsSsmPatchComplianceDetails> {
        /**
         * <p>
         * Information about the status of a patch.
         * </p>
         * 
         * @param patch
         *        Information about the status of a patch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patch(AwsSsmPatch patch);

        /**
         * <p>
         * Information about the status of a patch.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsSsmPatch.Builder} avoiding the need to create
         * one manually via {@link AwsSsmPatch#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsSsmPatch.Builder#build()} is called immediately and its result
         * is passed to {@link #patch(AwsSsmPatch)}.
         * 
         * @param patch
         *        a consumer that will call methods on {@link AwsSsmPatch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patch(AwsSsmPatch)
         */
        default Builder patch(Consumer<AwsSsmPatch.Builder> patch) {
            return patch(AwsSsmPatch.builder().applyMutation(patch).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsSsmPatch patch;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsSsmPatchComplianceDetails model) {
            patch(model.patch);
        }

        public final AwsSsmPatch.Builder getPatch() {
            return patch != null ? patch.toBuilder() : null;
        }

        @Override
        public final Builder patch(AwsSsmPatch patch) {
            this.patch = patch;
            return this;
        }

        public final void setPatch(AwsSsmPatch.BuilderImpl patch) {
            this.patch = patch != null ? patch.build() : null;
        }

        @Override
        public AwsSsmPatchComplianceDetails build() {
            return new AwsSsmPatchComplianceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
