/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a WAF WebACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafWebAclDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafWebAclDetails.Builder, AwsWafWebAclDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsWafWebAclDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DEFAULT_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultAction").getter(getter(AwsWafWebAclDetails::defaultAction))
            .setter(setter(Builder::defaultAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAction").build()).build();

    private static final SdkField<List<AwsWafWebAclRule>> RULES_FIELD = SdkField
            .<List<AwsWafWebAclRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(AwsWafWebAclDetails::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsWafWebAclRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsWafWebAclRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclId").getter(getter(AwsWafWebAclDetails::webAclId)).setter(setter(Builder::webAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DEFAULT_ACTION_FIELD, RULES_FIELD, WEB_ACL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String defaultAction;

    private final List<AwsWafWebAclRule> rules;

    private final String webAclId;

    private AwsWafWebAclDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultAction = builder.defaultAction;
        this.rules = builder.rules;
        this.webAclId = builder.webAclId;
    }

    /**
     * <p>
     * A friendly name or description of the WebACL. You can't change the name of a WebACL after you create it.
     * </p>
     * 
     * @return A friendly name or description of the WebACL. You can't change the name of a WebACL after you create it.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The action to perform if none of the rules contained in the WebACL match.
     * </p>
     * 
     * @return The action to perform if none of the rules contained in the WebACL match.
     */
    public final String defaultAction() {
        return defaultAction;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the
     *         rule.
     */
    public final List<AwsWafWebAclRule> rules() {
        return rules;
    }

    /**
     * <p>
     * A unique identifier for a WebACL.
     * </p>
     * 
     * @return A unique identifier for a WebACL.
     */
    public final String webAclId() {
        return webAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAction());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webAclId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafWebAclDetails)) {
            return false;
        }
        AwsWafWebAclDetails other = (AwsWafWebAclDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(defaultAction(), other.defaultAction())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules())
                && Objects.equals(webAclId(), other.webAclId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafWebAclDetails").add("Name", name()).add("DefaultAction", defaultAction())
                .add("Rules", hasRules() ? rules() : null).add("WebAclId", webAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultAction":
            return Optional.ofNullable(clazz.cast(defaultAction()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        case "WebAclId":
            return Optional.ofNullable(clazz.cast(webAclId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafWebAclDetails, T> g) {
        return obj -> g.apply((AwsWafWebAclDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafWebAclDetails> {
        /**
         * <p>
         * A friendly name or description of the WebACL. You can't change the name of a WebACL after you create it.
         * </p>
         * 
         * @param name
         *        A friendly name or description of the WebACL. You can't change the name of a WebACL after you create
         *        it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The action to perform if none of the rules contained in the WebACL match.
         * </p>
         * 
         * @param defaultAction
         *        The action to perform if none of the rules contained in the WebACL match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAction(String defaultAction);

        /**
         * <p>
         * An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * 
         * @param rules
         *        An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of
         *        the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<AwsWafWebAclRule> rules);

        /**
         * <p>
         * An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * 
         * @param rules
         *        An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of
         *        the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(AwsWafWebAclRule... rules);

        /**
         * <p>
         * An array that contains the action for each rule in a WebACL, the priority of the rule, and the ID of the
         * rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsWafWebAclRule>.Builder} avoiding the
         * need to create one manually via {@link List<AwsWafWebAclRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsWafWebAclRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<AwsWafWebAclRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<AwsWafWebAclRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<AwsWafWebAclRule>)
         */
        Builder rules(Consumer<AwsWafWebAclRule.Builder>... rules);

        /**
         * <p>
         * A unique identifier for a WebACL.
         * </p>
         * 
         * @param webAclId
         *        A unique identifier for a WebACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclId(String webAclId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String defaultAction;

        private List<AwsWafWebAclRule> rules = DefaultSdkAutoConstructList.getInstance();

        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafWebAclDetails model) {
            name(model.name);
            defaultAction(model.defaultAction);
            rules(model.rules);
            webAclId(model.webAclId);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefaultAction() {
            return defaultAction;
        }

        @Override
        public final Builder defaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
            return this;
        }

        public final void setDefaultAction(String defaultAction) {
            this.defaultAction = defaultAction;
        }

        public final List<AwsWafWebAclRule.Builder> getRules() {
            List<AwsWafWebAclRule.Builder> result = AwsWafWebAclRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rules(Collection<AwsWafWebAclRule> rules) {
            this.rules = AwsWafWebAclRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(AwsWafWebAclRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<AwsWafWebAclRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> AwsWafWebAclRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<AwsWafWebAclRule.BuilderImpl> rules) {
            this.rules = AwsWafWebAclRuleListCopier.copyFromBuilder(rules);
        }

        public final String getWebAclId() {
            return webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        public AwsWafWebAclDetails build() {
            return new AwsWafWebAclDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
