/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An occurrence of sensitive data in an Apache Avro object container or an Apache Parquet file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Record implements SdkPojo, Serializable, ToCopyableBuilder<Record.Builder, Record> {
    private static final SdkField<String> JSON_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JsonPath").getter(getter(Record::jsonPath)).setter(setter(Builder::jsonPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JsonPath").build()).build();

    private static final SdkField<Long> RECORD_INDEX_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordIndex").getter(getter(Record::recordIndex)).setter(setter(Builder::recordIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JSON_PATH_FIELD,
            RECORD_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jsonPath;

    private final Long recordIndex;

    private Record(BuilderImpl builder) {
        this.jsonPath = builder.jsonPath;
        this.recordIndex = builder.recordIndex;
    }

    /**
     * <p>
     * The path, as a JSONPath expression, to the field in the record that contains the data. If the field name is
     * longer than 20 characters, it is truncated. If the path is longer than 250 characters, it is truncated.
     * </p>
     * 
     * @return The path, as a JSONPath expression, to the field in the record that contains the data. If the field name
     *         is longer than 20 characters, it is truncated. If the path is longer than 250 characters, it is
     *         truncated.
     */
    public final String jsonPath() {
        return jsonPath;
    }

    /**
     * <p>
     * The record index, starting from 0, for the record that contains the data.
     * </p>
     * 
     * @return The record index, starting from 0, for the record that contains the data.
     */
    public final Long recordIndex() {
        return recordIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jsonPath());
        hashCode = 31 * hashCode + Objects.hashCode(recordIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Record)) {
            return false;
        }
        Record other = (Record) obj;
        return Objects.equals(jsonPath(), other.jsonPath()) && Objects.equals(recordIndex(), other.recordIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Record").add("JsonPath", jsonPath()).add("RecordIndex", recordIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JsonPath":
            return Optional.ofNullable(clazz.cast(jsonPath()));
        case "RecordIndex":
            return Optional.ofNullable(clazz.cast(recordIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Record, T> g) {
        return obj -> g.apply((Record) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Record> {
        /**
         * <p>
         * The path, as a JSONPath expression, to the field in the record that contains the data. If the field name is
         * longer than 20 characters, it is truncated. If the path is longer than 250 characters, it is truncated.
         * </p>
         * 
         * @param jsonPath
         *        The path, as a JSONPath expression, to the field in the record that contains the data. If the field
         *        name is longer than 20 characters, it is truncated. If the path is longer than 250 characters, it is
         *        truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jsonPath(String jsonPath);

        /**
         * <p>
         * The record index, starting from 0, for the record that contains the data.
         * </p>
         * 
         * @param recordIndex
         *        The record index, starting from 0, for the record that contains the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIndex(Long recordIndex);
    }

    static final class BuilderImpl implements Builder {
        private String jsonPath;

        private Long recordIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(Record model) {
            jsonPath(model.jsonPath);
            recordIndex(model.recordIndex);
        }

        public final String getJsonPath() {
            return jsonPath;
        }

        @Override
        public final Builder jsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
            return this;
        }

        public final void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public final Long getRecordIndex() {
            return recordIndex;
        }

        @Override
        public final Builder recordIndex(Long recordIndex) {
            this.recordIndex = recordIndex;
            return this;
        }

        public final void setRecordIndex(Long recordIndex) {
            this.recordIndex = recordIndex;
        }

        @Override
        public Record build() {
            return new Record(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
