/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A vulnerability associated with a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Vulnerability implements SdkPojo, Serializable, ToCopyableBuilder<Vulnerability.Builder, Vulnerability> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Vulnerability::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<SoftwarePackage>> VULNERABLE_PACKAGES_FIELD = SdkField
            .<List<SoftwarePackage>> builder(MarshallingType.LIST)
            .memberName("VulnerablePackages")
            .getter(getter(Vulnerability::vulnerablePackages))
            .setter(setter(Builder::vulnerablePackages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VulnerablePackages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SoftwarePackage> builder(MarshallingType.SDK_POJO)
                                            .constructor(SoftwarePackage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Cvss>> CVSS_FIELD = SdkField
            .<List<Cvss>> builder(MarshallingType.LIST)
            .memberName("Cvss")
            .getter(getter(Vulnerability::cvss))
            .setter(setter(Builder::cvss))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cvss").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Cvss> builder(MarshallingType.SDK_POJO)
                                            .constructor(Cvss::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RELATED_VULNERABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RelatedVulnerabilities")
            .getter(getter(Vulnerability::relatedVulnerabilities))
            .setter(setter(Builder::relatedVulnerabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedVulnerabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VulnerabilityVendor> VENDOR_FIELD = SdkField
            .<VulnerabilityVendor> builder(MarshallingType.SDK_POJO).memberName("Vendor").getter(getter(Vulnerability::vendor))
            .setter(setter(Builder::vendor)).constructor(VulnerabilityVendor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vendor").build()).build();

    private static final SdkField<List<String>> REFERENCE_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReferenceUrls")
            .getter(getter(Vulnerability::referenceUrls))
            .setter(setter(Builder::referenceUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            VULNERABLE_PACKAGES_FIELD, CVSS_FIELD, RELATED_VULNERABILITIES_FIELD, VENDOR_FIELD, REFERENCE_URLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<SoftwarePackage> vulnerablePackages;

    private final List<Cvss> cvss;

    private final List<String> relatedVulnerabilities;

    private final VulnerabilityVendor vendor;

    private final List<String> referenceUrls;

    private Vulnerability(BuilderImpl builder) {
        this.id = builder.id;
        this.vulnerablePackages = builder.vulnerablePackages;
        this.cvss = builder.cvss;
        this.relatedVulnerabilities = builder.relatedVulnerabilities;
        this.vendor = builder.vendor;
        this.referenceUrls = builder.referenceUrls;
    }

    /**
     * <p>
     * The identifier of the vulnerability.
     * </p>
     * 
     * @return The identifier of the vulnerability.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns true if the VulnerablePackages property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasVulnerablePackages() {
        return vulnerablePackages != null && !(vulnerablePackages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of software packages that have the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVulnerablePackages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of software packages that have the vulnerability.
     */
    public final List<SoftwarePackage> vulnerablePackages() {
        return vulnerablePackages;
    }

    /**
     * Returns true if the Cvss property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCvss() {
        return cvss != null && !(cvss instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * CVSS scores from the advisory related to the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCvss()} to see if a value was sent in this field.
     * </p>
     * 
     * @return CVSS scores from the advisory related to the vulnerability.
     */
    public final List<Cvss> cvss() {
        return cvss;
    }

    /**
     * Returns true if the RelatedVulnerabilities property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRelatedVulnerabilities() {
        return relatedVulnerabilities != null && !(relatedVulnerabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of vulnerabilities that are related to this vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRelatedVulnerabilities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of vulnerabilities that are related to this vulnerability.
     */
    public final List<String> relatedVulnerabilities() {
        return relatedVulnerabilities;
    }

    /**
     * <p>
     * Information about the vendor that generates the vulnerability report.
     * </p>
     * 
     * @return Information about the vendor that generates the vulnerability report.
     */
    public final VulnerabilityVendor vendor() {
        return vendor;
    }

    /**
     * Returns true if the ReferenceUrls property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasReferenceUrls() {
        return referenceUrls != null && !(referenceUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of URLs that provide additional information about the vulnerability.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReferenceUrls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of URLs that provide additional information about the vulnerability.
     */
    public final List<String> referenceUrls() {
        return referenceUrls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasVulnerablePackages() ? vulnerablePackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCvss() ? cvss() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedVulnerabilities() ? relatedVulnerabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vendor());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceUrls() ? referenceUrls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vulnerability)) {
            return false;
        }
        Vulnerability other = (Vulnerability) obj;
        return Objects.equals(id(), other.id()) && hasVulnerablePackages() == other.hasVulnerablePackages()
                && Objects.equals(vulnerablePackages(), other.vulnerablePackages()) && hasCvss() == other.hasCvss()
                && Objects.equals(cvss(), other.cvss()) && hasRelatedVulnerabilities() == other.hasRelatedVulnerabilities()
                && Objects.equals(relatedVulnerabilities(), other.relatedVulnerabilities())
                && Objects.equals(vendor(), other.vendor()) && hasReferenceUrls() == other.hasReferenceUrls()
                && Objects.equals(referenceUrls(), other.referenceUrls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Vulnerability").add("Id", id())
                .add("VulnerablePackages", hasVulnerablePackages() ? vulnerablePackages() : null)
                .add("Cvss", hasCvss() ? cvss() : null)
                .add("RelatedVulnerabilities", hasRelatedVulnerabilities() ? relatedVulnerabilities() : null)
                .add("Vendor", vendor()).add("ReferenceUrls", hasReferenceUrls() ? referenceUrls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "VulnerablePackages":
            return Optional.ofNullable(clazz.cast(vulnerablePackages()));
        case "Cvss":
            return Optional.ofNullable(clazz.cast(cvss()));
        case "RelatedVulnerabilities":
            return Optional.ofNullable(clazz.cast(relatedVulnerabilities()));
        case "Vendor":
            return Optional.ofNullable(clazz.cast(vendor()));
        case "ReferenceUrls":
            return Optional.ofNullable(clazz.cast(referenceUrls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Vulnerability, T> g) {
        return obj -> g.apply((Vulnerability) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Vulnerability> {
        /**
         * <p>
         * The identifier of the vulnerability.
         * </p>
         * 
         * @param id
         *        The identifier of the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * List of software packages that have the vulnerability.
         * </p>
         * 
         * @param vulnerablePackages
         *        List of software packages that have the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(Collection<SoftwarePackage> vulnerablePackages);

        /**
         * <p>
         * List of software packages that have the vulnerability.
         * </p>
         * 
         * @param vulnerablePackages
         *        List of software packages that have the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vulnerablePackages(SoftwarePackage... vulnerablePackages);

        /**
         * <p>
         * List of software packages that have the vulnerability.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SoftwarePackage>.Builder} avoiding the need
         * to create one manually via {@link List<SoftwarePackage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SoftwarePackage>.Builder#build()} is called immediately and
         * its result is passed to {@link #vulnerablePackages(List<SoftwarePackage>)}.
         * 
         * @param vulnerablePackages
         *        a consumer that will call methods on {@link List<SoftwarePackage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vulnerablePackages(List<SoftwarePackage>)
         */
        Builder vulnerablePackages(Consumer<SoftwarePackage.Builder>... vulnerablePackages);

        /**
         * <p>
         * CVSS scores from the advisory related to the vulnerability.
         * </p>
         * 
         * @param cvss
         *        CVSS scores from the advisory related to the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(Collection<Cvss> cvss);

        /**
         * <p>
         * CVSS scores from the advisory related to the vulnerability.
         * </p>
         * 
         * @param cvss
         *        CVSS scores from the advisory related to the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cvss(Cvss... cvss);

        /**
         * <p>
         * CVSS scores from the advisory related to the vulnerability.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Cvss>.Builder} avoiding the need to create
         * one manually via {@link List<Cvss>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Cvss>.Builder#build()} is called immediately and its result
         * is passed to {@link #cvss(List<Cvss>)}.
         * 
         * @param cvss
         *        a consumer that will call methods on {@link List<Cvss>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cvss(List<Cvss>)
         */
        Builder cvss(Consumer<Cvss.Builder>... cvss);

        /**
         * <p>
         * List of vulnerabilities that are related to this vulnerability.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        List of vulnerabilities that are related to this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities);

        /**
         * <p>
         * List of vulnerabilities that are related to this vulnerability.
         * </p>
         * 
         * @param relatedVulnerabilities
         *        List of vulnerabilities that are related to this vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedVulnerabilities(String... relatedVulnerabilities);

        /**
         * <p>
         * Information about the vendor that generates the vulnerability report.
         * </p>
         * 
         * @param vendor
         *        Information about the vendor that generates the vulnerability report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendor(VulnerabilityVendor vendor);

        /**
         * <p>
         * Information about the vendor that generates the vulnerability report.
         * </p>
         * This is a convenience that creates an instance of the {@link VulnerabilityVendor.Builder} avoiding the need
         * to create one manually via {@link VulnerabilityVendor#builder()}.
         *
         * When the {@link Consumer} completes, {@link VulnerabilityVendor.Builder#build()} is called immediately and
         * its result is passed to {@link #vendor(VulnerabilityVendor)}.
         * 
         * @param vendor
         *        a consumer that will call methods on {@link VulnerabilityVendor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vendor(VulnerabilityVendor)
         */
        default Builder vendor(Consumer<VulnerabilityVendor.Builder> vendor) {
            return vendor(VulnerabilityVendor.builder().applyMutation(vendor).build());
        }

        /**
         * <p>
         * A list of URLs that provide additional information about the vulnerability.
         * </p>
         * 
         * @param referenceUrls
         *        A list of URLs that provide additional information about the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(Collection<String> referenceUrls);

        /**
         * <p>
         * A list of URLs that provide additional information about the vulnerability.
         * </p>
         * 
         * @param referenceUrls
         *        A list of URLs that provide additional information about the vulnerability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceUrls(String... referenceUrls);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<SoftwarePackage> vulnerablePackages = DefaultSdkAutoConstructList.getInstance();

        private List<Cvss> cvss = DefaultSdkAutoConstructList.getInstance();

        private List<String> relatedVulnerabilities = DefaultSdkAutoConstructList.getInstance();

        private VulnerabilityVendor vendor;

        private List<String> referenceUrls = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Vulnerability model) {
            id(model.id);
            vulnerablePackages(model.vulnerablePackages);
            cvss(model.cvss);
            relatedVulnerabilities(model.relatedVulnerabilities);
            vendor(model.vendor);
            referenceUrls(model.referenceUrls);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final List<SoftwarePackage.Builder> getVulnerablePackages() {
            List<SoftwarePackage.Builder> result = SoftwarePackageListCopier.copyToBuilder(this.vulnerablePackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder vulnerablePackages(Collection<SoftwarePackage> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copy(vulnerablePackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(SoftwarePackage... vulnerablePackages) {
            vulnerablePackages(Arrays.asList(vulnerablePackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vulnerablePackages(Consumer<SoftwarePackage.Builder>... vulnerablePackages) {
            vulnerablePackages(Stream.of(vulnerablePackages).map(c -> SoftwarePackage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVulnerablePackages(Collection<SoftwarePackage.BuilderImpl> vulnerablePackages) {
            this.vulnerablePackages = SoftwarePackageListCopier.copyFromBuilder(vulnerablePackages);
        }

        public final List<Cvss.Builder> getCvss() {
            List<Cvss.Builder> result = CvssListCopier.copyToBuilder(this.cvss);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder cvss(Collection<Cvss> cvss) {
            this.cvss = CvssListCopier.copy(cvss);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Cvss... cvss) {
            cvss(Arrays.asList(cvss));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cvss(Consumer<Cvss.Builder>... cvss) {
            cvss(Stream.of(cvss).map(c -> Cvss.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCvss(Collection<Cvss.BuilderImpl> cvss) {
            this.cvss = CvssListCopier.copyFromBuilder(cvss);
        }

        public final Collection<String> getRelatedVulnerabilities() {
            if (relatedVulnerabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return relatedVulnerabilities;
        }

        @Override
        public final Builder relatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedVulnerabilities(String... relatedVulnerabilities) {
            relatedVulnerabilities(Arrays.asList(relatedVulnerabilities));
            return this;
        }

        public final void setRelatedVulnerabilities(Collection<String> relatedVulnerabilities) {
            this.relatedVulnerabilities = StringListCopier.copy(relatedVulnerabilities);
        }

        public final VulnerabilityVendor.Builder getVendor() {
            return vendor != null ? vendor.toBuilder() : null;
        }

        @Override
        public final Builder vendor(VulnerabilityVendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public final void setVendor(VulnerabilityVendor.BuilderImpl vendor) {
            this.vendor = vendor != null ? vendor.build() : null;
        }

        public final Collection<String> getReferenceUrls() {
            if (referenceUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return referenceUrls;
        }

        @Override
        public final Builder referenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceUrls(String... referenceUrls) {
            referenceUrls(Arrays.asList(referenceUrls));
            return this;
        }

        public final void setReferenceUrls(Collection<String> referenceUrls) {
            this.referenceUrls = StringListCopier.copy(referenceUrls);
        }

        @Override
        public Vulnerability build() {
            return new Vulnerability(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
