/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the IP address where the scanned port is located.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionLocalIpDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionLocalIpDetails.Builder, ActionLocalIpDetails> {
    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressV4").getter(getter(ActionLocalIpDetails::ipAddressV4)).setter(setter(Builder::ipAddressV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressV4").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_V4_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ipAddressV4;

    private ActionLocalIpDetails(BuilderImpl builder) {
        this.ipAddressV4 = builder.ipAddressV4;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public final String ipAddressV4() {
        return ipAddressV4;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressV4());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionLocalIpDetails)) {
            return false;
        }
        ActionLocalIpDetails other = (ActionLocalIpDetails) obj;
        return Objects.equals(ipAddressV4(), other.ipAddressV4());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionLocalIpDetails").add("IpAddressV4", ipAddressV4()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddressV4":
            return Optional.ofNullable(clazz.cast(ipAddressV4()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionLocalIpDetails, T> g) {
        return obj -> g.apply((ActionLocalIpDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionLocalIpDetails> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param ipAddressV4
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressV4(String ipAddressV4);
    }

    static final class BuilderImpl implements Builder {
        private String ipAddressV4;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionLocalIpDetails model) {
            ipAddressV4(model.ipAddressV4);
        }

        public final String getIpAddressV4() {
            return ipAddressV4;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        @Override
        @Transient
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        @Override
        public ActionLocalIpDetails build() {
            return new ActionLocalIpDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
