/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines settings for a method for the stage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsApiGatewayMethodSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsApiGatewayMethodSettings.Builder, AwsApiGatewayMethodSettings> {
    private static final SdkField<Boolean> METRICS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MetricsEnabled").getter(getter(AwsApiGatewayMethodSettings::metricsEnabled))
            .setter(setter(Builder::metricsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsEnabled").build()).build();

    private static final SdkField<String> LOGGING_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingLevel").getter(getter(AwsApiGatewayMethodSettings::loggingLevel))
            .setter(setter(Builder::loggingLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingLevel").build()).build();

    private static final SdkField<Boolean> DATA_TRACE_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DataTraceEnabled").getter(getter(AwsApiGatewayMethodSettings::dataTraceEnabled))
            .setter(setter(Builder::dataTraceEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTraceEnabled").build()).build();

    private static final SdkField<Integer> THROTTLING_BURST_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThrottlingBurstLimit").getter(getter(AwsApiGatewayMethodSettings::throttlingBurstLimit))
            .setter(setter(Builder::throttlingBurstLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingBurstLimit").build())
            .build();

    private static final SdkField<Double> THROTTLING_RATE_LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThrottlingRateLimit").getter(getter(AwsApiGatewayMethodSettings::throttlingRateLimit))
            .setter(setter(Builder::throttlingRateLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrottlingRateLimit").build())
            .build();

    private static final SdkField<Boolean> CACHING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CachingEnabled").getter(getter(AwsApiGatewayMethodSettings::cachingEnabled))
            .setter(setter(Builder::cachingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachingEnabled").build()).build();

    private static final SdkField<Integer> CACHE_TTL_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CacheTtlInSeconds").getter(getter(AwsApiGatewayMethodSettings::cacheTtlInSeconds))
            .setter(setter(Builder::cacheTtlInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheTtlInSeconds").build()).build();

    private static final SdkField<Boolean> CACHE_DATA_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CacheDataEncrypted").getter(getter(AwsApiGatewayMethodSettings::cacheDataEncrypted))
            .setter(setter(Builder::cacheDataEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheDataEncrypted").build())
            .build();

    private static final SdkField<Boolean> REQUIRE_AUTHORIZATION_FOR_CACHE_CONTROL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireAuthorizationForCacheControl")
            .getter(getter(AwsApiGatewayMethodSettings::requireAuthorizationForCacheControl))
            .setter(setter(Builder::requireAuthorizationForCacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("RequireAuthorizationForCacheControl").build()).build();

    private static final SdkField<String> UNAUTHORIZED_CACHE_CONTROL_HEADER_STRATEGY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("UnauthorizedCacheControlHeaderStrategy")
            .getter(getter(AwsApiGatewayMethodSettings::unauthorizedCacheControlHeaderStrategy))
            .setter(setter(Builder::unauthorizedCacheControlHeaderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UnauthorizedCacheControlHeaderStrategy").build()).build();

    private static final SdkField<String> HTTP_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpMethod").getter(getter(AwsApiGatewayMethodSettings::httpMethod)).setter(setter(Builder::httpMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpMethod").build()).build();

    private static final SdkField<String> RESOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePath").getter(getter(AwsApiGatewayMethodSettings::resourcePath))
            .setter(setter(Builder::resourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_ENABLED_FIELD,
            LOGGING_LEVEL_FIELD, DATA_TRACE_ENABLED_FIELD, THROTTLING_BURST_LIMIT_FIELD, THROTTLING_RATE_LIMIT_FIELD,
            CACHING_ENABLED_FIELD, CACHE_TTL_IN_SECONDS_FIELD, CACHE_DATA_ENCRYPTED_FIELD,
            REQUIRE_AUTHORIZATION_FOR_CACHE_CONTROL_FIELD, UNAUTHORIZED_CACHE_CONTROL_HEADER_STRATEGY_FIELD, HTTP_METHOD_FIELD,
            RESOURCE_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean metricsEnabled;

    private final String loggingLevel;

    private final Boolean dataTraceEnabled;

    private final Integer throttlingBurstLimit;

    private final Double throttlingRateLimit;

    private final Boolean cachingEnabled;

    private final Integer cacheTtlInSeconds;

    private final Boolean cacheDataEncrypted;

    private final Boolean requireAuthorizationForCacheControl;

    private final String unauthorizedCacheControlHeaderStrategy;

    private final String httpMethod;

    private final String resourcePath;

    private AwsApiGatewayMethodSettings(BuilderImpl builder) {
        this.metricsEnabled = builder.metricsEnabled;
        this.loggingLevel = builder.loggingLevel;
        this.dataTraceEnabled = builder.dataTraceEnabled;
        this.throttlingBurstLimit = builder.throttlingBurstLimit;
        this.throttlingRateLimit = builder.throttlingRateLimit;
        this.cachingEnabled = builder.cachingEnabled;
        this.cacheTtlInSeconds = builder.cacheTtlInSeconds;
        this.cacheDataEncrypted = builder.cacheDataEncrypted;
        this.requireAuthorizationForCacheControl = builder.requireAuthorizationForCacheControl;
        this.unauthorizedCacheControlHeaderStrategy = builder.unauthorizedCacheControlHeaderStrategy;
        this.httpMethod = builder.httpMethod;
        this.resourcePath = builder.resourcePath;
    }

    /**
     * <p>
     * Indicates whether CloudWatch metrics are enabled for the method.
     * </p>
     * 
     * @return Indicates whether CloudWatch metrics are enabled for the method.
     */
    public final Boolean metricsEnabled() {
        return metricsEnabled;
    }

    /**
     * <p>
     * The logging level for this method. The logging level affects the log entries that are pushed to CloudWatch Logs.
     * </p>
     * <p>
     * If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
     * </p>
     * <p>
     * If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
     * informational events.
     * </p>
     * <p>
     * Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
     * </p>
     * 
     * @return The logging level for this method. The logging level affects the log entries that are pushed to
     *         CloudWatch Logs.</p>
     *         <p>
     *         If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
     *         </p>
     *         <p>
     *         If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
     *         informational events.
     *         </p>
     *         <p>
     *         Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
     */
    public final String loggingLevel() {
        return loggingLevel;
    }

    /**
     * <p>
     * Indicates whether data trace logging is enabled for the method. Data trace logging affects the log entries that
     * are pushed to CloudWatch Logs.
     * </p>
     * 
     * @return Indicates whether data trace logging is enabled for the method. Data trace logging affects the log
     *         entries that are pushed to CloudWatch Logs.
     */
    public final Boolean dataTraceEnabled() {
        return dataTraceEnabled;
    }

    /**
     * <p>
     * The throttling burst limit for the method.
     * </p>
     * 
     * @return The throttling burst limit for the method.
     */
    public final Integer throttlingBurstLimit() {
        return throttlingBurstLimit;
    }

    /**
     * <p>
     * The throttling rate limit for the method.
     * </p>
     * 
     * @return The throttling rate limit for the method.
     */
    public final Double throttlingRateLimit() {
        return throttlingRateLimit;
    }

    /**
     * <p>
     * Indicates whether responses are cached and returned for requests. For responses to be cached, a cache cluster
     * must be enabled on the stage.
     * </p>
     * 
     * @return Indicates whether responses are cached and returned for requests. For responses to be cached, a cache
     *         cluster must be enabled on the stage.
     */
    public final Boolean cachingEnabled() {
        return cachingEnabled;
    }

    /**
     * <p>
     * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response
     * is cached.
     * </p>
     * 
     * @return Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
     *         response is cached.
     */
    public final Integer cacheTtlInSeconds() {
        return cacheTtlInSeconds;
    }

    /**
     * <p>
     * Indicates whether the cached responses are encrypted.
     * </p>
     * 
     * @return Indicates whether the cached responses are encrypted.
     */
    public final Boolean cacheDataEncrypted() {
        return cacheDataEncrypted;
    }

    /**
     * <p>
     * Indicates whether authorization is required for a cache invalidation request.
     * </p>
     * 
     * @return Indicates whether authorization is required for a cache invalidation request.
     */
    public final Boolean requireAuthorizationForCacheControl() {
        return requireAuthorizationForCacheControl;
    }

    /**
     * <p>
     * Indicates how to handle unauthorized requests for cache invalidation.
     * </p>
     * <p>
     * Valid values: <code>FAIL_WITH_403</code> | <code>SUCCEED_WITH_RESPONSE_HEADER</code> |
     * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>
     * </p>
     * 
     * @return Indicates how to handle unauthorized requests for cache invalidation.</p>
     *         <p>
     *         Valid values: <code>FAIL_WITH_403</code> | <code>SUCCEED_WITH_RESPONSE_HEADER</code> |
     *         <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>
     */
    public final String unauthorizedCacheControlHeaderStrategy() {
        return unauthorizedCacheControlHeaderStrategy;
    }

    /**
     * <p>
     * The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
     * </p>
     * 
     * @return The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
     */
    public final String httpMethod() {
        return httpMethod;
    }

    /**
     * <p>
     * The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include a
     * forward slash.
     * </p>
     * <p>
     * For example, the path value <code>/resource/subresource</code> must be encoded as
     * <code>/~1resource~1subresource</code>.
     * </p>
     * <p>
     * To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method
     * settings to multiple methods.
     * </p>
     * 
     * @return The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include
     *         a forward slash.</p>
     *         <p>
     *         For example, the path value <code>/resource/subresource</code> must be encoded as
     *         <code>/~1resource~1subresource</code>.
     *         </p>
     *         <p>
     *         To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method
     *         settings to multiple methods.
     */
    public final String resourcePath() {
        return resourcePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(loggingLevel());
        hashCode = 31 * hashCode + Objects.hashCode(dataTraceEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingBurstLimit());
        hashCode = 31 * hashCode + Objects.hashCode(throttlingRateLimit());
        hashCode = 31 * hashCode + Objects.hashCode(cachingEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cacheTtlInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(cacheDataEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(requireAuthorizationForCacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(unauthorizedCacheControlHeaderStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(httpMethod());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiGatewayMethodSettings)) {
            return false;
        }
        AwsApiGatewayMethodSettings other = (AwsApiGatewayMethodSettings) obj;
        return Objects.equals(metricsEnabled(), other.metricsEnabled()) && Objects.equals(loggingLevel(), other.loggingLevel())
                && Objects.equals(dataTraceEnabled(), other.dataTraceEnabled())
                && Objects.equals(throttlingBurstLimit(), other.throttlingBurstLimit())
                && Objects.equals(throttlingRateLimit(), other.throttlingRateLimit())
                && Objects.equals(cachingEnabled(), other.cachingEnabled())
                && Objects.equals(cacheTtlInSeconds(), other.cacheTtlInSeconds())
                && Objects.equals(cacheDataEncrypted(), other.cacheDataEncrypted())
                && Objects.equals(requireAuthorizationForCacheControl(), other.requireAuthorizationForCacheControl())
                && Objects.equals(unauthorizedCacheControlHeaderStrategy(), other.unauthorizedCacheControlHeaderStrategy())
                && Objects.equals(httpMethod(), other.httpMethod()) && Objects.equals(resourcePath(), other.resourcePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsApiGatewayMethodSettings").add("MetricsEnabled", metricsEnabled())
                .add("LoggingLevel", loggingLevel()).add("DataTraceEnabled", dataTraceEnabled())
                .add("ThrottlingBurstLimit", throttlingBurstLimit()).add("ThrottlingRateLimit", throttlingRateLimit())
                .add("CachingEnabled", cachingEnabled()).add("CacheTtlInSeconds", cacheTtlInSeconds())
                .add("CacheDataEncrypted", cacheDataEncrypted())
                .add("RequireAuthorizationForCacheControl", requireAuthorizationForCacheControl())
                .add("UnauthorizedCacheControlHeaderStrategy", unauthorizedCacheControlHeaderStrategy())
                .add("HttpMethod", httpMethod()).add("ResourcePath", resourcePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricsEnabled":
            return Optional.ofNullable(clazz.cast(metricsEnabled()));
        case "LoggingLevel":
            return Optional.ofNullable(clazz.cast(loggingLevel()));
        case "DataTraceEnabled":
            return Optional.ofNullable(clazz.cast(dataTraceEnabled()));
        case "ThrottlingBurstLimit":
            return Optional.ofNullable(clazz.cast(throttlingBurstLimit()));
        case "ThrottlingRateLimit":
            return Optional.ofNullable(clazz.cast(throttlingRateLimit()));
        case "CachingEnabled":
            return Optional.ofNullable(clazz.cast(cachingEnabled()));
        case "CacheTtlInSeconds":
            return Optional.ofNullable(clazz.cast(cacheTtlInSeconds()));
        case "CacheDataEncrypted":
            return Optional.ofNullable(clazz.cast(cacheDataEncrypted()));
        case "RequireAuthorizationForCacheControl":
            return Optional.ofNullable(clazz.cast(requireAuthorizationForCacheControl()));
        case "UnauthorizedCacheControlHeaderStrategy":
            return Optional.ofNullable(clazz.cast(unauthorizedCacheControlHeaderStrategy()));
        case "HttpMethod":
            return Optional.ofNullable(clazz.cast(httpMethod()));
        case "ResourcePath":
            return Optional.ofNullable(clazz.cast(resourcePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiGatewayMethodSettings, T> g) {
        return obj -> g.apply((AwsApiGatewayMethodSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsApiGatewayMethodSettings> {
        /**
         * <p>
         * Indicates whether CloudWatch metrics are enabled for the method.
         * </p>
         * 
         * @param metricsEnabled
         *        Indicates whether CloudWatch metrics are enabled for the method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsEnabled(Boolean metricsEnabled);

        /**
         * <p>
         * The logging level for this method. The logging level affects the log entries that are pushed to CloudWatch
         * Logs.
         * </p>
         * <p>
         * If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
         * </p>
         * <p>
         * If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and extra
         * informational events.
         * </p>
         * <p>
         * Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
         * </p>
         * 
         * @param loggingLevel
         *        The logging level for this method. The logging level affects the log entries that are pushed to
         *        CloudWatch Logs.</p>
         *        <p>
         *        If the logging level is <code>ERROR</code>, then the logs only include error-level entries.
         *        </p>
         *        <p>
         *        If the logging level is <code>INFO</code>, then the logs include both <code>ERROR</code> events and
         *        extra informational events.
         *        </p>
         *        <p>
         *        Valid values: <code>OFF</code> | <code>ERROR</code> | <code>INFO</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingLevel(String loggingLevel);

        /**
         * <p>
         * Indicates whether data trace logging is enabled for the method. Data trace logging affects the log entries
         * that are pushed to CloudWatch Logs.
         * </p>
         * 
         * @param dataTraceEnabled
         *        Indicates whether data trace logging is enabled for the method. Data trace logging affects the log
         *        entries that are pushed to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataTraceEnabled(Boolean dataTraceEnabled);

        /**
         * <p>
         * The throttling burst limit for the method.
         * </p>
         * 
         * @param throttlingBurstLimit
         *        The throttling burst limit for the method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingBurstLimit(Integer throttlingBurstLimit);

        /**
         * <p>
         * The throttling rate limit for the method.
         * </p>
         * 
         * @param throttlingRateLimit
         *        The throttling rate limit for the method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throttlingRateLimit(Double throttlingRateLimit);

        /**
         * <p>
         * Indicates whether responses are cached and returned for requests. For responses to be cached, a cache cluster
         * must be enabled on the stage.
         * </p>
         * 
         * @param cachingEnabled
         *        Indicates whether responses are cached and returned for requests. For responses to be cached, a cache
         *        cluster must be enabled on the stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingEnabled(Boolean cachingEnabled);

        /**
         * <p>
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
         * response is cached.
         * </p>
         * 
         * @param cacheTtlInSeconds
         *        Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the
         *        response is cached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheTtlInSeconds(Integer cacheTtlInSeconds);

        /**
         * <p>
         * Indicates whether the cached responses are encrypted.
         * </p>
         * 
         * @param cacheDataEncrypted
         *        Indicates whether the cached responses are encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheDataEncrypted(Boolean cacheDataEncrypted);

        /**
         * <p>
         * Indicates whether authorization is required for a cache invalidation request.
         * </p>
         * 
         * @param requireAuthorizationForCacheControl
         *        Indicates whether authorization is required for a cache invalidation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl);

        /**
         * <p>
         * Indicates how to handle unauthorized requests for cache invalidation.
         * </p>
         * <p>
         * Valid values: <code>FAIL_WITH_403</code> | <code>SUCCEED_WITH_RESPONSE_HEADER</code> |
         * <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>
         * </p>
         * 
         * @param unauthorizedCacheControlHeaderStrategy
         *        Indicates how to handle unauthorized requests for cache invalidation.</p>
         *        <p>
         *        Valid values: <code>FAIL_WITH_403</code> | <code>SUCCEED_WITH_RESPONSE_HEADER</code> |
         *        <code>SUCCEED_WITHOUT_RESPONSE_HEADER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy);

        /**
         * <p>
         * The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple methods.
         * </p>
         * 
         * @param httpMethod
         *        The HTTP method. You can use an asterisk (*) as a wildcard to apply method settings to multiple
         *        methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpMethod(String httpMethod);

        /**
         * <p>
         * The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must include a
         * forward slash.
         * </p>
         * <p>
         * For example, the path value <code>/resource/subresource</code> must be encoded as
         * <code>/~1resource~1subresource</code>.
         * </p>
         * <p>
         * To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply method
         * settings to multiple methods.
         * </p>
         * 
         * @param resourcePath
         *        The resource path for this method. Forward slashes (/) are encoded as ~1 . The initial slash must
         *        include a forward slash.</p>
         *        <p>
         *        For example, the path value <code>/resource/subresource</code> must be encoded as
         *        <code>/~1resource~1subresource</code>.
         *        </p>
         *        <p>
         *        To specify the root path, use only a slash (/). You can use an asterisk (*) as a wildcard to apply
         *        method settings to multiple methods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePath(String resourcePath);
    }

    static final class BuilderImpl implements Builder {
        private Boolean metricsEnabled;

        private String loggingLevel;

        private Boolean dataTraceEnabled;

        private Integer throttlingBurstLimit;

        private Double throttlingRateLimit;

        private Boolean cachingEnabled;

        private Integer cacheTtlInSeconds;

        private Boolean cacheDataEncrypted;

        private Boolean requireAuthorizationForCacheControl;

        private String unauthorizedCacheControlHeaderStrategy;

        private String httpMethod;

        private String resourcePath;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiGatewayMethodSettings model) {
            metricsEnabled(model.metricsEnabled);
            loggingLevel(model.loggingLevel);
            dataTraceEnabled(model.dataTraceEnabled);
            throttlingBurstLimit(model.throttlingBurstLimit);
            throttlingRateLimit(model.throttlingRateLimit);
            cachingEnabled(model.cachingEnabled);
            cacheTtlInSeconds(model.cacheTtlInSeconds);
            cacheDataEncrypted(model.cacheDataEncrypted);
            requireAuthorizationForCacheControl(model.requireAuthorizationForCacheControl);
            unauthorizedCacheControlHeaderStrategy(model.unauthorizedCacheControlHeaderStrategy);
            httpMethod(model.httpMethod);
            resourcePath(model.resourcePath);
        }

        public final Boolean getMetricsEnabled() {
            return metricsEnabled;
        }

        public final void setMetricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
        }

        @Override
        @Transient
        public final Builder metricsEnabled(Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        public final String getLoggingLevel() {
            return loggingLevel;
        }

        public final void setLoggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
        }

        @Override
        @Transient
        public final Builder loggingLevel(String loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public final Boolean getDataTraceEnabled() {
            return dataTraceEnabled;
        }

        public final void setDataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
        }

        @Override
        @Transient
        public final Builder dataTraceEnabled(Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        public final Integer getThrottlingBurstLimit() {
            return throttlingBurstLimit;
        }

        public final void setThrottlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
        }

        @Override
        @Transient
        public final Builder throttlingBurstLimit(Integer throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        public final Double getThrottlingRateLimit() {
            return throttlingRateLimit;
        }

        public final void setThrottlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        @Transient
        public final Builder throttlingRateLimit(Double throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        public final Boolean getCachingEnabled() {
            return cachingEnabled;
        }

        public final void setCachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
        }

        @Override
        @Transient
        public final Builder cachingEnabled(Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        public final Integer getCacheTtlInSeconds() {
            return cacheTtlInSeconds;
        }

        public final void setCacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
        }

        @Override
        @Transient
        public final Builder cacheTtlInSeconds(Integer cacheTtlInSeconds) {
            this.cacheTtlInSeconds = cacheTtlInSeconds;
            return this;
        }

        public final Boolean getCacheDataEncrypted() {
            return cacheDataEncrypted;
        }

        public final void setCacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
        }

        @Override
        @Transient
        public final Builder cacheDataEncrypted(Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        public final Boolean getRequireAuthorizationForCacheControl() {
            return requireAuthorizationForCacheControl;
        }

        public final void setRequireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
        }

        @Override
        @Transient
        public final Builder requireAuthorizationForCacheControl(Boolean requireAuthorizationForCacheControl) {
            this.requireAuthorizationForCacheControl = requireAuthorizationForCacheControl;
            return this;
        }

        public final String getUnauthorizedCacheControlHeaderStrategy() {
            return unauthorizedCacheControlHeaderStrategy;
        }

        public final void setUnauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
        }

        @Override
        @Transient
        public final Builder unauthorizedCacheControlHeaderStrategy(String unauthorizedCacheControlHeaderStrategy) {
            this.unauthorizedCacheControlHeaderStrategy = unauthorizedCacheControlHeaderStrategy;
            return this;
        }

        public final String getHttpMethod() {
            return httpMethod;
        }

        public final void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        @Override
        @Transient
        public final Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public final String getResourcePath() {
            return resourcePath;
        }

        public final void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Override
        @Transient
        public final Builder resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        @Override
        public AwsApiGatewayMethodSettings build() {
            return new AwsApiGatewayMethodSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
