/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template and overrides for a mixed instances policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails.Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails> {
    private static final SdkField<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification> builder(
                    MarshallingType.SDK_POJO)
            .memberName("LaunchTemplateSpecification")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails::launchTemplateSpecification))
            .setter(setter(Builder::launchTemplateSpecification))
            .constructor(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification")
                    .build()).build();

    private static final SdkField<List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>> OVERRIDES_FIELD = SdkField
            .<List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>> builder(
                    MarshallingType.LIST)
            .memberName("Overrides")
            .getter(getter(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails::overrides))
            .setter(setter(Builder::overrides))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification launchTemplateSpecification;

    private final List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> overrides;

    private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    /**
     * <p>
     * The launch template to use.
     * </p>
     * 
     * @return The launch template to use.
     */
    public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification launchTemplateSpecification() {
        return launchTemplateSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the Overrides property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOverrides() {
        return overrides != null && !(overrides instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Property values to use to override the values in the launch template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOverrides} method.
     * </p>
     * 
     * @return Property values to use to override the values in the launch template.
     */
    public final List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> overrides() {
        return overrides;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasOverrides() ? overrides() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails other = (AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) obj;
        return Objects.equals(launchTemplateSpecification(), other.launchTemplateSpecification())
                && hasOverrides() == other.hasOverrides() && Objects.equals(overrides(), other.overrides());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails")
                .add("LaunchTemplateSpecification", launchTemplateSpecification())
                .add("Overrides", hasOverrides() ? overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateSpecification":
            return Optional.ofNullable(clazz.cast(launchTemplateSpecification()));
        case "Overrides":
            return Optional.ofNullable(clazz.cast(overrides()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails> {
        /**
         * <p>
         * The launch template to use.
         * </p>
         * 
         * @param launchTemplateSpecification
         *        The launch template to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateSpecification(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification launchTemplateSpecification);

        /**
         * <p>
         * The launch template to use.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Builder}
         * avoiding the need to create one manually via
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification#builder()}
         * .
         *
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #launchTemplateSpecification(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification)}
         * .
         * 
         * @param launchTemplateSpecification
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateSpecification(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification)
         */
        default Builder launchTemplateSpecification(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return launchTemplateSpecification(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification
                    .builder().applyMutation(launchTemplateSpecification).build());
        }

        /**
         * <p>
         * Property values to use to override the values in the launch template.
         * </p>
         * 
         * @param overrides
         *        Property values to use to override the values in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(
                Collection<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> overrides);

        /**
         * <p>
         * Property values to use to override the values in the launch template.
         * </p>
         * 
         * @param overrides
         *        Property values to use to override the values in the launch template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrides(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails... overrides);

        /**
         * <p>
         * Property values to use to override the values in the launch template.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>.Builder} avoiding the
         * need to create one manually via {@link List
         * <AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #overrides(List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>)}.
         * 
         * @param overrides
         *        a consumer that will call methods on {@link List
         *        <AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrides(List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails>)
         */
        Builder overrides(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.Builder>... overrides);
    }

    static final class BuilderImpl implements Builder {
        private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification launchTemplateSpecification;

        private List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> overrides = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails model) {
            launchTemplateSpecification(model.launchTemplateSpecification);
            overrides(model.overrides);
        }

        public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return launchTemplateSpecification != null ? launchTemplateSpecification.toBuilder() : null;
        }

        public final void setLaunchTemplateSpecification(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder launchTemplateSpecification(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.Builder> getOverrides() {
            List<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.Builder> result = AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListCopier
                    .copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(
                Collection<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.BuilderImpl> overrides) {
            this.overrides = AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListCopier
                    .copyFromBuilder(overrides);
        }

        @Override
        @Transient
        public final Builder overrides(
                Collection<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails> overrides) {
            this.overrides = AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListCopier.copy(overrides);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails... overrides) {
            overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder overrides(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.Builder>... overrides) {
            overrides(Stream
                    .of(overrides)
                    .map(c -> AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateOverridesListDetails.builder()
                            .applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails build() {
            return new AwsAutoScalingAutoScalingGroupMixedInstancesPolicyLaunchTemplateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
