/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an extended key usage X.509 v3 extension object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCertificateManagerCertificateExtendedKeyUsage
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsCertificateManagerCertificateExtendedKeyUsage.Builder, AwsCertificateManagerCertificateExtendedKeyUsage> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsCertificateManagerCertificateExtendedKeyUsage::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> O_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("OId")
            .getter(getter(AwsCertificateManagerCertificateExtendedKeyUsage::oId)).setter(setter(Builder::oId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, O_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String oId;

    private AwsCertificateManagerCertificateExtendedKeyUsage(BuilderImpl builder) {
        this.name = builder.name;
        this.oId = builder.oId;
    }

    /**
     * <p>
     * The name of an extension value. Indicates the purpose for which the certificate public key can be used.
     * </p>
     * 
     * @return The name of an extension value. Indicates the purpose for which the certificate public key can be used.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An object identifier (OID) for the extension value.
     * </p>
     * <p>
     * The format is numbers separated by periods.
     * </p>
     * 
     * @return An object identifier (OID) for the extension value.</p>
     *         <p>
     *         The format is numbers separated by periods.
     */
    public final String oId() {
        return oId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(oId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateExtendedKeyUsage)) {
            return false;
        }
        AwsCertificateManagerCertificateExtendedKeyUsage other = (AwsCertificateManagerCertificateExtendedKeyUsage) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(oId(), other.oId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCertificateManagerCertificateExtendedKeyUsage").add("Name", name()).add("OId", oId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OId":
            return Optional.ofNullable(clazz.cast(oId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateExtendedKeyUsage, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateExtendedKeyUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCertificateManagerCertificateExtendedKeyUsage> {
        /**
         * <p>
         * The name of an extension value. Indicates the purpose for which the certificate public key can be used.
         * </p>
         * 
         * @param name
         *        The name of an extension value. Indicates the purpose for which the certificate public key can be
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An object identifier (OID) for the extension value.
         * </p>
         * <p>
         * The format is numbers separated by periods.
         * </p>
         * 
         * @param oId
         *        An object identifier (OID) for the extension value.</p>
         *        <p>
         *        The format is numbers separated by periods.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder oId(String oId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String oId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateExtendedKeyUsage model) {
            name(model.name);
            oId(model.oId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOId() {
            return oId;
        }

        public final void setOId(String oId) {
            this.oId = oId;
        }

        @Override
        @Transient
        public final Builder oId(String oId) {
            this.oId = oId;
            return this;
        }

        @Override
        public AwsCertificateManagerCertificateExtendedKeyUsage build() {
            return new AwsCertificateManagerCertificateExtendedKeyUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
