/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Certificate Manager managed renewal for an <code>AMAZON_ISSUED</code> certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCertificateManagerCertificateRenewalSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCertificateManagerCertificateRenewalSummary.Builder, AwsCertificateManagerCertificateRenewalSummary> {
    private static final SdkField<List<AwsCertificateManagerCertificateDomainValidationOption>> DOMAIN_VALIDATION_OPTIONS_FIELD = SdkField
            .<List<AwsCertificateManagerCertificateDomainValidationOption>> builder(MarshallingType.LIST)
            .memberName("DomainValidationOptions")
            .getter(getter(AwsCertificateManagerCertificateRenewalSummary::domainValidationOptions))
            .setter(setter(Builder::domainValidationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainValidationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCertificateManagerCertificateDomainValidationOption> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsCertificateManagerCertificateDomainValidationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RENEWAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenewalStatus").getter(getter(AwsCertificateManagerCertificateRenewalSummary::renewalStatus))
            .setter(setter(Builder::renewalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatus").build()).build();

    private static final SdkField<String> RENEWAL_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RenewalStatusReason")
            .getter(getter(AwsCertificateManagerCertificateRenewalSummary::renewalStatusReason))
            .setter(setter(Builder::renewalStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenewalStatusReason").build())
            .build();

    private static final SdkField<String> UPDATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdatedAt").getter(getter(AwsCertificateManagerCertificateRenewalSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DOMAIN_VALIDATION_OPTIONS_FIELD, RENEWAL_STATUS_FIELD, RENEWAL_STATUS_REASON_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions;

    private final String renewalStatus;

    private final String renewalStatusReason;

    private final String updatedAt;

    private AwsCertificateManagerCertificateRenewalSummary(BuilderImpl builder) {
        this.domainValidationOptions = builder.domainValidationOptions;
        this.renewalStatus = builder.renewalStatus;
        this.renewalStatusReason = builder.renewalStatusReason;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainValidationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainValidationOptions() {
        return domainValidationOptions != null && !(domainValidationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the validation of each domain name in the certificate, as it pertains to Certificate Manager
     * managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainValidationOptions} method.
     * </p>
     * 
     * @return Information about the validation of each domain name in the certificate, as it pertains to Certificate
     *         Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
     */
    public final List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions() {
        return domainValidationOptions;
    }

    /**
     * <p>
     * The status of the Certificate Manager managed renewal of the certificate.
     * </p>
     * <p>
     * Valid values: <code>PENDING_AUTO_RENEWAL</code> | <code>PENDING_VALIDATION</code> | <code>SUCCESS</code> |
     * <code>FAILED</code>
     * </p>
     * 
     * @return The status of the Certificate Manager managed renewal of the certificate.</p>
     *         <p>
     *         Valid values: <code>PENDING_AUTO_RENEWAL</code> | <code>PENDING_VALIDATION</code> | <code>SUCCESS</code>
     *         | <code>FAILED</code>
     */
    public final String renewalStatus() {
        return renewalStatus;
    }

    /**
     * <p>
     * The reason that a renewal request was unsuccessful.
     * </p>
     * <p>
     * Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
     * <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code> |
     * <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> |
     * <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> | <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> |
     * <code>PCA_RESOURCE_NOT_FOUND</code> | <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> |
     * <code>PCA_ACCESS_DENIED</code> | <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
     * </p>
     * 
     * @return The reason that a renewal request was unsuccessful.</p>
     *         <p>
     *         Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
     *         <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> |
     *         <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> |
     *         <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
     *         <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
     *         <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
     *         <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
     */
    public final String renewalStatusReason() {
        return renewalStatusReason;
    }

    /**
     * <p>
     * Indicates when the renewal summary was last updated.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the renewal summary was last updated.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainValidationOptions() ? domainValidationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatus());
        hashCode = 31 * hashCode + Objects.hashCode(renewalStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateRenewalSummary)) {
            return false;
        }
        AwsCertificateManagerCertificateRenewalSummary other = (AwsCertificateManagerCertificateRenewalSummary) obj;
        return hasDomainValidationOptions() == other.hasDomainValidationOptions()
                && Objects.equals(domainValidationOptions(), other.domainValidationOptions())
                && Objects.equals(renewalStatus(), other.renewalStatus())
                && Objects.equals(renewalStatusReason(), other.renewalStatusReason())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCertificateManagerCertificateRenewalSummary")
                .add("DomainValidationOptions", hasDomainValidationOptions() ? domainValidationOptions() : null)
                .add("RenewalStatus", renewalStatus()).add("RenewalStatusReason", renewalStatusReason())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainValidationOptions":
            return Optional.ofNullable(clazz.cast(domainValidationOptions()));
        case "RenewalStatus":
            return Optional.ofNullable(clazz.cast(renewalStatus()));
        case "RenewalStatusReason":
            return Optional.ofNullable(clazz.cast(renewalStatusReason()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateRenewalSummary, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateRenewalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCertificateManagerCertificateRenewalSummary> {
        /**
         * <p>
         * Information about the validation of each domain name in the certificate, as it pertains to Certificate
         * Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * 
         * @param domainValidationOptions
         *        Information about the validation of each domain name in the certificate, as it pertains to Certificate
         *        Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions);

        /**
         * <p>
         * Information about the validation of each domain name in the certificate, as it pertains to Certificate
         * Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * 
         * @param domainValidationOptions
         *        Information about the validation of each domain name in the certificate, as it pertains to Certificate
         *        Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainValidationOptions(AwsCertificateManagerCertificateDomainValidationOption... domainValidationOptions);

        /**
         * <p>
         * Information about the validation of each domain name in the certificate, as it pertains to Certificate
         * Manager managed renewal. Provided only when the certificate type is <code>AMAZON_ISSUED</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsCertificateManagerCertificateDomainValidationOption>.Builder} avoiding the need to create one manually
         * via {@link List<AwsCertificateManagerCertificateDomainValidationOption>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsCertificateManagerCertificateDomainValidationOption>.Builder#build()} is called immediately and its
         * result is passed to {@link
         * #domainValidationOptions(List<AwsCertificateManagerCertificateDomainValidationOption>)}.
         * 
         * @param domainValidationOptions
         *        a consumer that will call methods on {@link List
         *        <AwsCertificateManagerCertificateDomainValidationOption>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainValidationOptions(List<AwsCertificateManagerCertificateDomainValidationOption>)
         */
        Builder domainValidationOptions(
                Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder>... domainValidationOptions);

        /**
         * <p>
         * The status of the Certificate Manager managed renewal of the certificate.
         * </p>
         * <p>
         * Valid values: <code>PENDING_AUTO_RENEWAL</code> | <code>PENDING_VALIDATION</code> | <code>SUCCESS</code> |
         * <code>FAILED</code>
         * </p>
         * 
         * @param renewalStatus
         *        The status of the Certificate Manager managed renewal of the certificate.</p>
         *        <p>
         *        Valid values: <code>PENDING_AUTO_RENEWAL</code> | <code>PENDING_VALIDATION</code> |
         *        <code>SUCCESS</code> | <code>FAILED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalStatus(String renewalStatus);

        /**
         * <p>
         * The reason that a renewal request was unsuccessful.
         * </p>
         * <p>
         * Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
         * <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> | <code>DOMAIN_VALIDATION_DENIED</code>
         * | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> | <code>PCA_INVALID_ARN</code> |
         * <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
         * <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
         * <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
         * <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
         * </p>
         * 
         * @param renewalStatusReason
         *        The reason that a renewal request was unsuccessful.</p>
         *        <p>
         *        Valid values: <code>NO_AVAILABLE_CONTACTS</code> | <code>ADDITIONAL_VERIFICATION_REQUIRED</code> |
         *        <code>DOMAIN_NOT_ALLOWED</code> | <code>INVALID_PUBLIC_DOMAIN</code> |
         *        <code>DOMAIN_VALIDATION_DENIED</code> | <code>CAA_ERROR</code> | <code>PCA_LIMIT_EXCEEDED</code> |
         *        <code>PCA_INVALID_ARN</code> | <code>PCA_INVALID_STATE</code> | <code>PCA_REQUEST_FAILED</code> |
         *        <code>PCA_NAME_CONSTRAINTS_VALIDATION</code> | <code>PCA_RESOURCE_NOT_FOUND</code> |
         *        <code>PCA_INVALID_ARGS</code> | <code>PCA_INVALID_DURATION</code> | <code>PCA_ACCESS_DENIED</code> |
         *        <code>SLR_NOT_FOUND</code> | <code>OTHER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renewalStatusReason(String renewalStatusReason);

        /**
         * <p>
         * Indicates when the renewal summary was last updated.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param updatedAt
         *        Indicates when the renewal summary was last updated.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(String updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private String renewalStatus;

        private String renewalStatusReason;

        private String updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateRenewalSummary model) {
            domainValidationOptions(model.domainValidationOptions);
            renewalStatus(model.renewalStatus);
            renewalStatusReason(model.renewalStatusReason);
            updatedAt(model.updatedAt);
        }

        public final List<AwsCertificateManagerCertificateDomainValidationOption.Builder> getDomainValidationOptions() {
            List<AwsCertificateManagerCertificateDomainValidationOption.Builder> result = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copyToBuilder(this.domainValidationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainValidationOptions(
                Collection<AwsCertificateManagerCertificateDomainValidationOption.BuilderImpl> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copyFromBuilder(domainValidationOptions);
        }

        @Override
        @Transient
        public final Builder domainValidationOptions(
                Collection<AwsCertificateManagerCertificateDomainValidationOption> domainValidationOptions) {
            this.domainValidationOptions = AwsCertificateManagerCertificateDomainValidationOptionsCopier
                    .copy(domainValidationOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(
                AwsCertificateManagerCertificateDomainValidationOption... domainValidationOptions) {
            domainValidationOptions(Arrays.asList(domainValidationOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder domainValidationOptions(
                Consumer<AwsCertificateManagerCertificateDomainValidationOption.Builder>... domainValidationOptions) {
            domainValidationOptions(Stream.of(domainValidationOptions)
                    .map(c -> AwsCertificateManagerCertificateDomainValidationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRenewalStatus() {
            return renewalStatus;
        }

        public final void setRenewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
        }

        @Override
        @Transient
        public final Builder renewalStatus(String renewalStatus) {
            this.renewalStatus = renewalStatus;
            return this;
        }

        public final String getRenewalStatusReason() {
            return renewalStatusReason;
        }

        public final void setRenewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
        }

        @Override
        @Transient
        public final Builder renewalStatusReason(String renewalStatusReason) {
            this.renewalStatusReason = renewalStatusReason;
            return this;
        }

        public final String getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public AwsCertificateManagerCertificateRenewalSummary build() {
            return new AwsCertificateManagerCertificateRenewalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
