/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an origin group for the distribution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginGroup.Builder, AwsCloudFrontDistributionOriginGroup> {
    private static final SdkField<AwsCloudFrontDistributionOriginGroupFailover> FAILOVER_CRITERIA_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginGroupFailover> builder(MarshallingType.SDK_POJO).memberName("FailoverCriteria")
            .getter(getter(AwsCloudFrontDistributionOriginGroup::failoverCriteria)).setter(setter(Builder::failoverCriteria))
            .constructor(AwsCloudFrontDistributionOriginGroupFailover::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILOVER_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCloudFrontDistributionOriginGroupFailover failoverCriteria;

    private AwsCloudFrontDistributionOriginGroup(BuilderImpl builder) {
        this.failoverCriteria = builder.failoverCriteria;
    }

    /**
     * <p>
     * Provides the criteria for an origin group to fail over.
     * </p>
     * 
     * @return Provides the criteria for an origin group to fail over.
     */
    public final AwsCloudFrontDistributionOriginGroupFailover failoverCriteria() {
        return failoverCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failoverCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginGroup)) {
            return false;
        }
        AwsCloudFrontDistributionOriginGroup other = (AwsCloudFrontDistributionOriginGroup) obj;
        return Objects.equals(failoverCriteria(), other.failoverCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginGroup").add("FailoverCriteria", failoverCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailoverCriteria":
            return Optional.ofNullable(clazz.cast(failoverCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginGroup, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroup> {
        /**
         * <p>
         * Provides the criteria for an origin group to fail over.
         * </p>
         * 
         * @param failoverCriteria
         *        Provides the criteria for an origin group to fail over.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failoverCriteria(AwsCloudFrontDistributionOriginGroupFailover failoverCriteria);

        /**
         * <p>
         * Provides the criteria for an origin group to fail over.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginGroupFailover.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionOriginGroupFailover#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOriginGroupFailover.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #failoverCriteria(AwsCloudFrontDistributionOriginGroupFailover)}.
         * 
         * @param failoverCriteria
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOriginGroupFailover.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failoverCriteria(AwsCloudFrontDistributionOriginGroupFailover)
         */
        default Builder failoverCriteria(Consumer<AwsCloudFrontDistributionOriginGroupFailover.Builder> failoverCriteria) {
            return failoverCriteria(AwsCloudFrontDistributionOriginGroupFailover.builder().applyMutation(failoverCriteria)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudFrontDistributionOriginGroupFailover failoverCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginGroup model) {
            failoverCriteria(model.failoverCriteria);
        }

        public final AwsCloudFrontDistributionOriginGroupFailover.Builder getFailoverCriteria() {
            return failoverCriteria != null ? failoverCriteria.toBuilder() : null;
        }

        public final void setFailoverCriteria(AwsCloudFrontDistributionOriginGroupFailover.BuilderImpl failoverCriteria) {
            this.failoverCriteria = failoverCriteria != null ? failoverCriteria.build() : null;
        }

        @Override
        @Transient
        public final Builder failoverCriteria(AwsCloudFrontDistributionOriginGroupFailover failoverCriteria) {
            this.failoverCriteria = failoverCriteria;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginGroup build() {
            return new AwsCloudFrontDistributionOriginGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
