/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about when an origin group fails over.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginGroupFailover implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginGroupFailover.Builder, AwsCloudFrontDistributionOriginGroupFailover> {
    private static final SdkField<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> STATUS_CODES_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes> builder(MarshallingType.SDK_POJO)
            .memberName("StatusCodes").getter(getter(AwsCloudFrontDistributionOriginGroupFailover::statusCodes))
            .setter(setter(Builder::statusCodes)).constructor(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCodes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODES_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsCloudFrontDistributionOriginGroupFailoverStatusCodes statusCodes;

    private AwsCloudFrontDistributionOriginGroupFailover(BuilderImpl builder) {
        this.statusCodes = builder.statusCodes;
    }

    /**
     * <p>
     * Information about the status codes that cause an origin group to fail over.
     * </p>
     * 
     * @return Information about the status codes that cause an origin group to fail over.
     */
    public final AwsCloudFrontDistributionOriginGroupFailoverStatusCodes statusCodes() {
        return statusCodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusCodes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginGroupFailover)) {
            return false;
        }
        AwsCloudFrontDistributionOriginGroupFailover other = (AwsCloudFrontDistributionOriginGroupFailover) obj;
        return Objects.equals(statusCodes(), other.statusCodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginGroupFailover").add("StatusCodes", statusCodes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatusCodes":
            return Optional.ofNullable(clazz.cast(statusCodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginGroupFailover, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginGroupFailover) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginGroupFailover> {
        /**
         * <p>
         * Information about the status codes that cause an origin group to fail over.
         * </p>
         * 
         * @param statusCodes
         *        Information about the status codes that cause an origin group to fail over.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes statusCodes);

        /**
         * <p>
         * Information about the status codes that cause an origin group to fail over.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder} avoiding the need to create one
         * manually via {@link AwsCloudFrontDistributionOriginGroupFailoverStatusCodes#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder#build()} is called immediately and its
         * result is passed to {@link #statusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)}.
         * 
         * @param statusCodes
         *        a consumer that will call methods on
         *        {@link AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes)
         */
        default Builder statusCodes(Consumer<AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder> statusCodes) {
            return statusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.builder().applyMutation(statusCodes)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudFrontDistributionOriginGroupFailoverStatusCodes statusCodes;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginGroupFailover model) {
            statusCodes(model.statusCodes);
        }

        public final AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.Builder getStatusCodes() {
            return statusCodes != null ? statusCodes.toBuilder() : null;
        }

        public final void setStatusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes.BuilderImpl statusCodes) {
            this.statusCodes = statusCodes != null ? statusCodes.build() : null;
        }

        @Override
        @Transient
        public final Builder statusCodes(AwsCloudFrontDistributionOriginGroupFailoverStatusCodes statusCodes) {
            this.statusCodes = statusCodes;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginGroupFailover build() {
            return new AwsCloudFrontDistributionOriginGroupFailover(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
