/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a DynamoDB table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableDetails.Builder, AwsDynamoDbTableDetails> {
    private static final SdkField<List<AwsDynamoDbTableAttributeDefinition>> ATTRIBUTE_DEFINITIONS_FIELD = SdkField
            .<List<AwsDynamoDbTableAttributeDefinition>> builder(MarshallingType.LIST)
            .memberName("AttributeDefinitions")
            .getter(getter(AwsDynamoDbTableDetails::attributeDefinitions))
            .setter(setter(Builder::attributeDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableAttributeDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableAttributeDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsDynamoDbTableBillingModeSummary> BILLING_MODE_SUMMARY_FIELD = SdkField
            .<AwsDynamoDbTableBillingModeSummary> builder(MarshallingType.SDK_POJO).memberName("BillingModeSummary")
            .getter(getter(AwsDynamoDbTableDetails::billingModeSummary)).setter(setter(Builder::billingModeSummary))
            .constructor(AwsDynamoDbTableBillingModeSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeSummary").build())
            .build();

    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreationDateTime").getter(getter(AwsDynamoDbTableDetails::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<List<AwsDynamoDbTableGlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<AwsDynamoDbTableGlobalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("GlobalSecondaryIndexes")
            .getter(getter(AwsDynamoDbTableDetails::globalSecondaryIndexes))
            .setter(setter(Builder::globalSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableGlobalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableGlobalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GLOBAL_TABLE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GlobalTableVersion").getter(getter(AwsDynamoDbTableDetails::globalTableVersion))
            .setter(setter(Builder::globalTableVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableVersion").build())
            .build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ItemCount").getter(getter(AwsDynamoDbTableDetails::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<List<AwsDynamoDbTableKeySchema>> KEY_SCHEMA_FIELD = SdkField
            .<List<AwsDynamoDbTableKeySchema>> builder(MarshallingType.LIST)
            .memberName("KeySchema")
            .getter(getter(AwsDynamoDbTableDetails::keySchema))
            .setter(setter(Builder::keySchema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySchema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableKeySchema> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableKeySchema::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LATEST_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestStreamArn").getter(getter(AwsDynamoDbTableDetails::latestStreamArn))
            .setter(setter(Builder::latestStreamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamArn").build()).build();

    private static final SdkField<String> LATEST_STREAM_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestStreamLabel").getter(getter(AwsDynamoDbTableDetails::latestStreamLabel))
            .setter(setter(Builder::latestStreamLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestStreamLabel").build()).build();

    private static final SdkField<List<AwsDynamoDbTableLocalSecondaryIndex>> LOCAL_SECONDARY_INDEXES_FIELD = SdkField
            .<List<AwsDynamoDbTableLocalSecondaryIndex>> builder(MarshallingType.LIST)
            .memberName("LocalSecondaryIndexes")
            .getter(getter(AwsDynamoDbTableDetails::localSecondaryIndexes))
            .setter(setter(Builder::localSecondaryIndexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableLocalSecondaryIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableLocalSecondaryIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsDynamoDbTableProvisionedThroughput> PROVISIONED_THROUGHPUT_FIELD = SdkField
            .<AwsDynamoDbTableProvisionedThroughput> builder(MarshallingType.SDK_POJO).memberName("ProvisionedThroughput")
            .getter(getter(AwsDynamoDbTableDetails::provisionedThroughput)).setter(setter(Builder::provisionedThroughput))
            .constructor(AwsDynamoDbTableProvisionedThroughput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughput").build())
            .build();

    private static final SdkField<List<AwsDynamoDbTableReplica>> REPLICAS_FIELD = SdkField
            .<List<AwsDynamoDbTableReplica>> builder(MarshallingType.LIST)
            .memberName("Replicas")
            .getter(getter(AwsDynamoDbTableDetails::replicas))
            .setter(setter(Builder::replicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Replicas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDynamoDbTableReplica> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDynamoDbTableReplica::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsDynamoDbTableRestoreSummary> RESTORE_SUMMARY_FIELD = SdkField
            .<AwsDynamoDbTableRestoreSummary> builder(MarshallingType.SDK_POJO).memberName("RestoreSummary")
            .getter(getter(AwsDynamoDbTableDetails::restoreSummary)).setter(setter(Builder::restoreSummary))
            .constructor(AwsDynamoDbTableRestoreSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreSummary").build()).build();

    private static final SdkField<AwsDynamoDbTableSseDescription> SSE_DESCRIPTION_FIELD = SdkField
            .<AwsDynamoDbTableSseDescription> builder(MarshallingType.SDK_POJO).memberName("SseDescription")
            .getter(getter(AwsDynamoDbTableDetails::sseDescription)).setter(setter(Builder::sseDescription))
            .constructor(AwsDynamoDbTableSseDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SseDescription").build()).build();

    private static final SdkField<AwsDynamoDbTableStreamSpecification> STREAM_SPECIFICATION_FIELD = SdkField
            .<AwsDynamoDbTableStreamSpecification> builder(MarshallingType.SDK_POJO).memberName("StreamSpecification")
            .getter(getter(AwsDynamoDbTableDetails::streamSpecification)).setter(setter(Builder::streamSpecification))
            .constructor(AwsDynamoDbTableStreamSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamSpecification").build())
            .build();

    private static final SdkField<String> TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableId").getter(getter(AwsDynamoDbTableDetails::tableId)).setter(setter(Builder::tableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableId").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(AwsDynamoDbTableDetails::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Long> TABLE_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TableSizeBytes").getter(getter(AwsDynamoDbTableDetails::tableSizeBytes))
            .setter(setter(Builder::tableSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableSizeBytes").build()).build();

    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableStatus").getter(getter(AwsDynamoDbTableDetails::tableStatus)).setter(setter(Builder::tableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_DEFINITIONS_FIELD,
            BILLING_MODE_SUMMARY_FIELD, CREATION_DATE_TIME_FIELD, GLOBAL_SECONDARY_INDEXES_FIELD, GLOBAL_TABLE_VERSION_FIELD,
            ITEM_COUNT_FIELD, KEY_SCHEMA_FIELD, LATEST_STREAM_ARN_FIELD, LATEST_STREAM_LABEL_FIELD,
            LOCAL_SECONDARY_INDEXES_FIELD, PROVISIONED_THROUGHPUT_FIELD, REPLICAS_FIELD, RESTORE_SUMMARY_FIELD,
            SSE_DESCRIPTION_FIELD, STREAM_SPECIFICATION_FIELD, TABLE_ID_FIELD, TABLE_NAME_FIELD, TABLE_SIZE_BYTES_FIELD,
            TABLE_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions;

    private final AwsDynamoDbTableBillingModeSummary billingModeSummary;

    private final String creationDateTime;

    private final List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes;

    private final String globalTableVersion;

    private final Integer itemCount;

    private final List<AwsDynamoDbTableKeySchema> keySchema;

    private final String latestStreamArn;

    private final String latestStreamLabel;

    private final List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes;

    private final AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

    private final List<AwsDynamoDbTableReplica> replicas;

    private final AwsDynamoDbTableRestoreSummary restoreSummary;

    private final AwsDynamoDbTableSseDescription sseDescription;

    private final AwsDynamoDbTableStreamSpecification streamSpecification;

    private final String tableId;

    private final String tableName;

    private final Long tableSizeBytes;

    private final String tableStatus;

    private AwsDynamoDbTableDetails(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.billingModeSummary = builder.billingModeSummary;
        this.creationDateTime = builder.creationDateTime;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.globalTableVersion = builder.globalTableVersion;
        this.itemCount = builder.itemCount;
        this.keySchema = builder.keySchema;
        this.latestStreamArn = builder.latestStreamArn;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.replicas = builder.replicas;
        this.restoreSummary = builder.restoreSummary;
        this.sseDescription = builder.sseDescription;
        this.streamSpecification = builder.streamSpecification;
        this.tableId = builder.tableId;
        this.tableName = builder.tableName;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.tableStatus = builder.tableStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeDefinitions() {
        return attributeDefinitions != null && !(attributeDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of attribute definitions for the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeDefinitions} method.
     * </p>
     * 
     * @return A list of attribute definitions for the table.
     */
    public final List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions() {
        return attributeDefinitions;
    }

    /**
     * <p>
     * Information about the billing for read/write capacity on the table.
     * </p>
     * 
     * @return Information about the billing for read/write capacity on the table.
     */
    public final AwsDynamoDbTableBillingModeSummary billingModeSummary() {
        return billingModeSummary;
    }

    /**
     * <p>
     * Indicates when the table was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the table was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String creationDateTime() {
        return creationDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGlobalSecondaryIndexes() {
        return globalSecondaryIndexes != null && !(globalSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of global secondary indexes for the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalSecondaryIndexes} method.
     * </p>
     * 
     * @return List of global secondary indexes for the table.
     */
    public final List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes() {
        return globalSecondaryIndexes;
    }

    /**
     * <p>
     * The version of global tables being used.
     * </p>
     * 
     * @return The version of global tables being used.
     */
    public final String globalTableVersion() {
        return globalTableVersion;
    }

    /**
     * <p>
     * The number of items in the table.
     * </p>
     * 
     * @return The number of items in the table.
     */
    public final Integer itemCount() {
        return itemCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the KeySchema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasKeySchema() {
        return keySchema != null && !(keySchema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The primary key structure for the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeySchema} method.
     * </p>
     * 
     * @return The primary key structure for the table.
     */
    public final List<AwsDynamoDbTableKeySchema> keySchema() {
        return keySchema;
    }

    /**
     * <p>
     * The ARN of the latest stream for the table.
     * </p>
     * 
     * @return The ARN of the latest stream for the table.
     */
    public final String latestStreamArn() {
        return latestStreamArn;
    }

    /**
     * <p>
     * The label of the latest stream. The label is not a unique identifier.
     * </p>
     * 
     * @return The label of the latest stream. The label is not a unique identifier.
     */
    public final String latestStreamLabel() {
        return latestStreamLabel;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalSecondaryIndexes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLocalSecondaryIndexes() {
        return localSecondaryIndexes != null && !(localSecondaryIndexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of local secondary indexes for the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalSecondaryIndexes} method.
     * </p>
     * 
     * @return The list of local secondary indexes for the table.
     */
    public final List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes() {
        return localSecondaryIndexes;
    }

    /**
     * <p>
     * Information about the provisioned throughput for the table.
     * </p>
     * 
     * @return Information about the provisioned throughput for the table.
     */
    public final AwsDynamoDbTableProvisionedThroughput provisionedThroughput() {
        return provisionedThroughput;
    }

    /**
     * For responses, this returns true if the service returned a value for the Replicas property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReplicas() {
        return replicas != null && !(replicas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of replicas of this table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicas} method.
     * </p>
     * 
     * @return The list of replicas of this table.
     */
    public final List<AwsDynamoDbTableReplica> replicas() {
        return replicas;
    }

    /**
     * <p>
     * Information about the restore for the table.
     * </p>
     * 
     * @return Information about the restore for the table.
     */
    public final AwsDynamoDbTableRestoreSummary restoreSummary() {
        return restoreSummary;
    }

    /**
     * <p>
     * Information about the server-side encryption for the table.
     * </p>
     * 
     * @return Information about the server-side encryption for the table.
     */
    public final AwsDynamoDbTableSseDescription sseDescription() {
        return sseDescription;
    }

    /**
     * <p>
     * The current DynamoDB Streams configuration for the table.
     * </p>
     * 
     * @return The current DynamoDB Streams configuration for the table.
     */
    public final AwsDynamoDbTableStreamSpecification streamSpecification() {
        return streamSpecification;
    }

    /**
     * <p>
     * The identifier of the table.
     * </p>
     * 
     * @return The identifier of the table.
     */
    public final String tableId() {
        return tableId;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The total size of the table in bytes.
     * </p>
     * 
     * @return The total size of the table in bytes.
     */
    public final Long tableSizeBytes() {
        return tableSizeBytes;
    }

    /**
     * <p>
     * The current status of the table.
     * </p>
     * 
     * @return The current status of the table.
     */
    public final String tableStatus() {
        return tableStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeDefinitions() ? attributeDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(billingModeSummary());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(globalTableVersion());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeySchema() ? keySchema() : null);
        hashCode = 31 * hashCode + Objects.hashCode(latestStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(latestStreamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(hasReplicas() ? replicas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(restoreSummary());
        hashCode = 31 * hashCode + Objects.hashCode(sseDescription());
        hashCode = 31 * hashCode + Objects.hashCode(streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(tableId());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(tableStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableDetails)) {
            return false;
        }
        AwsDynamoDbTableDetails other = (AwsDynamoDbTableDetails) obj;
        return hasAttributeDefinitions() == other.hasAttributeDefinitions()
                && Objects.equals(attributeDefinitions(), other.attributeDefinitions())
                && Objects.equals(billingModeSummary(), other.billingModeSummary())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && hasGlobalSecondaryIndexes() == other.hasGlobalSecondaryIndexes()
                && Objects.equals(globalSecondaryIndexes(), other.globalSecondaryIndexes())
                && Objects.equals(globalTableVersion(), other.globalTableVersion())
                && Objects.equals(itemCount(), other.itemCount()) && hasKeySchema() == other.hasKeySchema()
                && Objects.equals(keySchema(), other.keySchema()) && Objects.equals(latestStreamArn(), other.latestStreamArn())
                && Objects.equals(latestStreamLabel(), other.latestStreamLabel())
                && hasLocalSecondaryIndexes() == other.hasLocalSecondaryIndexes()
                && Objects.equals(localSecondaryIndexes(), other.localSecondaryIndexes())
                && Objects.equals(provisionedThroughput(), other.provisionedThroughput()) && hasReplicas() == other.hasReplicas()
                && Objects.equals(replicas(), other.replicas()) && Objects.equals(restoreSummary(), other.restoreSummary())
                && Objects.equals(sseDescription(), other.sseDescription())
                && Objects.equals(streamSpecification(), other.streamSpecification())
                && Objects.equals(tableId(), other.tableId()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(tableStatus(), other.tableStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableDetails")
                .add("AttributeDefinitions", hasAttributeDefinitions() ? attributeDefinitions() : null)
                .add("BillingModeSummary", billingModeSummary()).add("CreationDateTime", creationDateTime())
                .add("GlobalSecondaryIndexes", hasGlobalSecondaryIndexes() ? globalSecondaryIndexes() : null)
                .add("GlobalTableVersion", globalTableVersion()).add("ItemCount", itemCount())
                .add("KeySchema", hasKeySchema() ? keySchema() : null).add("LatestStreamArn", latestStreamArn())
                .add("LatestStreamLabel", latestStreamLabel())
                .add("LocalSecondaryIndexes", hasLocalSecondaryIndexes() ? localSecondaryIndexes() : null)
                .add("ProvisionedThroughput", provisionedThroughput()).add("Replicas", hasReplicas() ? replicas() : null)
                .add("RestoreSummary", restoreSummary()).add("SseDescription", sseDescription())
                .add("StreamSpecification", streamSpecification()).add("TableId", tableId()).add("TableName", tableName())
                .add("TableSizeBytes", tableSizeBytes()).add("TableStatus", tableStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeDefinitions":
            return Optional.ofNullable(clazz.cast(attributeDefinitions()));
        case "BillingModeSummary":
            return Optional.ofNullable(clazz.cast(billingModeSummary()));
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "GlobalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(globalSecondaryIndexes()));
        case "GlobalTableVersion":
            return Optional.ofNullable(clazz.cast(globalTableVersion()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "KeySchema":
            return Optional.ofNullable(clazz.cast(keySchema()));
        case "LatestStreamArn":
            return Optional.ofNullable(clazz.cast(latestStreamArn()));
        case "LatestStreamLabel":
            return Optional.ofNullable(clazz.cast(latestStreamLabel()));
        case "LocalSecondaryIndexes":
            return Optional.ofNullable(clazz.cast(localSecondaryIndexes()));
        case "ProvisionedThroughput":
            return Optional.ofNullable(clazz.cast(provisionedThroughput()));
        case "Replicas":
            return Optional.ofNullable(clazz.cast(replicas()));
        case "RestoreSummary":
            return Optional.ofNullable(clazz.cast(restoreSummary()));
        case "SseDescription":
            return Optional.ofNullable(clazz.cast(sseDescription()));
        case "StreamSpecification":
            return Optional.ofNullable(clazz.cast(streamSpecification()));
        case "TableId":
            return Optional.ofNullable(clazz.cast(tableId()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableSizeBytes":
            return Optional.ofNullable(clazz.cast(tableSizeBytes()));
        case "TableStatus":
            return Optional.ofNullable(clazz.cast(tableStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableDetails, T> g) {
        return obj -> g.apply((AwsDynamoDbTableDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableDetails> {
        /**
         * <p>
         * A list of attribute definitions for the table.
         * </p>
         * 
         * @param attributeDefinitions
         *        A list of attribute definitions for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition> attributeDefinitions);

        /**
         * <p>
         * A list of attribute definitions for the table.
         * </p>
         * 
         * @param attributeDefinitions
         *        A list of attribute definitions for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeDefinitions(AwsDynamoDbTableAttributeDefinition... attributeDefinitions);

        /**
         * <p>
         * A list of attribute definitions for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsDynamoDbTableAttributeDefinition>.Builder} avoiding the need to create one manually via {@link List
         * <AwsDynamoDbTableAttributeDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsDynamoDbTableAttributeDefinition>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #attributeDefinitions(List<AwsDynamoDbTableAttributeDefinition>)}.
         * 
         * @param attributeDefinitions
         *        a consumer that will call methods on {@link List<AwsDynamoDbTableAttributeDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeDefinitions(List<AwsDynamoDbTableAttributeDefinition>)
         */
        Builder attributeDefinitions(Consumer<AwsDynamoDbTableAttributeDefinition.Builder>... attributeDefinitions);

        /**
         * <p>
         * Information about the billing for read/write capacity on the table.
         * </p>
         * 
         * @param billingModeSummary
         *        Information about the billing for read/write capacity on the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingModeSummary(AwsDynamoDbTableBillingModeSummary billingModeSummary);

        /**
         * <p>
         * Information about the billing for read/write capacity on the table.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsDynamoDbTableBillingModeSummary.Builder}
         * avoiding the need to create one manually via {@link AwsDynamoDbTableBillingModeSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableBillingModeSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #billingModeSummary(AwsDynamoDbTableBillingModeSummary)}.
         * 
         * @param billingModeSummary
         *        a consumer that will call methods on {@link AwsDynamoDbTableBillingModeSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingModeSummary(AwsDynamoDbTableBillingModeSummary)
         */
        default Builder billingModeSummary(Consumer<AwsDynamoDbTableBillingModeSummary.Builder> billingModeSummary) {
            return billingModeSummary(AwsDynamoDbTableBillingModeSummary.builder().applyMutation(billingModeSummary).build());
        }

        /**
         * <p>
         * Indicates when the table was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param creationDateTime
         *        Indicates when the table was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(String creationDateTime);

        /**
         * <p>
         * List of global secondary indexes for the table.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        List of global secondary indexes for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes);

        /**
         * <p>
         * List of global secondary indexes for the table.
         * </p>
         * 
         * @param globalSecondaryIndexes
         *        List of global secondary indexes for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalSecondaryIndexes(AwsDynamoDbTableGlobalSecondaryIndex... globalSecondaryIndexes);

        /**
         * <p>
         * List of global secondary indexes for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsDynamoDbTableGlobalSecondaryIndex>.Builder} avoiding the need to create one manually via {@link List
         * <AwsDynamoDbTableGlobalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsDynamoDbTableGlobalSecondaryIndex>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #globalSecondaryIndexes(List<AwsDynamoDbTableGlobalSecondaryIndex>)}.
         * 
         * @param globalSecondaryIndexes
         *        a consumer that will call methods on {@link List<AwsDynamoDbTableGlobalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalSecondaryIndexes(List<AwsDynamoDbTableGlobalSecondaryIndex>)
         */
        Builder globalSecondaryIndexes(Consumer<AwsDynamoDbTableGlobalSecondaryIndex.Builder>... globalSecondaryIndexes);

        /**
         * <p>
         * The version of global tables being used.
         * </p>
         * 
         * @param globalTableVersion
         *        The version of global tables being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalTableVersion(String globalTableVersion);

        /**
         * <p>
         * The number of items in the table.
         * </p>
         * 
         * @param itemCount
         *        The number of items in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * The primary key structure for the table.
         * </p>
         * 
         * @param keySchema
         *        The primary key structure for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema);

        /**
         * <p>
         * The primary key structure for the table.
         * </p>
         * 
         * @param keySchema
         *        The primary key structure for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keySchema(AwsDynamoDbTableKeySchema... keySchema);

        /**
         * <p>
         * The primary key structure for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsDynamoDbTableKeySchema>.Builder}
         * avoiding the need to create one manually via {@link List<AwsDynamoDbTableKeySchema>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsDynamoDbTableKeySchema>.Builder#build()} is called
         * immediately and its result is passed to {@link #keySchema(List<AwsDynamoDbTableKeySchema>)}.
         * 
         * @param keySchema
         *        a consumer that will call methods on {@link List<AwsDynamoDbTableKeySchema>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keySchema(List<AwsDynamoDbTableKeySchema>)
         */
        Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema);

        /**
         * <p>
         * The ARN of the latest stream for the table.
         * </p>
         * 
         * @param latestStreamArn
         *        The ARN of the latest stream for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestStreamArn(String latestStreamArn);

        /**
         * <p>
         * The label of the latest stream. The label is not a unique identifier.
         * </p>
         * 
         * @param latestStreamLabel
         *        The label of the latest stream. The label is not a unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestStreamLabel(String latestStreamLabel);

        /**
         * <p>
         * The list of local secondary indexes for the table.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        The list of local secondary indexes for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(Collection<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes);

        /**
         * <p>
         * The list of local secondary indexes for the table.
         * </p>
         * 
         * @param localSecondaryIndexes
         *        The list of local secondary indexes for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localSecondaryIndexes(AwsDynamoDbTableLocalSecondaryIndex... localSecondaryIndexes);

        /**
         * <p>
         * The list of local secondary indexes for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsDynamoDbTableLocalSecondaryIndex>.Builder} avoiding the need to create one manually via {@link List
         * <AwsDynamoDbTableLocalSecondaryIndex>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsDynamoDbTableLocalSecondaryIndex>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #localSecondaryIndexes(List<AwsDynamoDbTableLocalSecondaryIndex>)}.
         * 
         * @param localSecondaryIndexes
         *        a consumer that will call methods on {@link List<AwsDynamoDbTableLocalSecondaryIndex>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localSecondaryIndexes(List<AwsDynamoDbTableLocalSecondaryIndex>)
         */
        Builder localSecondaryIndexes(Consumer<AwsDynamoDbTableLocalSecondaryIndex.Builder>... localSecondaryIndexes);

        /**
         * <p>
         * Information about the provisioned throughput for the table.
         * </p>
         * 
         * @param provisionedThroughput
         *        Information about the provisioned throughput for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput);

        /**
         * <p>
         * Information about the provisioned throughput for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsDynamoDbTableProvisionedThroughput.Builder}
         * avoiding the need to create one manually via {@link AwsDynamoDbTableProvisionedThroughput#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableProvisionedThroughput.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedThroughput(AwsDynamoDbTableProvisionedThroughput)}
         * .
         * 
         * @param provisionedThroughput
         *        a consumer that will call methods on {@link AwsDynamoDbTableProvisionedThroughput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedThroughput(AwsDynamoDbTableProvisionedThroughput)
         */
        default Builder provisionedThroughput(Consumer<AwsDynamoDbTableProvisionedThroughput.Builder> provisionedThroughput) {
            return provisionedThroughput(AwsDynamoDbTableProvisionedThroughput.builder().applyMutation(provisionedThroughput)
                    .build());
        }

        /**
         * <p>
         * The list of replicas of this table.
         * </p>
         * 
         * @param replicas
         *        The list of replicas of this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(Collection<AwsDynamoDbTableReplica> replicas);

        /**
         * <p>
         * The list of replicas of this table.
         * </p>
         * 
         * @param replicas
         *        The list of replicas of this table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicas(AwsDynamoDbTableReplica... replicas);

        /**
         * <p>
         * The list of replicas of this table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsDynamoDbTableReplica>.Builder} avoiding
         * the need to create one manually via {@link List<AwsDynamoDbTableReplica>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsDynamoDbTableReplica>.Builder#build()} is called
         * immediately and its result is passed to {@link #replicas(List<AwsDynamoDbTableReplica>)}.
         * 
         * @param replicas
         *        a consumer that will call methods on {@link List<AwsDynamoDbTableReplica>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicas(List<AwsDynamoDbTableReplica>)
         */
        Builder replicas(Consumer<AwsDynamoDbTableReplica.Builder>... replicas);

        /**
         * <p>
         * Information about the restore for the table.
         * </p>
         * 
         * @param restoreSummary
         *        Information about the restore for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreSummary(AwsDynamoDbTableRestoreSummary restoreSummary);

        /**
         * <p>
         * Information about the restore for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsDynamoDbTableRestoreSummary.Builder} avoiding
         * the need to create one manually via {@link AwsDynamoDbTableRestoreSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableRestoreSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #restoreSummary(AwsDynamoDbTableRestoreSummary)}.
         * 
         * @param restoreSummary
         *        a consumer that will call methods on {@link AwsDynamoDbTableRestoreSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #restoreSummary(AwsDynamoDbTableRestoreSummary)
         */
        default Builder restoreSummary(Consumer<AwsDynamoDbTableRestoreSummary.Builder> restoreSummary) {
            return restoreSummary(AwsDynamoDbTableRestoreSummary.builder().applyMutation(restoreSummary).build());
        }

        /**
         * <p>
         * Information about the server-side encryption for the table.
         * </p>
         * 
         * @param sseDescription
         *        Information about the server-side encryption for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseDescription(AwsDynamoDbTableSseDescription sseDescription);

        /**
         * <p>
         * Information about the server-side encryption for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsDynamoDbTableSseDescription.Builder} avoiding
         * the need to create one manually via {@link AwsDynamoDbTableSseDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableSseDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #sseDescription(AwsDynamoDbTableSseDescription)}.
         * 
         * @param sseDescription
         *        a consumer that will call methods on {@link AwsDynamoDbTableSseDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseDescription(AwsDynamoDbTableSseDescription)
         */
        default Builder sseDescription(Consumer<AwsDynamoDbTableSseDescription.Builder> sseDescription) {
            return sseDescription(AwsDynamoDbTableSseDescription.builder().applyMutation(sseDescription).build());
        }

        /**
         * <p>
         * The current DynamoDB Streams configuration for the table.
         * </p>
         * 
         * @param streamSpecification
         *        The current DynamoDB Streams configuration for the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSpecification(AwsDynamoDbTableStreamSpecification streamSpecification);

        /**
         * <p>
         * The current DynamoDB Streams configuration for the table.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsDynamoDbTableStreamSpecification.Builder}
         * avoiding the need to create one manually via {@link AwsDynamoDbTableStreamSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsDynamoDbTableStreamSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #streamSpecification(AwsDynamoDbTableStreamSpecification)}.
         * 
         * @param streamSpecification
         *        a consumer that will call methods on {@link AwsDynamoDbTableStreamSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSpecification(AwsDynamoDbTableStreamSpecification)
         */
        default Builder streamSpecification(Consumer<AwsDynamoDbTableStreamSpecification.Builder> streamSpecification) {
            return streamSpecification(AwsDynamoDbTableStreamSpecification.builder().applyMutation(streamSpecification).build());
        }

        /**
         * <p>
         * The identifier of the table.
         * </p>
         * 
         * @param tableId
         *        The identifier of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableId(String tableId);

        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param tableName
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The total size of the table in bytes.
         * </p>
         * 
         * @param tableSizeBytes
         *        The total size of the table in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableSizeBytes(Long tableSizeBytes);

        /**
         * <p>
         * The current status of the table.
         * </p>
         * 
         * @param tableStatus
         *        The current status of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableStatus(String tableStatus);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsDynamoDbTableAttributeDefinition> attributeDefinitions = DefaultSdkAutoConstructList.getInstance();

        private AwsDynamoDbTableBillingModeSummary billingModeSummary;

        private String creationDateTime;

        private List<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private String globalTableVersion;

        private Integer itemCount;

        private List<AwsDynamoDbTableKeySchema> keySchema = DefaultSdkAutoConstructList.getInstance();

        private String latestStreamArn;

        private String latestStreamLabel;

        private List<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes = DefaultSdkAutoConstructList.getInstance();

        private AwsDynamoDbTableProvisionedThroughput provisionedThroughput;

        private List<AwsDynamoDbTableReplica> replicas = DefaultSdkAutoConstructList.getInstance();

        private AwsDynamoDbTableRestoreSummary restoreSummary;

        private AwsDynamoDbTableSseDescription sseDescription;

        private AwsDynamoDbTableStreamSpecification streamSpecification;

        private String tableId;

        private String tableName;

        private Long tableSizeBytes;

        private String tableStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableDetails model) {
            attributeDefinitions(model.attributeDefinitions);
            billingModeSummary(model.billingModeSummary);
            creationDateTime(model.creationDateTime);
            globalSecondaryIndexes(model.globalSecondaryIndexes);
            globalTableVersion(model.globalTableVersion);
            itemCount(model.itemCount);
            keySchema(model.keySchema);
            latestStreamArn(model.latestStreamArn);
            latestStreamLabel(model.latestStreamLabel);
            localSecondaryIndexes(model.localSecondaryIndexes);
            provisionedThroughput(model.provisionedThroughput);
            replicas(model.replicas);
            restoreSummary(model.restoreSummary);
            sseDescription(model.sseDescription);
            streamSpecification(model.streamSpecification);
            tableId(model.tableId);
            tableName(model.tableName);
            tableSizeBytes(model.tableSizeBytes);
            tableStatus(model.tableStatus);
        }

        public final List<AwsDynamoDbTableAttributeDefinition.Builder> getAttributeDefinitions() {
            List<AwsDynamoDbTableAttributeDefinition.Builder> result = AwsDynamoDbTableAttributeDefinitionListCopier
                    .copyToBuilder(this.attributeDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AwsDynamoDbTableAttributeDefinitionListCopier.copyFromBuilder(attributeDefinitions);
        }

        @Override
        @Transient
        public final Builder attributeDefinitions(Collection<AwsDynamoDbTableAttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AwsDynamoDbTableAttributeDefinitionListCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeDefinitions(AwsDynamoDbTableAttributeDefinition... attributeDefinitions) {
            attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attributeDefinitions(Consumer<AwsDynamoDbTableAttributeDefinition.Builder>... attributeDefinitions) {
            attributeDefinitions(Stream.of(attributeDefinitions)
                    .map(c -> AwsDynamoDbTableAttributeDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableBillingModeSummary.Builder getBillingModeSummary() {
            return billingModeSummary != null ? billingModeSummary.toBuilder() : null;
        }

        public final void setBillingModeSummary(AwsDynamoDbTableBillingModeSummary.BuilderImpl billingModeSummary) {
            this.billingModeSummary = billingModeSummary != null ? billingModeSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder billingModeSummary(AwsDynamoDbTableBillingModeSummary billingModeSummary) {
            this.billingModeSummary = billingModeSummary;
            return this;
        }

        public final String getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        @Transient
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final List<AwsDynamoDbTableGlobalSecondaryIndex.Builder> getGlobalSecondaryIndexes() {
            List<AwsDynamoDbTableGlobalSecondaryIndex.Builder> result = AwsDynamoDbTableGlobalSecondaryIndexListCopier
                    .copyToBuilder(this.globalSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalSecondaryIndexes(
                Collection<AwsDynamoDbTableGlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableGlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        @Override
        @Transient
        public final Builder globalSecondaryIndexes(Collection<AwsDynamoDbTableGlobalSecondaryIndex> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = AwsDynamoDbTableGlobalSecondaryIndexListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder globalSecondaryIndexes(AwsDynamoDbTableGlobalSecondaryIndex... globalSecondaryIndexes) {
            globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder globalSecondaryIndexes(
                Consumer<AwsDynamoDbTableGlobalSecondaryIndex.Builder>... globalSecondaryIndexes) {
            globalSecondaryIndexes(Stream.of(globalSecondaryIndexes)
                    .map(c -> AwsDynamoDbTableGlobalSecondaryIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getGlobalTableVersion() {
            return globalTableVersion;
        }

        public final void setGlobalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
        }

        @Override
        @Transient
        public final Builder globalTableVersion(String globalTableVersion) {
            this.globalTableVersion = globalTableVersion;
            return this;
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        @Override
        @Transient
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final List<AwsDynamoDbTableKeySchema.Builder> getKeySchema() {
            List<AwsDynamoDbTableKeySchema.Builder> result = AwsDynamoDbTableKeySchemaListCopier.copyToBuilder(this.keySchema);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setKeySchema(Collection<AwsDynamoDbTableKeySchema.BuilderImpl> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copyFromBuilder(keySchema);
        }

        @Override
        @Transient
        public final Builder keySchema(Collection<AwsDynamoDbTableKeySchema> keySchema) {
            this.keySchema = AwsDynamoDbTableKeySchemaListCopier.copy(keySchema);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(AwsDynamoDbTableKeySchema... keySchema) {
            keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keySchema(Consumer<AwsDynamoDbTableKeySchema.Builder>... keySchema) {
            keySchema(Stream.of(keySchema).map(c -> AwsDynamoDbTableKeySchema.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getLatestStreamArn() {
            return latestStreamArn;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        @Override
        @Transient
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final String getLatestStreamLabel() {
            return latestStreamLabel;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        @Override
        @Transient
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final List<AwsDynamoDbTableLocalSecondaryIndex.Builder> getLocalSecondaryIndexes() {
            List<AwsDynamoDbTableLocalSecondaryIndex.Builder> result = AwsDynamoDbTableLocalSecondaryIndexListCopier
                    .copyToBuilder(this.localSecondaryIndexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocalSecondaryIndexes(
                Collection<AwsDynamoDbTableLocalSecondaryIndex.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = AwsDynamoDbTableLocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        @Override
        @Transient
        public final Builder localSecondaryIndexes(Collection<AwsDynamoDbTableLocalSecondaryIndex> localSecondaryIndexes) {
            this.localSecondaryIndexes = AwsDynamoDbTableLocalSecondaryIndexListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder localSecondaryIndexes(AwsDynamoDbTableLocalSecondaryIndex... localSecondaryIndexes) {
            localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder localSecondaryIndexes(Consumer<AwsDynamoDbTableLocalSecondaryIndex.Builder>... localSecondaryIndexes) {
            localSecondaryIndexes(Stream.of(localSecondaryIndexes)
                    .map(c -> AwsDynamoDbTableLocalSecondaryIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableProvisionedThroughput.Builder getProvisionedThroughput() {
            return provisionedThroughput != null ? provisionedThroughput.toBuilder() : null;
        }

        public final void setProvisionedThroughput(AwsDynamoDbTableProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        @Override
        @Transient
        public final Builder provisionedThroughput(AwsDynamoDbTableProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final List<AwsDynamoDbTableReplica.Builder> getReplicas() {
            List<AwsDynamoDbTableReplica.Builder> result = AwsDynamoDbTableReplicaListCopier.copyToBuilder(this.replicas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicas(Collection<AwsDynamoDbTableReplica.BuilderImpl> replicas) {
            this.replicas = AwsDynamoDbTableReplicaListCopier.copyFromBuilder(replicas);
        }

        @Override
        @Transient
        public final Builder replicas(Collection<AwsDynamoDbTableReplica> replicas) {
            this.replicas = AwsDynamoDbTableReplicaListCopier.copy(replicas);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicas(AwsDynamoDbTableReplica... replicas) {
            replicas(Arrays.asList(replicas));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder replicas(Consumer<AwsDynamoDbTableReplica.Builder>... replicas) {
            replicas(Stream.of(replicas).map(c -> AwsDynamoDbTableReplica.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsDynamoDbTableRestoreSummary.Builder getRestoreSummary() {
            return restoreSummary != null ? restoreSummary.toBuilder() : null;
        }

        public final void setRestoreSummary(AwsDynamoDbTableRestoreSummary.BuilderImpl restoreSummary) {
            this.restoreSummary = restoreSummary != null ? restoreSummary.build() : null;
        }

        @Override
        @Transient
        public final Builder restoreSummary(AwsDynamoDbTableRestoreSummary restoreSummary) {
            this.restoreSummary = restoreSummary;
            return this;
        }

        public final AwsDynamoDbTableSseDescription.Builder getSseDescription() {
            return sseDescription != null ? sseDescription.toBuilder() : null;
        }

        public final void setSseDescription(AwsDynamoDbTableSseDescription.BuilderImpl sseDescription) {
            this.sseDescription = sseDescription != null ? sseDescription.build() : null;
        }

        @Override
        @Transient
        public final Builder sseDescription(AwsDynamoDbTableSseDescription sseDescription) {
            this.sseDescription = sseDescription;
            return this;
        }

        public final AwsDynamoDbTableStreamSpecification.Builder getStreamSpecification() {
            return streamSpecification != null ? streamSpecification.toBuilder() : null;
        }

        public final void setStreamSpecification(AwsDynamoDbTableStreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder streamSpecification(AwsDynamoDbTableStreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final String getTableId() {
            return tableId;
        }

        public final void setTableId(String tableId) {
            this.tableId = tableId;
        }

        @Override
        @Transient
        public final Builder tableId(String tableId) {
            this.tableId = tableId;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Long getTableSizeBytes() {
            return tableSizeBytes;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        @Override
        @Transient
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final String getTableStatus() {
            return tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        @Transient
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public AwsDynamoDbTableDetails build() {
            return new AwsDynamoDbTableDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
