/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For global and local secondary indexes, identifies the attributes that are copied from the table into the index.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDynamoDbTableProjection implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDynamoDbTableProjection.Builder, AwsDynamoDbTableProjection> {
    private static final SdkField<List<String>> NON_KEY_ATTRIBUTES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NonKeyAttributes")
            .getter(getter(AwsDynamoDbTableProjection::nonKeyAttributes))
            .setter(setter(Builder::nonKeyAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonKeyAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PROJECTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectionType").getter(getter(AwsDynamoDbTableProjection::projectionType))
            .setter(setter(Builder::projectionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NON_KEY_ATTRIBUTES_FIELD,
            PROJECTION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> nonKeyAttributes;

    private final String projectionType;

    private AwsDynamoDbTableProjection(BuilderImpl builder) {
        this.nonKeyAttributes = builder.nonKeyAttributes;
        this.projectionType = builder.projectionType;
    }

    /**
     * For responses, this returns true if the service returned a value for the NonKeyAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNonKeyAttributes() {
        return nonKeyAttributes != null && !(nonKeyAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nonkey attributes that are projected into the index. For each attribute, provide the attribute name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNonKeyAttributes} method.
     * </p>
     * 
     * @return The nonkey attributes that are projected into the index. For each attribute, provide the attribute name.
     */
    public final List<String> nonKeyAttributes() {
        return nonKeyAttributes;
    }

    /**
     * <p>
     * The types of attributes that are projected into the index.
     * </p>
     * 
     * @return The types of attributes that are projected into the index.
     */
    public final String projectionType() {
        return projectionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNonKeyAttributes() ? nonKeyAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(projectionType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDynamoDbTableProjection)) {
            return false;
        }
        AwsDynamoDbTableProjection other = (AwsDynamoDbTableProjection) obj;
        return hasNonKeyAttributes() == other.hasNonKeyAttributes()
                && Objects.equals(nonKeyAttributes(), other.nonKeyAttributes())
                && Objects.equals(projectionType(), other.projectionType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDynamoDbTableProjection")
                .add("NonKeyAttributes", hasNonKeyAttributes() ? nonKeyAttributes() : null)
                .add("ProjectionType", projectionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NonKeyAttributes":
            return Optional.ofNullable(clazz.cast(nonKeyAttributes()));
        case "ProjectionType":
            return Optional.ofNullable(clazz.cast(projectionType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsDynamoDbTableProjection, T> g) {
        return obj -> g.apply((AwsDynamoDbTableProjection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDynamoDbTableProjection> {
        /**
         * <p>
         * The nonkey attributes that are projected into the index. For each attribute, provide the attribute name.
         * </p>
         * 
         * @param nonKeyAttributes
         *        The nonkey attributes that are projected into the index. For each attribute, provide the attribute
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonKeyAttributes(Collection<String> nonKeyAttributes);

        /**
         * <p>
         * The nonkey attributes that are projected into the index. For each attribute, provide the attribute name.
         * </p>
         * 
         * @param nonKeyAttributes
         *        The nonkey attributes that are projected into the index. For each attribute, provide the attribute
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonKeyAttributes(String... nonKeyAttributes);

        /**
         * <p>
         * The types of attributes that are projected into the index.
         * </p>
         * 
         * @param projectionType
         *        The types of attributes that are projected into the index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectionType(String projectionType);
    }

    static final class BuilderImpl implements Builder {
        private List<String> nonKeyAttributes = DefaultSdkAutoConstructList.getInstance();

        private String projectionType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDynamoDbTableProjection model) {
            nonKeyAttributes(model.nonKeyAttributes);
            projectionType(model.projectionType);
        }

        public final Collection<String> getNonKeyAttributes() {
            if (nonKeyAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return nonKeyAttributes;
        }

        public final void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = StringListCopier.copy(nonKeyAttributes);
        }

        @Override
        @Transient
        public final Builder nonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = StringListCopier.copy(nonKeyAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder nonKeyAttributes(String... nonKeyAttributes) {
            nonKeyAttributes(Arrays.asList(nonKeyAttributes));
            return this;
        }

        public final String getProjectionType() {
            return projectionType;
        }

        public final void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        @Override
        @Transient
        public final Builder projectionType(String projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        @Override
        public AwsDynamoDbTableProjection build() {
            return new AwsDynamoDbTableProjection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
