/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsEc2NetworkInterfaceIpV6AddressListCopier {
    static List<AwsEc2NetworkInterfaceIpV6AddressDetail> copy(
            Collection<? extends AwsEc2NetworkInterfaceIpV6AddressDetail> awsEc2NetworkInterfaceIpV6AddressListParam) {
        List<AwsEc2NetworkInterfaceIpV6AddressDetail> list;
        if (awsEc2NetworkInterfaceIpV6AddressListParam == null
                || awsEc2NetworkInterfaceIpV6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2NetworkInterfaceIpV6AddressDetail> modifiableList = new ArrayList<>();
            awsEc2NetworkInterfaceIpV6AddressListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2NetworkInterfaceIpV6AddressDetail> copyFromBuilder(
            Collection<? extends AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> awsEc2NetworkInterfaceIpV6AddressListParam) {
        List<AwsEc2NetworkInterfaceIpV6AddressDetail> list;
        if (awsEc2NetworkInterfaceIpV6AddressListParam == null
                || awsEc2NetworkInterfaceIpV6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2NetworkInterfaceIpV6AddressDetail> modifiableList = new ArrayList<>();
            awsEc2NetworkInterfaceIpV6AddressListParam.forEach(entry -> {
                AwsEc2NetworkInterfaceIpV6AddressDetail member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> copyToBuilder(
            Collection<? extends AwsEc2NetworkInterfaceIpV6AddressDetail> awsEc2NetworkInterfaceIpV6AddressListParam) {
        List<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> list;
        if (awsEc2NetworkInterfaceIpV6AddressListParam == null
                || awsEc2NetworkInterfaceIpV6AddressListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2NetworkInterfaceIpV6AddressDetail.Builder> modifiableList = new ArrayList<>();
            awsEc2NetworkInterfaceIpV6AddressListParam.forEach(entry -> {
                AwsEc2NetworkInterfaceIpV6AddressDetail.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
