/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * VPN connection options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VpnConnectionOptionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VpnConnectionOptionsDetails.Builder, AwsEc2VpnConnectionOptionsDetails> {
    private static final SdkField<Boolean> STATIC_ROUTES_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StaticRoutesOnly").getter(getter(AwsEc2VpnConnectionOptionsDetails::staticRoutesOnly))
            .setter(setter(Builder::staticRoutesOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticRoutesOnly").build()).build();

    private static final SdkField<List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>> TUNNEL_OPTIONS_FIELD = SdkField
            .<List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>> builder(MarshallingType.LIST)
            .memberName("TunnelOptions")
            .getter(getter(AwsEc2VpnConnectionOptionsDetails::tunnelOptions))
            .setter(setter(Builder::tunnelOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2VpnConnectionOptionsTunnelOptionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATIC_ROUTES_ONLY_FIELD,
            TUNNEL_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean staticRoutesOnly;

    private final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions;

    private AwsEc2VpnConnectionOptionsDetails(BuilderImpl builder) {
        this.staticRoutesOnly = builder.staticRoutesOnly;
        this.tunnelOptions = builder.tunnelOptions;
    }

    /**
     * <p>
     * Whether the VPN connection uses static routes only.
     * </p>
     * 
     * @return Whether the VPN connection uses static routes only.
     */
    public final Boolean staticRoutesOnly() {
        return staticRoutesOnly;
    }

    /**
     * For responses, this returns true if the service returned a value for the TunnelOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTunnelOptions() {
        return tunnelOptions != null && !(tunnelOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPN tunnel options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTunnelOptions} method.
     * </p>
     * 
     * @return The VPN tunnel options.
     */
    public final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions() {
        return tunnelOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(staticRoutesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(hasTunnelOptions() ? tunnelOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpnConnectionOptionsDetails)) {
            return false;
        }
        AwsEc2VpnConnectionOptionsDetails other = (AwsEc2VpnConnectionOptionsDetails) obj;
        return Objects.equals(staticRoutesOnly(), other.staticRoutesOnly()) && hasTunnelOptions() == other.hasTunnelOptions()
                && Objects.equals(tunnelOptions(), other.tunnelOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VpnConnectionOptionsDetails").add("StaticRoutesOnly", staticRoutesOnly())
                .add("TunnelOptions", hasTunnelOptions() ? tunnelOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StaticRoutesOnly":
            return Optional.ofNullable(clazz.cast(staticRoutesOnly()));
        case "TunnelOptions":
            return Optional.ofNullable(clazz.cast(tunnelOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpnConnectionOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2VpnConnectionOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VpnConnectionOptionsDetails> {
        /**
         * <p>
         * Whether the VPN connection uses static routes only.
         * </p>
         * 
         * @param staticRoutesOnly
         *        Whether the VPN connection uses static routes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staticRoutesOnly(Boolean staticRoutesOnly);

        /**
         * <p>
         * The VPN tunnel options.
         * </p>
         * 
         * @param tunnelOptions
         *        The VPN tunnel options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions);

        /**
         * <p>
         * The VPN tunnel options.
         * </p>
         * 
         * @param tunnelOptions
         *        The VPN tunnel options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelOptions(AwsEc2VpnConnectionOptionsTunnelOptionsDetails... tunnelOptions);

        /**
         * <p>
         * The VPN tunnel options.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsEc2VpnConnectionOptionsTunnelOptionsDetails>.Builder} avoiding the need to create one manually via
         * {@link List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsEc2VpnConnectionOptionsTunnelOptionsDetails>.Builder#build()} is called immediately and its result is
         * passed to {@link #tunnelOptions(List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>)}.
         * 
         * @param tunnelOptions
         *        a consumer that will call methods on {@link List
         *        <AwsEc2VpnConnectionOptionsTunnelOptionsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tunnelOptions(List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails>)
         */
        Builder tunnelOptions(Consumer<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder>... tunnelOptions);
    }

    static final class BuilderImpl implements Builder {
        private Boolean staticRoutesOnly;

        private List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpnConnectionOptionsDetails model) {
            staticRoutesOnly(model.staticRoutesOnly);
            tunnelOptions(model.tunnelOptions);
        }

        public final Boolean getStaticRoutesOnly() {
            return staticRoutesOnly;
        }

        public final void setStaticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
        }

        @Override
        @Transient
        public final Builder staticRoutesOnly(Boolean staticRoutesOnly) {
            this.staticRoutesOnly = staticRoutesOnly;
            return this;
        }

        public final List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> getTunnelOptions() {
            List<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder> result = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier
                    .copyToBuilder(this.tunnelOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.BuilderImpl> tunnelOptions) {
            this.tunnelOptions = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier.copyFromBuilder(tunnelOptions);
        }

        @Override
        @Transient
        public final Builder tunnelOptions(Collection<AwsEc2VpnConnectionOptionsTunnelOptionsDetails> tunnelOptions) {
            this.tunnelOptions = AwsEc2VpnConnectionOptionsTunnelOptionsListCopier.copy(tunnelOptions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tunnelOptions(AwsEc2VpnConnectionOptionsTunnelOptionsDetails... tunnelOptions) {
            tunnelOptions(Arrays.asList(tunnelOptions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tunnelOptions(Consumer<AwsEc2VpnConnectionOptionsTunnelOptionsDetails.Builder>... tunnelOptions) {
            tunnelOptions(Stream.of(tunnelOptions)
                    .map(c -> AwsEc2VpnConnectionOptionsTunnelOptionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsEc2VpnConnectionOptionsDetails build() {
            return new AwsEc2VpnConnectionOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
