/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the lifecycle policy for the repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcrRepositoryLifecyclePolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcrRepositoryLifecyclePolicyDetails.Builder, AwsEcrRepositoryLifecyclePolicyDetails> {
    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifecyclePolicyText").getter(getter(AwsEcrRepositoryLifecyclePolicyDetails::lifecyclePolicyText))
            .setter(setter(Builder::lifecyclePolicyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicyText").build())
            .build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegistryId").getter(getter(AwsEcrRepositoryLifecyclePolicyDetails::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_TEXT_FIELD,
            REGISTRY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String lifecyclePolicyText;

    private final String registryId;

    private AwsEcrRepositoryLifecyclePolicyDetails(BuilderImpl builder) {
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.registryId = builder.registryId;
    }

    /**
     * <p>
     * The text of the lifecycle policy.
     * </p>
     * 
     * @return The text of the lifecycle policy.
     */
    public final String lifecyclePolicyText() {
        return lifecyclePolicyText;
    }

    /**
     * <p>
     * The Amazon Web Services account identifier that is associated with the registry that contains the repository.
     * </p>
     * 
     * @return The Amazon Web Services account identifier that is associated with the registry that contains the
     *         repository.
     */
    public final String registryId() {
        return registryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcrRepositoryLifecyclePolicyDetails)) {
            return false;
        }
        AwsEcrRepositoryLifecyclePolicyDetails other = (AwsEcrRepositoryLifecyclePolicyDetails) obj;
        return Objects.equals(lifecyclePolicyText(), other.lifecyclePolicyText())
                && Objects.equals(registryId(), other.registryId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcrRepositoryLifecyclePolicyDetails").add("LifecyclePolicyText", lifecyclePolicyText())
                .add("RegistryId", registryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LifecyclePolicyText":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyText()));
        case "RegistryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcrRepositoryLifecyclePolicyDetails, T> g) {
        return obj -> g.apply((AwsEcrRepositoryLifecyclePolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcrRepositoryLifecyclePolicyDetails> {
        /**
         * <p>
         * The text of the lifecycle policy.
         * </p>
         * 
         * @param lifecyclePolicyText
         *        The text of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyText(String lifecyclePolicyText);

        /**
         * <p>
         * The Amazon Web Services account identifier that is associated with the registry that contains the repository.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account identifier that is associated with the registry that contains the
         *        repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);
    }

    static final class BuilderImpl implements Builder {
        private String lifecyclePolicyText;

        private String registryId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcrRepositoryLifecyclePolicyDetails model) {
            lifecyclePolicyText(model.lifecyclePolicyText);
            registryId(model.registryId);
        }

        public final String getLifecyclePolicyText() {
            return lifecyclePolicyText;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        @Override
        @Transient
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        @Transient
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @Override
        public AwsEcrRepositoryLifecyclePolicyDetails build() {
            return new AwsEcrRepositoryLifecyclePolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
