/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the deployment controller type that the service uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceDeploymentControllerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceDeploymentControllerDetails.Builder, AwsEcsServiceDeploymentControllerDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEcsServiceDeploymentControllerDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private AwsEcsServiceDeploymentControllerDetails(BuilderImpl builder) {
        this.type = builder.type;
    }

    /**
     * <p>
     * The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container with
     * the latest version.
     * </p>
     * <p>
     * The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is powered by
     * CodeDeploy. This deployment model a new deployment of a service can be verified before production traffic is sent
     * to it.
     * </p>
     * <p>
     * The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller for
     * full control over the deployment process for an Amazon ECS service.
     * </p>
     * <p>
     * Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
     * </p>
     * 
     * @return The rolling update (<code>ECS</code>) deployment type replaces the current running version of the
     *         container with the latest version.</p>
     *         <p>
     *         The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is
     *         powered by CodeDeploy. This deployment model a new deployment of a service can be verified before
     *         production traffic is sent to it.
     *         </p>
     *         <p>
     *         The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment
     *         controller for full control over the deployment process for an Amazon ECS service.
     *         </p>
     *         <p>
     *         Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceDeploymentControllerDetails)) {
            return false;
        }
        AwsEcsServiceDeploymentControllerDetails other = (AwsEcsServiceDeploymentControllerDetails) obj;
        return Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceDeploymentControllerDetails").add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceDeploymentControllerDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceDeploymentControllerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceDeploymentControllerDetails> {
        /**
         * <p>
         * The rolling update (<code>ECS</code>) deployment type replaces the current running version of the container
         * with the latest version.
         * </p>
         * <p>
         * The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is
         * powered by CodeDeploy. This deployment model a new deployment of a service can be verified before production
         * traffic is sent to it.
         * </p>
         * <p>
         * The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment controller
         * for full control over the deployment process for an Amazon ECS service.
         * </p>
         * <p>
         * Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
         * </p>
         * 
         * @param type
         *        The rolling update (<code>ECS</code>) deployment type replaces the current running version of the
         *        container with the latest version.</p>
         *        <p>
         *        The blue/green (<code>CODE_DEPLOY</code>) deployment type uses the blue/green deployment model that is
         *        powered by CodeDeploy. This deployment model a new deployment of a service can be verified before
         *        production traffic is sent to it.
         *        </p>
         *        <p>
         *        The external (<code>EXTERNAL</code>) deployment type allows the use of any third-party deployment
         *        controller for full control over the deployment process for an Amazon ECS service.
         *        </p>
         *        <p>
         *        Valid values: <code>ECS</code> | <code>CODE_DEPLOY</code> | <code>EXTERNAL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceDeploymentControllerDetails model) {
            type(model.type);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsEcsServiceDeploymentControllerDetails build() {
            return new AwsEcsServiceDeploymentControllerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
