/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The private repository authentication credentials to use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails> {
    private static final SdkField<String> CREDENTIALS_PARAMETER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CredentialsParameter")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails::credentialsParameter))
            .setter(setter(Builder::credentialsParameter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CredentialsParameter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_PARAMETER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String credentialsParameter;

    private AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(BuilderImpl builder) {
        this.credentialsParameter = builder.credentialsParameter;
    }

    /**
     * <p>
     * The ARN of the secret that contains the private repository credentials.
     * </p>
     * 
     * @return The ARN of the secret that contains the private repository credentials.
     */
    public final String credentialsParameter() {
        return credentialsParameter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(credentialsParameter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails other = (AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) obj;
        return Objects.equals(credentialsParameter(), other.credentialsParameter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails")
                .add("CredentialsParameter", credentialsParameter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CredentialsParameter":
            return Optional.ofNullable(clazz.cast(credentialsParameter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails> {
        /**
         * <p>
         * The ARN of the secret that contains the private repository credentials.
         * </p>
         * 
         * @param credentialsParameter
         *        The ARN of the secret that contains the private repository credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsParameter(String credentialsParameter);
    }

    static final class BuilderImpl implements Builder {
        private String credentialsParameter;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails model) {
            credentialsParameter(model.credentialsParameter);
        }

        public final String getCredentialsParameter() {
            return credentialsParameter;
        }

        public final void setCredentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
        }

        @Override
        @Transient
        public final Builder credentialsParameter(String credentialsParameter) {
            this.credentialsParameter = credentialsParameter;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
