/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data volume to mount from another container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> {
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReadOnly").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails::readOnly))
            .setter(setter(Builder::readOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()).build();

    private static final SdkField<String> SOURCE_CONTAINER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceContainer")
            .getter(getter(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails::sourceContainer))
            .setter(setter(Builder::sourceContainer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceContainer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_ONLY_FIELD,
            SOURCE_CONTAINER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean readOnly;

    private final String sourceContainer;

    private AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(BuilderImpl builder) {
        this.readOnly = builder.readOnly;
        this.sourceContainer = builder.sourceContainer;
    }

    /**
     * <p>
     * Whether the container has read-only access to the volume.
     * </p>
     * 
     * @return Whether the container has read-only access to the volume.
     */
    public final Boolean readOnly() {
        return readOnly;
    }

    /**
     * <p>
     * The name of another container within the same task definition from which to mount volumes.
     * </p>
     * 
     * @return The name of another container within the same task definition from which to mount volumes.
     */
    public final String sourceContainer() {
        return sourceContainer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContainer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails other = (AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) obj;
        return Objects.equals(readOnly(), other.readOnly()) && Objects.equals(sourceContainer(), other.sourceContainer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails").add("ReadOnly", readOnly())
                .add("SourceContainer", sourceContainer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReadOnly":
            return Optional.ofNullable(clazz.cast(readOnly()));
        case "SourceContainer":
            return Optional.ofNullable(clazz.cast(sourceContainer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails> {
        /**
         * <p>
         * Whether the container has read-only access to the volume.
         * </p>
         * 
         * @param readOnly
         *        Whether the container has read-only access to the volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOnly(Boolean readOnly);

        /**
         * <p>
         * The name of another container within the same task definition from which to mount volumes.
         * </p>
         * 
         * @param sourceContainer
         *        The name of another container within the same task definition from which to mount volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContainer(String sourceContainer);
    }

    static final class BuilderImpl implements Builder {
        private Boolean readOnly;

        private String sourceContainer;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails model) {
            readOnly(model.readOnly);
            sourceContainer(model.sourceContainer);
        }

        public final Boolean getReadOnly() {
            return readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        @Transient
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final String getSourceContainer() {
            return sourceContainer;
        }

        public final void setSourceContainer(String sourceContainer) {
            this.sourceContainer = sourceContainer;
        }

        @Override
        @Transient
        public final Builder sourceContainer(String sourceContainer) {
            this.sourceContainer = sourceContainer;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
