/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Elasticsearch domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticsearchDomainDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElasticsearchDomainDetails.Builder, AwsElasticsearchDomainDetails> {
    private static final SdkField<String> ACCESS_POLICIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPolicies").getter(getter(AwsElasticsearchDomainDetails::accessPolicies))
            .setter(setter(Builder::accessPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final SdkField<AwsElasticsearchDomainDomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainDomainEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(AwsElasticsearchDomainDetails::domainEndpointOptions)).setter(setter(Builder::domainEndpointOptions))
            .constructor(AwsElasticsearchDomainDomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(AwsElasticsearchDomainDetails::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsElasticsearchDomainDetails::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(AwsElasticsearchDomainDetails::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<Map<String, String>> ENDPOINTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Endpoints")
            .getter(getter(AwsElasticsearchDomainDetails::endpoints))
            .setter(setter(Builder::endpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoints").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticsearchVersion").getter(getter(AwsElasticsearchDomainDetails::elasticsearchVersion))
            .setter(setter(Builder::elasticsearchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchVersion").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainElasticsearchClusterConfigDetails> ELASTICSEARCH_CLUSTER_CONFIG_FIELD = SdkField
            .<AwsElasticsearchDomainElasticsearchClusterConfigDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ElasticsearchClusterConfig")
            .getter(getter(AwsElasticsearchDomainDetails::elasticsearchClusterConfig))
            .setter(setter(Builder::elasticsearchClusterConfig))
            .constructor(AwsElasticsearchDomainElasticsearchClusterConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticsearchClusterConfig").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainEncryptionAtRestOptions> ENCRYPTION_AT_REST_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainEncryptionAtRestOptions> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionAtRestOptions").getter(getter(AwsElasticsearchDomainDetails::encryptionAtRestOptions))
            .setter(setter(Builder::encryptionAtRestOptions)).constructor(AwsElasticsearchDomainEncryptionAtRestOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRestOptions").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainLogPublishingOptions> LOG_PUBLISHING_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainLogPublishingOptions> builder(MarshallingType.SDK_POJO).memberName("LogPublishingOptions")
            .getter(getter(AwsElasticsearchDomainDetails::logPublishingOptions)).setter(setter(Builder::logPublishingOptions))
            .constructor(AwsElasticsearchDomainLogPublishingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingOptions").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainNodeToNodeEncryptionOptions> NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainNodeToNodeEncryptionOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NodeToNodeEncryptionOptions")
            .getter(getter(AwsElasticsearchDomainDetails::nodeToNodeEncryptionOptions))
            .setter(setter(Builder::nodeToNodeEncryptionOptions))
            .constructor(AwsElasticsearchDomainNodeToNodeEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeToNodeEncryptionOptions")
                    .build()).build();

    private static final SdkField<AwsElasticsearchDomainServiceSoftwareOptions> SERVICE_SOFTWARE_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainServiceSoftwareOptions> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceSoftwareOptions").getter(getter(AwsElasticsearchDomainDetails::serviceSoftwareOptions))
            .setter(setter(Builder::serviceSoftwareOptions)).constructor(AwsElasticsearchDomainServiceSoftwareOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSoftwareOptions").build())
            .build();

    private static final SdkField<AwsElasticsearchDomainVPCOptions> VPC_OPTIONS_FIELD = SdkField
            .<AwsElasticsearchDomainVPCOptions> builder(MarshallingType.SDK_POJO).memberName("VPCOptions")
            .getter(getter(AwsElasticsearchDomainDetails::vpcOptions)).setter(setter(Builder::vpcOptions))
            .constructor(AwsElasticsearchDomainVPCOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD,
            DOMAIN_ENDPOINT_OPTIONS_FIELD, DOMAIN_ID_FIELD, DOMAIN_NAME_FIELD, ENDPOINT_FIELD, ENDPOINTS_FIELD,
            ELASTICSEARCH_VERSION_FIELD, ELASTICSEARCH_CLUSTER_CONFIG_FIELD, ENCRYPTION_AT_REST_OPTIONS_FIELD,
            LOG_PUBLISHING_OPTIONS_FIELD, NODE_TO_NODE_ENCRYPTION_OPTIONS_FIELD, SERVICE_SOFTWARE_OPTIONS_FIELD,
            VPC_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessPolicies;

    private final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;

    private final String domainId;

    private final String domainName;

    private final String endpoint;

    private final Map<String, String> endpoints;

    private final String elasticsearchVersion;

    private final AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig;

    private final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;

    private final AwsElasticsearchDomainLogPublishingOptions logPublishingOptions;

    private final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

    private final AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions;

    private final AwsElasticsearchDomainVPCOptions vpcOptions;

    private AwsElasticsearchDomainDetails(BuilderImpl builder) {
        this.accessPolicies = builder.accessPolicies;
        this.domainEndpointOptions = builder.domainEndpointOptions;
        this.domainId = builder.domainId;
        this.domainName = builder.domainName;
        this.endpoint = builder.endpoint;
        this.endpoints = builder.endpoints;
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.elasticsearchClusterConfig = builder.elasticsearchClusterConfig;
        this.encryptionAtRestOptions = builder.encryptionAtRestOptions;
        this.logPublishingOptions = builder.logPublishingOptions;
        this.nodeToNodeEncryptionOptions = builder.nodeToNodeEncryptionOptions;
        this.serviceSoftwareOptions = builder.serviceSoftwareOptions;
        this.vpcOptions = builder.vpcOptions;
    }

    /**
     * <p>
     * IAM policy document specifying the access policies for the new Elasticsearch domain.
     * </p>
     * 
     * @return IAM policy document specifying the access policies for the new Elasticsearch domain.
     */
    public final String accessPolicies() {
        return accessPolicies;
    }

    /**
     * <p>
     * Additional options for the domain endpoint.
     * </p>
     * 
     * @return Additional options for the domain endpoint.
     */
    public final AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions() {
        return domainEndpointOptions;
    }

    /**
     * <p>
     * Unique identifier for an Elasticsearch domain.
     * </p>
     * 
     * @return Unique identifier for an Elasticsearch domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * Name of an Elasticsearch domain.
     * </p>
     * <p>
     * Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.
     * </p>
     * <p>
     * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
     * </p>
     * <p>
     * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
     * </p>
     * 
     * @return Name of an Elasticsearch domain.</p>
     *         <p>
     *         Domain names are unique across all domains owned by the same account within an Amazon Web Services
     *         Region.
     *         </p>
     *         <p>
     *         Domain names must start with a lowercase letter and must be between 3 and 28 characters.
     *         </p>
     *         <p>
     *         Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch domain.
     * </p>
     * <p>
     * The endpoint is a service URL.
     * </p>
     * 
     * @return Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch
     *         domain.</p>
     *         <p>
     *         The endpoint is a service URL.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the Endpoints property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEndpoints() {
        return endpoints != null && !(endpoints instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEndpoints} method.
     * </p>
     * 
     * @return The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
     */
    public final Map<String, String> endpoints() {
        return endpoints;
    }

    /**
     * <p>
     * OpenSearch version.
     * </p>
     * 
     * @return OpenSearch version.
     */
    public final String elasticsearchVersion() {
        return elasticsearchVersion;
    }

    /**
     * <p>
     * Information about an OpenSearch cluster configuration.
     * </p>
     * 
     * @return Information about an OpenSearch cluster configuration.
     */
    public final AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig() {
        return elasticsearchClusterConfig;
    }

    /**
     * <p>
     * Details about the configuration for encryption at rest.
     * </p>
     * 
     * @return Details about the configuration for encryption at rest.
     */
    public final AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions() {
        return encryptionAtRestOptions;
    }

    /**
     * <p>
     * Configures the CloudWatch Logs to publish for the Elasticsearch domain.
     * </p>
     * 
     * @return Configures the CloudWatch Logs to publish for the Elasticsearch domain.
     */
    public final AwsElasticsearchDomainLogPublishingOptions logPublishingOptions() {
        return logPublishingOptions;
    }

    /**
     * <p>
     * Details about the configuration for node-to-node encryption.
     * </p>
     * 
     * @return Details about the configuration for node-to-node encryption.
     */
    public final AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions() {
        return nodeToNodeEncryptionOptions;
    }

    /**
     * <p>
     * Information about the status of a domain relative to the latest service software.
     * </p>
     * 
     * @return Information about the status of a domain relative to the latest service software.
     */
    public final AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions() {
        return serviceSoftwareOptions;
    }

    /**
     * <p>
     * Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.
     * </p>
     * 
     * @return Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.
     */
    public final AwsElasticsearchDomainVPCOptions vpcOptions() {
        return vpcOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(hasEndpoints() ? endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchClusterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRestOptions());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(nodeToNodeEncryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSoftwareOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainDetails)) {
            return false;
        }
        AwsElasticsearchDomainDetails other = (AwsElasticsearchDomainDetails) obj;
        return Objects.equals(accessPolicies(), other.accessPolicies())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions())
                && Objects.equals(domainId(), other.domainId()) && Objects.equals(domainName(), other.domainName())
                && Objects.equals(endpoint(), other.endpoint()) && hasEndpoints() == other.hasEndpoints()
                && Objects.equals(endpoints(), other.endpoints())
                && Objects.equals(elasticsearchVersion(), other.elasticsearchVersion())
                && Objects.equals(elasticsearchClusterConfig(), other.elasticsearchClusterConfig())
                && Objects.equals(encryptionAtRestOptions(), other.encryptionAtRestOptions())
                && Objects.equals(logPublishingOptions(), other.logPublishingOptions())
                && Objects.equals(nodeToNodeEncryptionOptions(), other.nodeToNodeEncryptionOptions())
                && Objects.equals(serviceSoftwareOptions(), other.serviceSoftwareOptions())
                && Objects.equals(vpcOptions(), other.vpcOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticsearchDomainDetails").add("AccessPolicies", accessPolicies())
                .add("DomainEndpointOptions", domainEndpointOptions()).add("DomainId", domainId())
                .add("DomainName", domainName()).add("Endpoint", endpoint())
                .add("Endpoints", hasEndpoints() ? endpoints() : null).add("ElasticsearchVersion", elasticsearchVersion())
                .add("ElasticsearchClusterConfig", elasticsearchClusterConfig())
                .add("EncryptionAtRestOptions", encryptionAtRestOptions()).add("LogPublishingOptions", logPublishingOptions())
                .add("NodeToNodeEncryptionOptions", nodeToNodeEncryptionOptions())
                .add("ServiceSoftwareOptions", serviceSoftwareOptions()).add("VPCOptions", vpcOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Endpoints":
            return Optional.ofNullable(clazz.cast(endpoints()));
        case "ElasticsearchVersion":
            return Optional.ofNullable(clazz.cast(elasticsearchVersion()));
        case "ElasticsearchClusterConfig":
            return Optional.ofNullable(clazz.cast(elasticsearchClusterConfig()));
        case "EncryptionAtRestOptions":
            return Optional.ofNullable(clazz.cast(encryptionAtRestOptions()));
        case "LogPublishingOptions":
            return Optional.ofNullable(clazz.cast(logPublishingOptions()));
        case "NodeToNodeEncryptionOptions":
            return Optional.ofNullable(clazz.cast(nodeToNodeEncryptionOptions()));
        case "ServiceSoftwareOptions":
            return Optional.ofNullable(clazz.cast(serviceSoftwareOptions()));
        case "VPCOptions":
            return Optional.ofNullable(clazz.cast(vpcOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainDetails, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticsearchDomainDetails> {
        /**
         * <p>
         * IAM policy document specifying the access policies for the new Elasticsearch domain.
         * </p>
         * 
         * @param accessPolicies
         *        IAM policy document specifying the access policies for the new Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(String accessPolicies);

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Additional options for the domain endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions);

        /**
         * <p>
         * Additional options for the domain endpoint.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainDomainEndpointOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainDomainEndpointOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainDomainEndpointOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainDomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions)
         */
        default Builder domainEndpointOptions(Consumer<AwsElasticsearchDomainDomainEndpointOptions.Builder> domainEndpointOptions) {
            return domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.builder()
                    .applyMutation(domainEndpointOptions).build());
        }

        /**
         * <p>
         * Unique identifier for an Elasticsearch domain.
         * </p>
         * 
         * @param domainId
         *        Unique identifier for an Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * Name of an Elasticsearch domain.
         * </p>
         * <p>
         * Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.
         * </p>
         * <p>
         * Domain names must start with a lowercase letter and must be between 3 and 28 characters.
         * </p>
         * <p>
         * Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
         * </p>
         * 
         * @param domainName
         *        Name of an Elasticsearch domain.</p>
         *        <p>
         *        Domain names are unique across all domains owned by the same account within an Amazon Web Services
         *        Region.
         *        </p>
         *        <p>
         *        Domain names must start with a lowercase letter and must be between 3 and 28 characters.
         *        </p>
         *        <p>
         *        Valid characters are a-z (lowercase only), 0-9, and – (hyphen).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch domain.
         * </p>
         * <p>
         * The endpoint is a service URL.
         * </p>
         * 
         * @param endpoint
         *        Domain-specific endpoint used to submit index, search, and data upload requests to an Elasticsearch
         *        domain.</p>
         *        <p>
         *        The endpoint is a service URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
         * </p>
         * 
         * @param endpoints
         *        The key-value pair that exists if the Elasticsearch domain uses VPC endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoints(Map<String, String> endpoints);

        /**
         * <p>
         * OpenSearch version.
         * </p>
         * 
         * @param elasticsearchVersion
         *        OpenSearch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersion(String elasticsearchVersion);

        /**
         * <p>
         * Information about an OpenSearch cluster configuration.
         * </p>
         * 
         * @param elasticsearchClusterConfig
         *        Information about an OpenSearch cluster configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig);

        /**
         * <p>
         * Information about an OpenSearch cluster configuration.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder} avoiding the need to create one
         * manually via {@link AwsElasticsearchDomainElasticsearchClusterConfigDetails#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails)}.
         * 
         * @param elasticsearchClusterConfig
         *        a consumer that will call methods on
         *        {@link AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails)
         */
        default Builder elasticsearchClusterConfig(
                Consumer<AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder> elasticsearchClusterConfig) {
            return elasticsearchClusterConfig(AwsElasticsearchDomainElasticsearchClusterConfigDetails.builder()
                    .applyMutation(elasticsearchClusterConfig).build());
        }

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * 
         * @param encryptionAtRestOptions
         *        Details about the configuration for encryption at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions);

        /**
         * <p>
         * Details about the configuration for encryption at rest.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainEncryptionAtRestOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions)}.
         * 
         * @param encryptionAtRestOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainEncryptionAtRestOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions)
         */
        default Builder encryptionAtRestOptions(
                Consumer<AwsElasticsearchDomainEncryptionAtRestOptions.Builder> encryptionAtRestOptions) {
            return encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions.builder()
                    .applyMutation(encryptionAtRestOptions).build());
        }

        /**
         * <p>
         * Configures the CloudWatch Logs to publish for the Elasticsearch domain.
         * </p>
         * 
         * @param logPublishingOptions
         *        Configures the CloudWatch Logs to publish for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions logPublishingOptions);

        /**
         * <p>
         * Configures the CloudWatch Logs to publish for the Elasticsearch domain.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainLogPublishingOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainLogPublishingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainLogPublishingOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions)}.
         * 
         * @param logPublishingOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainLogPublishingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions)
         */
        default Builder logPublishingOptions(Consumer<AwsElasticsearchDomainLogPublishingOptions.Builder> logPublishingOptions) {
            return logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions.builder().applyMutation(logPublishingOptions)
                    .build());
        }

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * 
         * @param nodeToNodeEncryptionOptions
         *        Details about the configuration for node-to-node encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions);

        /**
         * <p>
         * Details about the configuration for node-to-node encryption.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder} avoiding the need to create one manually
         * via {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions)}.
         * 
         * @param nodeToNodeEncryptionOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions)
         */
        default Builder nodeToNodeEncryptionOptions(
                Consumer<AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder> nodeToNodeEncryptionOptions) {
            return nodeToNodeEncryptionOptions(AwsElasticsearchDomainNodeToNodeEncryptionOptions.builder()
                    .applyMutation(nodeToNodeEncryptionOptions).build());
        }

        /**
         * <p>
         * Information about the status of a domain relative to the latest service software.
         * </p>
         * 
         * @param serviceSoftwareOptions
         *        Information about the status of a domain relative to the latest service software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions);

        /**
         * <p>
         * Information about the status of a domain relative to the latest service software.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsElasticsearchDomainServiceSoftwareOptions.Builder} avoiding the need to create one manually via
         * {@link AwsElasticsearchDomainServiceSoftwareOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainServiceSoftwareOptions.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions)}.
         * 
         * @param serviceSoftwareOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainServiceSoftwareOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions)
         */
        default Builder serviceSoftwareOptions(
                Consumer<AwsElasticsearchDomainServiceSoftwareOptions.Builder> serviceSoftwareOptions) {
            return serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions.builder()
                    .applyMutation(serviceSoftwareOptions).build());
        }

        /**
         * <p>
         * Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * 
         * @param vpcOptions
         *        Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions);

        /**
         * <p>
         * Information that OpenSearch derives based on <code>VPCOptions</code> for the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsElasticsearchDomainVPCOptions.Builder}
         * avoiding the need to create one manually via {@link AwsElasticsearchDomainVPCOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsElasticsearchDomainVPCOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcOptions(AwsElasticsearchDomainVPCOptions)}.
         * 
         * @param vpcOptions
         *        a consumer that will call methods on {@link AwsElasticsearchDomainVPCOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcOptions(AwsElasticsearchDomainVPCOptions)
         */
        default Builder vpcOptions(Consumer<AwsElasticsearchDomainVPCOptions.Builder> vpcOptions) {
            return vpcOptions(AwsElasticsearchDomainVPCOptions.builder().applyMutation(vpcOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessPolicies;

        private AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions;

        private String domainId;

        private String domainName;

        private String endpoint;

        private Map<String, String> endpoints = DefaultSdkAutoConstructMap.getInstance();

        private String elasticsearchVersion;

        private AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig;

        private AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions;

        private AwsElasticsearchDomainLogPublishingOptions logPublishingOptions;

        private AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;

        private AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions;

        private AwsElasticsearchDomainVPCOptions vpcOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainDetails model) {
            accessPolicies(model.accessPolicies);
            domainEndpointOptions(model.domainEndpointOptions);
            domainId(model.domainId);
            domainName(model.domainName);
            endpoint(model.endpoint);
            endpoints(model.endpoints);
            elasticsearchVersion(model.elasticsearchVersion);
            elasticsearchClusterConfig(model.elasticsearchClusterConfig);
            encryptionAtRestOptions(model.encryptionAtRestOptions);
            logPublishingOptions(model.logPublishingOptions);
            nodeToNodeEncryptionOptions(model.nodeToNodeEncryptionOptions);
            serviceSoftwareOptions(model.serviceSoftwareOptions);
            vpcOptions(model.vpcOptions);
        }

        public final String getAccessPolicies() {
            return accessPolicies;
        }

        public final void setAccessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
        }

        @Override
        @Transient
        public final Builder accessPolicies(String accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final AwsElasticsearchDomainDomainEndpointOptions.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder domainEndpointOptions(AwsElasticsearchDomainDomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        @Transient
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Map<String, String> getEndpoints() {
            if (endpoints instanceof SdkAutoConstructMap) {
                return null;
            }
            return endpoints;
        }

        public final void setEndpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
        }

        @Override
        @Transient
        public final Builder endpoints(Map<String, String> endpoints) {
            this.endpoints = FieldMapCopier.copy(endpoints);
            return this;
        }

        public final String getElasticsearchVersion() {
            return elasticsearchVersion;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        @Override
        @Transient
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder getElasticsearchClusterConfig() {
            return elasticsearchClusterConfig != null ? elasticsearchClusterConfig.toBuilder() : null;
        }

        public final void setElasticsearchClusterConfig(
                AwsElasticsearchDomainElasticsearchClusterConfigDetails.BuilderImpl elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig != null ? elasticsearchClusterConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder elasticsearchClusterConfig(
                AwsElasticsearchDomainElasticsearchClusterConfigDetails elasticsearchClusterConfig) {
            this.elasticsearchClusterConfig = elasticsearchClusterConfig;
            return this;
        }

        public final AwsElasticsearchDomainEncryptionAtRestOptions.Builder getEncryptionAtRestOptions() {
            return encryptionAtRestOptions != null ? encryptionAtRestOptions.toBuilder() : null;
        }

        public final void setEncryptionAtRestOptions(
                AwsElasticsearchDomainEncryptionAtRestOptions.BuilderImpl encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions != null ? encryptionAtRestOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder encryptionAtRestOptions(AwsElasticsearchDomainEncryptionAtRestOptions encryptionAtRestOptions) {
            this.encryptionAtRestOptions = encryptionAtRestOptions;
            return this;
        }

        public final AwsElasticsearchDomainLogPublishingOptions.Builder getLogPublishingOptions() {
            return logPublishingOptions != null ? logPublishingOptions.toBuilder() : null;
        }

        public final void setLogPublishingOptions(AwsElasticsearchDomainLogPublishingOptions.BuilderImpl logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions != null ? logPublishingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder logPublishingOptions(AwsElasticsearchDomainLogPublishingOptions logPublishingOptions) {
            this.logPublishingOptions = logPublishingOptions;
            return this;
        }

        public final AwsElasticsearchDomainNodeToNodeEncryptionOptions.Builder getNodeToNodeEncryptionOptions() {
            return nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.toBuilder() : null;
        }

        public final void setNodeToNodeEncryptionOptions(
                AwsElasticsearchDomainNodeToNodeEncryptionOptions.BuilderImpl nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions != null ? nodeToNodeEncryptionOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder nodeToNodeEncryptionOptions(
                AwsElasticsearchDomainNodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
            this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
            return this;
        }

        public final AwsElasticsearchDomainServiceSoftwareOptions.Builder getServiceSoftwareOptions() {
            return serviceSoftwareOptions != null ? serviceSoftwareOptions.toBuilder() : null;
        }

        public final void setServiceSoftwareOptions(
                AwsElasticsearchDomainServiceSoftwareOptions.BuilderImpl serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions != null ? serviceSoftwareOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder serviceSoftwareOptions(AwsElasticsearchDomainServiceSoftwareOptions serviceSoftwareOptions) {
            this.serviceSoftwareOptions = serviceSoftwareOptions;
            return this;
        }

        public final AwsElasticsearchDomainVPCOptions.Builder getVpcOptions() {
            return vpcOptions != null ? vpcOptions.toBuilder() : null;
        }

        public final void setVpcOptions(AwsElasticsearchDomainVPCOptions.BuilderImpl vpcOptions) {
            this.vpcOptions = vpcOptions != null ? vpcOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcOptions(AwsElasticsearchDomainVPCOptions vpcOptions) {
            this.vpcOptions = vpcOptions;
            return this;
        }

        @Override
        public AwsElasticsearchDomainDetails build() {
            return new AwsElasticsearchDomainDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
