/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the security group for the load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerSourceSecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerSourceSecurityGroup.Builder, AwsElbLoadBalancerSourceSecurityGroup> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(AwsElbLoadBalancerSourceSecurityGroup::groupName))
            .setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> OWNER_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAlias").getter(getter(AwsElbLoadBalancerSourceSecurityGroup::ownerAlias))
            .setter(setter(Builder::ownerAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAlias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            OWNER_ALIAS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String ownerAlias;

    private AwsElbLoadBalancerSourceSecurityGroup(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.ownerAlias = builder.ownerAlias;
    }

    /**
     * <p>
     * The name of the security group.
     * </p>
     * 
     * @return The name of the security group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The owner of the security group.
     * </p>
     * 
     * @return The owner of the security group.
     */
    public final String ownerAlias() {
        return ownerAlias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAlias());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerSourceSecurityGroup)) {
            return false;
        }
        AwsElbLoadBalancerSourceSecurityGroup other = (AwsElbLoadBalancerSourceSecurityGroup) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(ownerAlias(), other.ownerAlias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerSourceSecurityGroup").add("GroupName", groupName())
                .add("OwnerAlias", ownerAlias()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "OwnerAlias":
            return Optional.ofNullable(clazz.cast(ownerAlias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerSourceSecurityGroup, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerSourceSecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerSourceSecurityGroup> {
        /**
         * <p>
         * The name of the security group.
         * </p>
         * 
         * @param groupName
         *        The name of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The owner of the security group.
         * </p>
         * 
         * @param ownerAlias
         *        The owner of the security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String ownerAlias;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerSourceSecurityGroup model) {
            groupName(model.groupName);
            ownerAlias(model.ownerAlias);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Transient
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        @Override
        @Transient
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        @Override
        public AwsElbLoadBalancerSourceSecurityGroup build() {
            return new AwsElbLoadBalancerSourceSecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
