/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a role associated with an instance profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamInstanceProfileRole implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamInstanceProfileRole.Builder, AwsIamInstanceProfileRole> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsIamInstanceProfileRole::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumeRolePolicyDocument").getter(getter(AwsIamInstanceProfileRole::assumeRolePolicyDocument))
            .setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamInstanceProfileRole::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamInstanceProfileRole::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoleId")
            .getter(getter(AwsIamInstanceProfileRole::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(AwsIamInstanceProfileRole::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ASSUME_ROLE_POLICY_DOCUMENT_FIELD, CREATE_DATE_FIELD, PATH_FIELD, ROLE_ID_FIELD, ROLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String assumeRolePolicyDocument;

    private final String createDate;

    private final String path;

    private final String roleId;

    private final String roleName;

    private AwsIamInstanceProfileRole(BuilderImpl builder) {
        this.arn = builder.arn;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.createDate = builder.createDate;
        this.path = builder.path;
        this.roleId = builder.roleId;
        this.roleName = builder.roleName;
    }

    /**
     * <p>
     * The ARN of the role.
     * </p>
     * 
     * @return The ARN of the role.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The policy that grants an entity permission to assume the role.
     * </p>
     * 
     * @return The policy that grants an entity permission to assume the role.
     */
    public final String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * <p>
     * Indicates when the role was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return Indicates when the role was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * <p>
     * The path to the role.
     * </p>
     * 
     * @return The path to the role.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The identifier of the role.
     * </p>
     * 
     * @return The identifier of the role.
     */
    public final String roleId() {
        return roleId;
    }

    /**
     * <p>
     * The name of the role.
     * </p>
     * 
     * @return The name of the role.
     */
    public final String roleName() {
        return roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamInstanceProfileRole)) {
            return false;
        }
        AwsIamInstanceProfileRole other = (AwsIamInstanceProfileRole) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(path(), other.path())
                && Objects.equals(roleId(), other.roleId()) && Objects.equals(roleName(), other.roleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamInstanceProfileRole").add("Arn", arn())
                .add("AssumeRolePolicyDocument", assumeRolePolicyDocument()).add("CreateDate", createDate()).add("Path", path())
                .add("RoleId", roleId()).add("RoleName", roleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamInstanceProfileRole, T> g) {
        return obj -> g.apply((AwsIamInstanceProfileRole) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamInstanceProfileRole> {
        /**
         * <p>
         * The ARN of the role.
         * </p>
         * 
         * @param arn
         *        The ARN of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The policy that grants an entity permission to assume the role.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The policy that grants an entity permission to assume the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * Indicates when the role was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param createDate
         *        Indicates when the role was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The path to the role.
         * </p>
         * 
         * @param path
         *        The path to the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The identifier of the role.
         * </p>
         * 
         * @param roleId
         *        The identifier of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);

        /**
         * <p>
         * The name of the role.
         * </p>
         * 
         * @param roleName
         *        The name of the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String assumeRolePolicyDocument;

        private String createDate;

        private String path;

        private String roleId;

        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamInstanceProfileRole model) {
            arn(model.arn);
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            createDate(model.createDate);
            path(model.path);
            roleId(model.roleId);
            roleName(model.roleName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        @Override
        @Transient
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final String getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getRoleId() {
            return roleId;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        @Transient
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final String getRoleName() {
            return roleName;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        @Transient
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        @Override
        public AwsIamInstanceProfileRole build() {
            return new AwsIamInstanceProfileRole(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
