/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Network Firewall firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsNetworkFirewallFirewallDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsNetworkFirewallFirewallDetails.Builder, AwsNetworkFirewallFirewallDetails> {
    private static final SdkField<Boolean> DELETE_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteProtection").getter(getter(AwsNetworkFirewallFirewallDetails::deleteProtection))
            .setter(setter(Builder::deleteProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteProtection").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsNetworkFirewallFirewallDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FIREWALL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallArn").getter(getter(AwsNetworkFirewallFirewallDetails::firewallArn))
            .setter(setter(Builder::firewallArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallArn").build()).build();

    private static final SdkField<String> FIREWALL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallId").getter(getter(AwsNetworkFirewallFirewallDetails::firewallId))
            .setter(setter(Builder::firewallId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallId").build()).build();

    private static final SdkField<String> FIREWALL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallName").getter(getter(AwsNetworkFirewallFirewallDetails::firewallName))
            .setter(setter(Builder::firewallName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallName").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(AwsNetworkFirewallFirewallDetails::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<Boolean> FIREWALL_POLICY_CHANGE_PROTECTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FirewallPolicyChangeProtection")
            .getter(getter(AwsNetworkFirewallFirewallDetails::firewallPolicyChangeProtection))
            .setter(setter(Builder::firewallPolicyChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyChangeProtection")
                    .build()).build();

    private static final SdkField<Boolean> SUBNET_CHANGE_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SubnetChangeProtection").getter(getter(AwsNetworkFirewallFirewallDetails::subnetChangeProtection))
            .setter(setter(Builder::subnetChangeProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetChangeProtection").build())
            .build();

    private static final SdkField<List<AwsNetworkFirewallFirewallSubnetMappingsDetails>> SUBNET_MAPPINGS_FIELD = SdkField
            .<List<AwsNetworkFirewallFirewallSubnetMappingsDetails>> builder(MarshallingType.LIST)
            .memberName("SubnetMappings")
            .getter(getter(AwsNetworkFirewallFirewallDetails::subnetMappings))
            .setter(setter(Builder::subnetMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsNetworkFirewallFirewallSubnetMappingsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsNetworkFirewallFirewallSubnetMappingsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsNetworkFirewallFirewallDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELETE_PROTECTION_FIELD,
            DESCRIPTION_FIELD, FIREWALL_ARN_FIELD, FIREWALL_ID_FIELD, FIREWALL_NAME_FIELD, FIREWALL_POLICY_ARN_FIELD,
            FIREWALL_POLICY_CHANGE_PROTECTION_FIELD, SUBNET_CHANGE_PROTECTION_FIELD, SUBNET_MAPPINGS_FIELD, VPC_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean deleteProtection;

    private final String description;

    private final String firewallArn;

    private final String firewallId;

    private final String firewallName;

    private final String firewallPolicyArn;

    private final Boolean firewallPolicyChangeProtection;

    private final Boolean subnetChangeProtection;

    private final List<AwsNetworkFirewallFirewallSubnetMappingsDetails> subnetMappings;

    private final String vpcId;

    private AwsNetworkFirewallFirewallDetails(BuilderImpl builder) {
        this.deleteProtection = builder.deleteProtection;
        this.description = builder.description;
        this.firewallArn = builder.firewallArn;
        this.firewallId = builder.firewallId;
        this.firewallName = builder.firewallName;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyChangeProtection = builder.firewallPolicyChangeProtection;
        this.subnetChangeProtection = builder.subnetChangeProtection;
        this.subnetMappings = builder.subnetMappings;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Whether the firewall is protected from deletion. If set to <code>true</code>, then the firewall cannot be
     * deleted.
     * </p>
     * 
     * @return Whether the firewall is protected from deletion. If set to <code>true</code>, then the firewall cannot be
     *         deleted.
     */
    public final Boolean deleteProtection() {
        return deleteProtection;
    }

    /**
     * <p>
     * A description of the firewall.
     * </p>
     * 
     * @return A description of the firewall.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ARN of the firewall.
     * </p>
     * 
     * @return The ARN of the firewall.
     */
    public final String firewallArn() {
        return firewallArn;
    }

    /**
     * <p>
     * The identifier of the firewall.
     * </p>
     * 
     * @return The identifier of the firewall.
     */
    public final String firewallId() {
        return firewallId;
    }

    /**
     * <p>
     * A descriptive name of the firewall.
     * </p>
     * 
     * @return A descriptive name of the firewall.
     */
    public final String firewallName() {
        return firewallName;
    }

    /**
     * <p>
     * The ARN of the firewall policy.
     * </p>
     * 
     * @return The ARN of the firewall policy.
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * Whether the firewall is protected from a change to the firewall policy. If set to <code>true</code>, you cannot
     * associate a different policy with the firewall.
     * </p>
     * 
     * @return Whether the firewall is protected from a change to the firewall policy. If set to <code>true</code>, you
     *         cannot associate a different policy with the firewall.
     */
    public final Boolean firewallPolicyChangeProtection() {
        return firewallPolicyChangeProtection;
    }

    /**
     * <p>
     * Whether the firewall is protected from a change to the subnet associations. If set to <code>true</code>, you
     * cannot map different subnets to the firewall.
     * </p>
     * 
     * @return Whether the firewall is protected from a change to the subnet associations. If set to <code>true</code>,
     *         you cannot map different subnets to the firewall.
     */
    public final Boolean subnetChangeProtection() {
        return subnetChangeProtection;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubnetMappings() {
        return subnetMappings != null && !(subnetMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
     * Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetMappings} method.
     * </p>
     * 
     * @return The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
     *         Availability Zone.
     */
    public final List<AwsNetworkFirewallFirewallSubnetMappingsDetails> subnetMappings() {
        return subnetMappings;
    }

    /**
     * <p>
     * The identifier of the VPC where the firewall is used.
     * </p>
     * 
     * @return The identifier of the VPC where the firewall is used.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deleteProtection());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(firewallArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallName());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(subnetChangeProtection());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetMappings() ? subnetMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsNetworkFirewallFirewallDetails)) {
            return false;
        }
        AwsNetworkFirewallFirewallDetails other = (AwsNetworkFirewallFirewallDetails) obj;
        return Objects.equals(deleteProtection(), other.deleteProtection()) && Objects.equals(description(), other.description())
                && Objects.equals(firewallArn(), other.firewallArn()) && Objects.equals(firewallId(), other.firewallId())
                && Objects.equals(firewallName(), other.firewallName())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn())
                && Objects.equals(firewallPolicyChangeProtection(), other.firewallPolicyChangeProtection())
                && Objects.equals(subnetChangeProtection(), other.subnetChangeProtection())
                && hasSubnetMappings() == other.hasSubnetMappings() && Objects.equals(subnetMappings(), other.subnetMappings())
                && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsNetworkFirewallFirewallDetails").add("DeleteProtection", deleteProtection())
                .add("Description", description()).add("FirewallArn", firewallArn()).add("FirewallId", firewallId())
                .add("FirewallName", firewallName()).add("FirewallPolicyArn", firewallPolicyArn())
                .add("FirewallPolicyChangeProtection", firewallPolicyChangeProtection())
                .add("SubnetChangeProtection", subnetChangeProtection())
                .add("SubnetMappings", hasSubnetMappings() ? subnetMappings() : null).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeleteProtection":
            return Optional.ofNullable(clazz.cast(deleteProtection()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FirewallArn":
            return Optional.ofNullable(clazz.cast(firewallArn()));
        case "FirewallId":
            return Optional.ofNullable(clazz.cast(firewallId()));
        case "FirewallName":
            return Optional.ofNullable(clazz.cast(firewallName()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "FirewallPolicyChangeProtection":
            return Optional.ofNullable(clazz.cast(firewallPolicyChangeProtection()));
        case "SubnetChangeProtection":
            return Optional.ofNullable(clazz.cast(subnetChangeProtection()));
        case "SubnetMappings":
            return Optional.ofNullable(clazz.cast(subnetMappings()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsNetworkFirewallFirewallDetails, T> g) {
        return obj -> g.apply((AwsNetworkFirewallFirewallDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsNetworkFirewallFirewallDetails> {
        /**
         * <p>
         * Whether the firewall is protected from deletion. If set to <code>true</code>, then the firewall cannot be
         * deleted.
         * </p>
         * 
         * @param deleteProtection
         *        Whether the firewall is protected from deletion. If set to <code>true</code>, then the firewall cannot
         *        be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteProtection(Boolean deleteProtection);

        /**
         * <p>
         * A description of the firewall.
         * </p>
         * 
         * @param description
         *        A description of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ARN of the firewall.
         * </p>
         * 
         * @param firewallArn
         *        The ARN of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallArn(String firewallArn);

        /**
         * <p>
         * The identifier of the firewall.
         * </p>
         * 
         * @param firewallId
         *        The identifier of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallId(String firewallId);

        /**
         * <p>
         * A descriptive name of the firewall.
         * </p>
         * 
         * @param firewallName
         *        A descriptive name of the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallName(String firewallName);

        /**
         * <p>
         * The ARN of the firewall policy.
         * </p>
         * 
         * @param firewallPolicyArn
         *        The ARN of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * Whether the firewall is protected from a change to the firewall policy. If set to <code>true</code>, you
         * cannot associate a different policy with the firewall.
         * </p>
         * 
         * @param firewallPolicyChangeProtection
         *        Whether the firewall is protected from a change to the firewall policy. If set to <code>true</code>,
         *        you cannot associate a different policy with the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection);

        /**
         * <p>
         * Whether the firewall is protected from a change to the subnet associations. If set to <code>true</code>, you
         * cannot map different subnets to the firewall.
         * </p>
         * 
         * @param subnetChangeProtection
         *        Whether the firewall is protected from a change to the subnet associations. If set to
         *        <code>true</code>, you cannot map different subnets to the firewall.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetChangeProtection(Boolean subnetChangeProtection);

        /**
         * <p>
         * The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
         * Availability Zone.
         * </p>
         * 
         * @param subnetMappings
         *        The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
         *        Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(Collection<AwsNetworkFirewallFirewallSubnetMappingsDetails> subnetMappings);

        /**
         * <p>
         * The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
         * Availability Zone.
         * </p>
         * 
         * @param subnetMappings
         *        The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
         *        Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetMappings(AwsNetworkFirewallFirewallSubnetMappingsDetails... subnetMappings);

        /**
         * <p>
         * The public subnets that Network Firewall uses for the firewall. Each subnet must belong to a different
         * Availability Zone.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <AwsNetworkFirewallFirewallSubnetMappingsDetails>.Builder} avoiding the need to create one manually via
         * {@link List<AwsNetworkFirewallFirewallSubnetMappingsDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <AwsNetworkFirewallFirewallSubnetMappingsDetails>.Builder#build()} is called immediately and its result is
         * passed to {@link #subnetMappings(List<AwsNetworkFirewallFirewallSubnetMappingsDetails>)}.
         * 
         * @param subnetMappings
         *        a consumer that will call methods on {@link List
         *        <AwsNetworkFirewallFirewallSubnetMappingsDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subnetMappings(List<AwsNetworkFirewallFirewallSubnetMappingsDetails>)
         */
        Builder subnetMappings(Consumer<AwsNetworkFirewallFirewallSubnetMappingsDetails.Builder>... subnetMappings);

        /**
         * <p>
         * The identifier of the VPC where the firewall is used.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC where the firewall is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean deleteProtection;

        private String description;

        private String firewallArn;

        private String firewallId;

        private String firewallName;

        private String firewallPolicyArn;

        private Boolean firewallPolicyChangeProtection;

        private Boolean subnetChangeProtection;

        private List<AwsNetworkFirewallFirewallSubnetMappingsDetails> subnetMappings = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsNetworkFirewallFirewallDetails model) {
            deleteProtection(model.deleteProtection);
            description(model.description);
            firewallArn(model.firewallArn);
            firewallId(model.firewallId);
            firewallName(model.firewallName);
            firewallPolicyArn(model.firewallPolicyArn);
            firewallPolicyChangeProtection(model.firewallPolicyChangeProtection);
            subnetChangeProtection(model.subnetChangeProtection);
            subnetMappings(model.subnetMappings);
            vpcId(model.vpcId);
        }

        public final Boolean getDeleteProtection() {
            return deleteProtection;
        }

        public final void setDeleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
        }

        @Override
        @Transient
        public final Builder deleteProtection(Boolean deleteProtection) {
            this.deleteProtection = deleteProtection;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFirewallArn() {
            return firewallArn;
        }

        public final void setFirewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
        }

        @Override
        @Transient
        public final Builder firewallArn(String firewallArn) {
            this.firewallArn = firewallArn;
            return this;
        }

        public final String getFirewallId() {
            return firewallId;
        }

        public final void setFirewallId(String firewallId) {
            this.firewallId = firewallId;
        }

        @Override
        @Transient
        public final Builder firewallId(String firewallId) {
            this.firewallId = firewallId;
            return this;
        }

        public final String getFirewallName() {
            return firewallName;
        }

        public final void setFirewallName(String firewallName) {
            this.firewallName = firewallName;
        }

        @Override
        @Transient
        public final Builder firewallName(String firewallName) {
            this.firewallName = firewallName;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        @Transient
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final Boolean getFirewallPolicyChangeProtection() {
            return firewallPolicyChangeProtection;
        }

        public final void setFirewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
        }

        @Override
        @Transient
        public final Builder firewallPolicyChangeProtection(Boolean firewallPolicyChangeProtection) {
            this.firewallPolicyChangeProtection = firewallPolicyChangeProtection;
            return this;
        }

        public final Boolean getSubnetChangeProtection() {
            return subnetChangeProtection;
        }

        public final void setSubnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
        }

        @Override
        @Transient
        public final Builder subnetChangeProtection(Boolean subnetChangeProtection) {
            this.subnetChangeProtection = subnetChangeProtection;
            return this;
        }

        public final List<AwsNetworkFirewallFirewallSubnetMappingsDetails.Builder> getSubnetMappings() {
            List<AwsNetworkFirewallFirewallSubnetMappingsDetails.Builder> result = AwsNetworkFirewallFirewallSubnetMappingsListCopier
                    .copyToBuilder(this.subnetMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnetMappings(Collection<AwsNetworkFirewallFirewallSubnetMappingsDetails.BuilderImpl> subnetMappings) {
            this.subnetMappings = AwsNetworkFirewallFirewallSubnetMappingsListCopier.copyFromBuilder(subnetMappings);
        }

        @Override
        @Transient
        public final Builder subnetMappings(Collection<AwsNetworkFirewallFirewallSubnetMappingsDetails> subnetMappings) {
            this.subnetMappings = AwsNetworkFirewallFirewallSubnetMappingsListCopier.copy(subnetMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(AwsNetworkFirewallFirewallSubnetMappingsDetails... subnetMappings) {
            subnetMappings(Arrays.asList(subnetMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetMappings(Consumer<AwsNetworkFirewallFirewallSubnetMappingsDetails.Builder>... subnetMappings) {
            subnetMappings(Stream.of(subnetMappings)
                    .map(c -> AwsNetworkFirewallFirewallSubnetMappingsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public AwsNetworkFirewallFirewallDetails build() {
            return new AwsNetworkFirewallFirewallDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
