/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a firewall policy. A firewall policy defines the behavior of a network firewall.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsNetworkFirewallFirewallPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsNetworkFirewallFirewallPolicyDetails.Builder, AwsNetworkFirewallFirewallPolicyDetails> {
    private static final SdkField<FirewallPolicyDetails> FIREWALL_POLICY_FIELD = SdkField
            .<FirewallPolicyDetails> builder(MarshallingType.SDK_POJO).memberName("FirewallPolicy")
            .getter(getter(AwsNetworkFirewallFirewallPolicyDetails::firewallPolicy)).setter(setter(Builder::firewallPolicy))
            .constructor(FirewallPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicy").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyArn").getter(getter(AwsNetworkFirewallFirewallPolicyDetails::firewallPolicyArn))
            .setter(setter(Builder::firewallPolicyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyArn").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyId").getter(getter(AwsNetworkFirewallFirewallPolicyDetails::firewallPolicyId))
            .setter(setter(Builder::firewallPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyId").build()).build();

    private static final SdkField<String> FIREWALL_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirewallPolicyName").getter(getter(AwsNetworkFirewallFirewallPolicyDetails::firewallPolicyName))
            .setter(setter(Builder::firewallPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirewallPolicyName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsNetworkFirewallFirewallPolicyDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_POLICY_FIELD,
            FIREWALL_POLICY_ARN_FIELD, FIREWALL_POLICY_ID_FIELD, FIREWALL_POLICY_NAME_FIELD, DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FirewallPolicyDetails firewallPolicy;

    private final String firewallPolicyArn;

    private final String firewallPolicyId;

    private final String firewallPolicyName;

    private final String description;

    private AwsNetworkFirewallFirewallPolicyDetails(BuilderImpl builder) {
        this.firewallPolicy = builder.firewallPolicy;
        this.firewallPolicyArn = builder.firewallPolicyArn;
        this.firewallPolicyId = builder.firewallPolicyId;
        this.firewallPolicyName = builder.firewallPolicyName;
        this.description = builder.description;
    }

    /**
     * <p>
     * The firewall policy configuration.
     * </p>
     * 
     * @return The firewall policy configuration.
     */
    public final FirewallPolicyDetails firewallPolicy() {
        return firewallPolicy;
    }

    /**
     * <p>
     * The ARN of the firewall policy.
     * </p>
     * 
     * @return The ARN of the firewall policy.
     */
    public final String firewallPolicyArn() {
        return firewallPolicyArn;
    }

    /**
     * <p>
     * The identifier of the firewall policy.
     * </p>
     * 
     * @return The identifier of the firewall policy.
     */
    public final String firewallPolicyId() {
        return firewallPolicyId;
    }

    /**
     * <p>
     * The name of the firewall policy.
     * </p>
     * 
     * @return The name of the firewall policy.
     */
    public final String firewallPolicyName() {
        return firewallPolicyName;
    }

    /**
     * <p>
     * A description of the firewall policy.
     * </p>
     * 
     * @return A description of the firewall policy.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(firewallPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsNetworkFirewallFirewallPolicyDetails)) {
            return false;
        }
        AwsNetworkFirewallFirewallPolicyDetails other = (AwsNetworkFirewallFirewallPolicyDetails) obj;
        return Objects.equals(firewallPolicy(), other.firewallPolicy())
                && Objects.equals(firewallPolicyArn(), other.firewallPolicyArn())
                && Objects.equals(firewallPolicyId(), other.firewallPolicyId())
                && Objects.equals(firewallPolicyName(), other.firewallPolicyName())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsNetworkFirewallFirewallPolicyDetails").add("FirewallPolicy", firewallPolicy())
                .add("FirewallPolicyArn", firewallPolicyArn()).add("FirewallPolicyId", firewallPolicyId())
                .add("FirewallPolicyName", firewallPolicyName()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FirewallPolicy":
            return Optional.ofNullable(clazz.cast(firewallPolicy()));
        case "FirewallPolicyArn":
            return Optional.ofNullable(clazz.cast(firewallPolicyArn()));
        case "FirewallPolicyId":
            return Optional.ofNullable(clazz.cast(firewallPolicyId()));
        case "FirewallPolicyName":
            return Optional.ofNullable(clazz.cast(firewallPolicyName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsNetworkFirewallFirewallPolicyDetails, T> g) {
        return obj -> g.apply((AwsNetworkFirewallFirewallPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsNetworkFirewallFirewallPolicyDetails> {
        /**
         * <p>
         * The firewall policy configuration.
         * </p>
         * 
         * @param firewallPolicy
         *        The firewall policy configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicy(FirewallPolicyDetails firewallPolicy);

        /**
         * <p>
         * The firewall policy configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link FirewallPolicyDetails.Builder} avoiding the need
         * to create one manually via {@link FirewallPolicyDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirewallPolicyDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #firewallPolicy(FirewallPolicyDetails)}.
         * 
         * @param firewallPolicy
         *        a consumer that will call methods on {@link FirewallPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallPolicy(FirewallPolicyDetails)
         */
        default Builder firewallPolicy(Consumer<FirewallPolicyDetails.Builder> firewallPolicy) {
            return firewallPolicy(FirewallPolicyDetails.builder().applyMutation(firewallPolicy).build());
        }

        /**
         * <p>
         * The ARN of the firewall policy.
         * </p>
         * 
         * @param firewallPolicyArn
         *        The ARN of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyArn(String firewallPolicyArn);

        /**
         * <p>
         * The identifier of the firewall policy.
         * </p>
         * 
         * @param firewallPolicyId
         *        The identifier of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyId(String firewallPolicyId);

        /**
         * <p>
         * The name of the firewall policy.
         * </p>
         * 
         * @param firewallPolicyName
         *        The name of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallPolicyName(String firewallPolicyName);

        /**
         * <p>
         * A description of the firewall policy.
         * </p>
         * 
         * @param description
         *        A description of the firewall policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private FirewallPolicyDetails firewallPolicy;

        private String firewallPolicyArn;

        private String firewallPolicyId;

        private String firewallPolicyName;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsNetworkFirewallFirewallPolicyDetails model) {
            firewallPolicy(model.firewallPolicy);
            firewallPolicyArn(model.firewallPolicyArn);
            firewallPolicyId(model.firewallPolicyId);
            firewallPolicyName(model.firewallPolicyName);
            description(model.description);
        }

        public final FirewallPolicyDetails.Builder getFirewallPolicy() {
            return firewallPolicy != null ? firewallPolicy.toBuilder() : null;
        }

        public final void setFirewallPolicy(FirewallPolicyDetails.BuilderImpl firewallPolicy) {
            this.firewallPolicy = firewallPolicy != null ? firewallPolicy.build() : null;
        }

        @Override
        @Transient
        public final Builder firewallPolicy(FirewallPolicyDetails firewallPolicy) {
            this.firewallPolicy = firewallPolicy;
            return this;
        }

        public final String getFirewallPolicyArn() {
            return firewallPolicyArn;
        }

        public final void setFirewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
        }

        @Override
        @Transient
        public final Builder firewallPolicyArn(String firewallPolicyArn) {
            this.firewallPolicyArn = firewallPolicyArn;
            return this;
        }

        public final String getFirewallPolicyId() {
            return firewallPolicyId;
        }

        public final void setFirewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
        }

        @Override
        @Transient
        public final Builder firewallPolicyId(String firewallPolicyId) {
            this.firewallPolicyId = firewallPolicyId;
            return this;
        }

        public final String getFirewallPolicyName() {
            return firewallPolicyName;
        }

        public final void setFirewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
        }

        @Override
        @Transient
        public final Builder firewallPolicyName(String firewallPolicyName) {
            this.firewallPolicyName = firewallPolicyName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public AwsNetworkFirewallFirewallPolicyDetails build() {
            return new AwsNetworkFirewallFirewallPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
