/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Network Firewall rule group. Rule groups are used to inspect and control network traffic. Stateless
 * rule groups apply to individual packets. Stateful rule groups apply to packets in the context of their traffic flow.
 * </p>
 * <p>
 * Rule groups are referenced in firewall policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsNetworkFirewallRuleGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsNetworkFirewallRuleGroupDetails.Builder, AwsNetworkFirewallRuleGroupDetails> {
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Capacity").getter(getter(AwsNetworkFirewallRuleGroupDetails::capacity))
            .setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Capacity").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsNetworkFirewallRuleGroupDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<RuleGroupDetails> RULE_GROUP_FIELD = SdkField
            .<RuleGroupDetails> builder(MarshallingType.SDK_POJO).memberName("RuleGroup")
            .getter(getter(AwsNetworkFirewallRuleGroupDetails::ruleGroup)).setter(setter(Builder::ruleGroup))
            .constructor(RuleGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroup").build()).build();

    private static final SdkField<String> RULE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupArn").getter(getter(AwsNetworkFirewallRuleGroupDetails::ruleGroupArn))
            .setter(setter(Builder::ruleGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupArn").build()).build();

    private static final SdkField<String> RULE_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupId").getter(getter(AwsNetworkFirewallRuleGroupDetails::ruleGroupId))
            .setter(setter(Builder::ruleGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupId").build()).build();

    private static final SdkField<String> RULE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleGroupName").getter(getter(AwsNetworkFirewallRuleGroupDetails::ruleGroupName))
            .setter(setter(Builder::ruleGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleGroupName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsNetworkFirewallRuleGroupDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            DESCRIPTION_FIELD, RULE_GROUP_FIELD, RULE_GROUP_ARN_FIELD, RULE_GROUP_ID_FIELD, RULE_GROUP_NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer capacity;

    private final String description;

    private final RuleGroupDetails ruleGroup;

    private final String ruleGroupArn;

    private final String ruleGroupId;

    private final String ruleGroupName;

    private final String type;

    private AwsNetworkFirewallRuleGroupDetails(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.description = builder.description;
        this.ruleGroup = builder.ruleGroup;
        this.ruleGroupArn = builder.ruleGroupArn;
        this.ruleGroupId = builder.ruleGroupId;
        this.ruleGroupName = builder.ruleGroupName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The maximum number of operating resources that this rule group can use.
     * </p>
     * 
     * @return The maximum number of operating resources that this rule group can use.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * <p>
     * A description of the rule group.
     * </p>
     * 
     * @return A description of the rule group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Details about the rule group.
     * </p>
     * 
     * @return Details about the rule group.
     */
    public final RuleGroupDetails ruleGroup() {
        return ruleGroup;
    }

    /**
     * <p>
     * The ARN of the rule group.
     * </p>
     * 
     * @return The ARN of the rule group.
     */
    public final String ruleGroupArn() {
        return ruleGroupArn;
    }

    /**
     * <p>
     * The identifier of the rule group.
     * </p>
     * 
     * @return The identifier of the rule group.
     */
    public final String ruleGroupId() {
        return ruleGroupId;
    }

    /**
     * <p>
     * The descriptive name of the rule group.
     * </p>
     * 
     * @return The descriptive name of the rule group.
     */
    public final String ruleGroupName() {
        return ruleGroupName;
    }

    /**
     * <p>
     * The type of rule group. A rule group can be stateful or stateless.
     * </p>
     * 
     * @return The type of rule group. A rule group can be stateful or stateless.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsNetworkFirewallRuleGroupDetails)) {
            return false;
        }
        AwsNetworkFirewallRuleGroupDetails other = (AwsNetworkFirewallRuleGroupDetails) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(description(), other.description())
                && Objects.equals(ruleGroup(), other.ruleGroup()) && Objects.equals(ruleGroupArn(), other.ruleGroupArn())
                && Objects.equals(ruleGroupId(), other.ruleGroupId()) && Objects.equals(ruleGroupName(), other.ruleGroupName())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsNetworkFirewallRuleGroupDetails").add("Capacity", capacity())
                .add("Description", description()).add("RuleGroup", ruleGroup()).add("RuleGroupArn", ruleGroupArn())
                .add("RuleGroupId", ruleGroupId()).add("RuleGroupName", ruleGroupName()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RuleGroup":
            return Optional.ofNullable(clazz.cast(ruleGroup()));
        case "RuleGroupArn":
            return Optional.ofNullable(clazz.cast(ruleGroupArn()));
        case "RuleGroupId":
            return Optional.ofNullable(clazz.cast(ruleGroupId()));
        case "RuleGroupName":
            return Optional.ofNullable(clazz.cast(ruleGroupName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsNetworkFirewallRuleGroupDetails, T> g) {
        return obj -> g.apply((AwsNetworkFirewallRuleGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsNetworkFirewallRuleGroupDetails> {
        /**
         * <p>
         * The maximum number of operating resources that this rule group can use.
         * </p>
         * 
         * @param capacity
         *        The maximum number of operating resources that this rule group can use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * A description of the rule group.
         * </p>
         * 
         * @param description
         *        A description of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Details about the rule group.
         * </p>
         * 
         * @param ruleGroup
         *        Details about the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroup(RuleGroupDetails ruleGroup);

        /**
         * <p>
         * Details about the rule group.
         * </p>
         * This is a convenience that creates an instance of the {@link RuleGroupDetails.Builder} avoiding the need to
         * create one manually via {@link RuleGroupDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link RuleGroupDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ruleGroup(RuleGroupDetails)}.
         * 
         * @param ruleGroup
         *        a consumer that will call methods on {@link RuleGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ruleGroup(RuleGroupDetails)
         */
        default Builder ruleGroup(Consumer<RuleGroupDetails.Builder> ruleGroup) {
            return ruleGroup(RuleGroupDetails.builder().applyMutation(ruleGroup).build());
        }

        /**
         * <p>
         * The ARN of the rule group.
         * </p>
         * 
         * @param ruleGroupArn
         *        The ARN of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupArn(String ruleGroupArn);

        /**
         * <p>
         * The identifier of the rule group.
         * </p>
         * 
         * @param ruleGroupId
         *        The identifier of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupId(String ruleGroupId);

        /**
         * <p>
         * The descriptive name of the rule group.
         * </p>
         * 
         * @param ruleGroupName
         *        The descriptive name of the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleGroupName(String ruleGroupName);

        /**
         * <p>
         * The type of rule group. A rule group can be stateful or stateless.
         * </p>
         * 
         * @param type
         *        The type of rule group. A rule group can be stateful or stateless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private Integer capacity;

        private String description;

        private RuleGroupDetails ruleGroup;

        private String ruleGroupArn;

        private String ruleGroupId;

        private String ruleGroupName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsNetworkFirewallRuleGroupDetails model) {
            capacity(model.capacity);
            description(model.description);
            ruleGroup(model.ruleGroup);
            ruleGroupArn(model.ruleGroupArn);
            ruleGroupId(model.ruleGroupId);
            ruleGroupName(model.ruleGroupName);
            type(model.type);
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        @Transient
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final RuleGroupDetails.Builder getRuleGroup() {
            return ruleGroup != null ? ruleGroup.toBuilder() : null;
        }

        public final void setRuleGroup(RuleGroupDetails.BuilderImpl ruleGroup) {
            this.ruleGroup = ruleGroup != null ? ruleGroup.build() : null;
        }

        @Override
        @Transient
        public final Builder ruleGroup(RuleGroupDetails ruleGroup) {
            this.ruleGroup = ruleGroup;
            return this;
        }

        public final String getRuleGroupArn() {
            return ruleGroupArn;
        }

        public final void setRuleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
        }

        @Override
        @Transient
        public final Builder ruleGroupArn(String ruleGroupArn) {
            this.ruleGroupArn = ruleGroupArn;
            return this;
        }

        public final String getRuleGroupId() {
            return ruleGroupId;
        }

        public final void setRuleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
        }

        @Override
        @Transient
        public final Builder ruleGroupId(String ruleGroupId) {
            this.ruleGroupId = ruleGroupId;
            return this;
        }

        public final String getRuleGroupName() {
            return ruleGroupName;
        }

        public final void setRuleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
        }

        @Override
        @Transient
        public final Builder ruleGroupName(String ruleGroupName) {
            this.ruleGroupName = ruleGroupName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsNetworkFirewallRuleGroupDetails build() {
            return new AwsNetworkFirewallRuleGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
