/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the CloudWatch Logs to publish for the OpenSearch domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpenSearchServiceDomainLogPublishingOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsOpenSearchServiceDomainLogPublishingOptionsDetails.Builder, AwsOpenSearchServiceDomainLogPublishingOptionsDetails> {
    private static final SdkField<AwsOpenSearchServiceDomainLogPublishingOption> INDEX_SLOW_LOGS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainLogPublishingOption> builder(MarshallingType.SDK_POJO).memberName("IndexSlowLogs")
            .getter(getter(AwsOpenSearchServiceDomainLogPublishingOptionsDetails::indexSlowLogs))
            .setter(setter(Builder::indexSlowLogs)).constructor(AwsOpenSearchServiceDomainLogPublishingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexSlowLogs").build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainLogPublishingOption> SEARCH_SLOW_LOGS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainLogPublishingOption> builder(MarshallingType.SDK_POJO).memberName("SearchSlowLogs")
            .getter(getter(AwsOpenSearchServiceDomainLogPublishingOptionsDetails::searchSlowLogs))
            .setter(setter(Builder::searchSlowLogs)).constructor(AwsOpenSearchServiceDomainLogPublishingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchSlowLogs").build()).build();

    private static final SdkField<AwsOpenSearchServiceDomainLogPublishingOption> AUDIT_LOGS_FIELD = SdkField
            .<AwsOpenSearchServiceDomainLogPublishingOption> builder(MarshallingType.SDK_POJO).memberName("AuditLogs")
            .getter(getter(AwsOpenSearchServiceDomainLogPublishingOptionsDetails::auditLogs)).setter(setter(Builder::auditLogs))
            .constructor(AwsOpenSearchServiceDomainLogPublishingOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuditLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_SLOW_LOGS_FIELD,
            SEARCH_SLOW_LOGS_FIELD, AUDIT_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsOpenSearchServiceDomainLogPublishingOption indexSlowLogs;

    private final AwsOpenSearchServiceDomainLogPublishingOption searchSlowLogs;

    private final AwsOpenSearchServiceDomainLogPublishingOption auditLogs;

    private AwsOpenSearchServiceDomainLogPublishingOptionsDetails(BuilderImpl builder) {
        this.indexSlowLogs = builder.indexSlowLogs;
        this.searchSlowLogs = builder.searchSlowLogs;
        this.auditLogs = builder.auditLogs;
    }

    /**
     * <p>
     * Configures the OpenSearch index logs publishing.
     * </p>
     * 
     * @return Configures the OpenSearch index logs publishing.
     */
    public final AwsOpenSearchServiceDomainLogPublishingOption indexSlowLogs() {
        return indexSlowLogs;
    }

    /**
     * <p>
     * Configures the OpenSearch search slow log publishing.
     * </p>
     * 
     * @return Configures the OpenSearch search slow log publishing.
     */
    public final AwsOpenSearchServiceDomainLogPublishingOption searchSlowLogs() {
        return searchSlowLogs;
    }

    /**
     * <p>
     * Configures the OpenSearch audit logs publishing.
     * </p>
     * 
     * @return Configures the OpenSearch audit logs publishing.
     */
    public final AwsOpenSearchServiceDomainLogPublishingOption auditLogs() {
        return auditLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexSlowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(searchSlowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(auditLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpenSearchServiceDomainLogPublishingOptionsDetails)) {
            return false;
        }
        AwsOpenSearchServiceDomainLogPublishingOptionsDetails other = (AwsOpenSearchServiceDomainLogPublishingOptionsDetails) obj;
        return Objects.equals(indexSlowLogs(), other.indexSlowLogs()) && Objects.equals(searchSlowLogs(), other.searchSlowLogs())
                && Objects.equals(auditLogs(), other.auditLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpenSearchServiceDomainLogPublishingOptionsDetails").add("IndexSlowLogs", indexSlowLogs())
                .add("SearchSlowLogs", searchSlowLogs()).add("AuditLogs", auditLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexSlowLogs":
            return Optional.ofNullable(clazz.cast(indexSlowLogs()));
        case "SearchSlowLogs":
            return Optional.ofNullable(clazz.cast(searchSlowLogs()));
        case "AuditLogs":
            return Optional.ofNullable(clazz.cast(auditLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsOpenSearchServiceDomainLogPublishingOptionsDetails, T> g) {
        return obj -> g.apply((AwsOpenSearchServiceDomainLogPublishingOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpenSearchServiceDomainLogPublishingOptionsDetails> {
        /**
         * <p>
         * Configures the OpenSearch index logs publishing.
         * </p>
         * 
         * @param indexSlowLogs
         *        Configures the OpenSearch index logs publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption indexSlowLogs);

        /**
         * <p>
         * Configures the OpenSearch index logs publishing.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainLogPublishingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #indexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption)}.
         * 
         * @param indexSlowLogs
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption)
         */
        default Builder indexSlowLogs(Consumer<AwsOpenSearchServiceDomainLogPublishingOption.Builder> indexSlowLogs) {
            return indexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption.builder().applyMutation(indexSlowLogs).build());
        }

        /**
         * <p>
         * Configures the OpenSearch search slow log publishing.
         * </p>
         * 
         * @param searchSlowLogs
         *        Configures the OpenSearch search slow log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption searchSlowLogs);

        /**
         * <p>
         * Configures the OpenSearch search slow log publishing.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainLogPublishingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #searchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption)}.
         * 
         * @param searchSlowLogs
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption)
         */
        default Builder searchSlowLogs(Consumer<AwsOpenSearchServiceDomainLogPublishingOption.Builder> searchSlowLogs) {
            return searchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption.builder().applyMutation(searchSlowLogs).build());
        }

        /**
         * <p>
         * Configures the OpenSearch audit logs publishing.
         * </p>
         * 
         * @param auditLogs
         *        Configures the OpenSearch audit logs publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auditLogs(AwsOpenSearchServiceDomainLogPublishingOption auditLogs);

        /**
         * <p>
         * Configures the OpenSearch audit logs publishing.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder} avoiding the need to create one manually via
         * {@link AwsOpenSearchServiceDomainLogPublishingOption#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #auditLogs(AwsOpenSearchServiceDomainLogPublishingOption)}.
         * 
         * @param auditLogs
         *        a consumer that will call methods on {@link AwsOpenSearchServiceDomainLogPublishingOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auditLogs(AwsOpenSearchServiceDomainLogPublishingOption)
         */
        default Builder auditLogs(Consumer<AwsOpenSearchServiceDomainLogPublishingOption.Builder> auditLogs) {
            return auditLogs(AwsOpenSearchServiceDomainLogPublishingOption.builder().applyMutation(auditLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsOpenSearchServiceDomainLogPublishingOption indexSlowLogs;

        private AwsOpenSearchServiceDomainLogPublishingOption searchSlowLogs;

        private AwsOpenSearchServiceDomainLogPublishingOption auditLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpenSearchServiceDomainLogPublishingOptionsDetails model) {
            indexSlowLogs(model.indexSlowLogs);
            searchSlowLogs(model.searchSlowLogs);
            auditLogs(model.auditLogs);
        }

        public final AwsOpenSearchServiceDomainLogPublishingOption.Builder getIndexSlowLogs() {
            return indexSlowLogs != null ? indexSlowLogs.toBuilder() : null;
        }

        public final void setIndexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption.BuilderImpl indexSlowLogs) {
            this.indexSlowLogs = indexSlowLogs != null ? indexSlowLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder indexSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption indexSlowLogs) {
            this.indexSlowLogs = indexSlowLogs;
            return this;
        }

        public final AwsOpenSearchServiceDomainLogPublishingOption.Builder getSearchSlowLogs() {
            return searchSlowLogs != null ? searchSlowLogs.toBuilder() : null;
        }

        public final void setSearchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption.BuilderImpl searchSlowLogs) {
            this.searchSlowLogs = searchSlowLogs != null ? searchSlowLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder searchSlowLogs(AwsOpenSearchServiceDomainLogPublishingOption searchSlowLogs) {
            this.searchSlowLogs = searchSlowLogs;
            return this;
        }

        public final AwsOpenSearchServiceDomainLogPublishingOption.Builder getAuditLogs() {
            return auditLogs != null ? auditLogs.toBuilder() : null;
        }

        public final void setAuditLogs(AwsOpenSearchServiceDomainLogPublishingOption.BuilderImpl auditLogs) {
            this.auditLogs = auditLogs != null ? auditLogs.build() : null;
        }

        @Override
        @Transient
        public final Builder auditLogs(AwsOpenSearchServiceDomainLogPublishingOption auditLogs) {
            this.auditLogs = auditLogs;
            return this;
        }

        @Override
        public AwsOpenSearchServiceDomainLogPublishingOptionsDetails build() {
            return new AwsOpenSearchServiceDomainLogPublishingOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
