/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Active Directory domain membership record associated with the DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbDomainMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbDomainMembership.Builder, AwsRdsDbDomainMembership> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Domain")
            .getter(getter(AwsRdsDbDomainMembership::domain)).setter(setter(Builder::domain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbDomainMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FQDN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fqdn")
            .getter(getter(AwsRdsDbDomainMembership::fqdn)).setter(setter(Builder::fqdn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fqdn").build()).build();

    private static final SdkField<String> IAM_ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleName").getter(getter(AwsRdsDbDomainMembership::iamRoleName)).setter(setter(Builder::iamRoleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, STATUS_FIELD,
            FQDN_FIELD, IAM_ROLE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domain;

    private final String status;

    private final String fqdn;

    private final String iamRoleName;

    private AwsRdsDbDomainMembership(BuilderImpl builder) {
        this.domain = builder.domain;
        this.status = builder.status;
        this.fqdn = builder.fqdn;
        this.iamRoleName = builder.iamRoleName;
    }

    /**
     * <p>
     * The identifier of the Active Directory domain.
     * </p>
     * 
     * @return The identifier of the Active Directory domain.
     */
    public final String domain() {
        return domain;
    }

    /**
     * <p>
     * The status of the Active Directory Domain membership for the DB instance.
     * </p>
     * 
     * @return The status of the Active Directory Domain membership for the DB instance.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The fully qualified domain name of the Active Directory domain.
     * </p>
     * 
     * @return The fully qualified domain name of the Active Directory domain.
     */
    public final String fqdn() {
        return fqdn;
    }

    /**
     * <p>
     * The name of the IAM role to use when making API calls to the Directory Service.
     * </p>
     * 
     * @return The name of the IAM role to use when making API calls to the Directory Service.
     */
    public final String iamRoleName() {
        return iamRoleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domain());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(fqdn());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbDomainMembership)) {
            return false;
        }
        AwsRdsDbDomainMembership other = (AwsRdsDbDomainMembership) obj;
        return Objects.equals(domain(), other.domain()) && Objects.equals(status(), other.status())
                && Objects.equals(fqdn(), other.fqdn()) && Objects.equals(iamRoleName(), other.iamRoleName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbDomainMembership").add("Domain", domain()).add("Status", status()).add("Fqdn", fqdn())
                .add("IamRoleName", iamRoleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Domain":
            return Optional.ofNullable(clazz.cast(domain()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Fqdn":
            return Optional.ofNullable(clazz.cast(fqdn()));
        case "IamRoleName":
            return Optional.ofNullable(clazz.cast(iamRoleName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbDomainMembership, T> g) {
        return obj -> g.apply((AwsRdsDbDomainMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbDomainMembership> {
        /**
         * <p>
         * The identifier of the Active Directory domain.
         * </p>
         * 
         * @param domain
         *        The identifier of the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domain(String domain);

        /**
         * <p>
         * The status of the Active Directory Domain membership for the DB instance.
         * </p>
         * 
         * @param status
         *        The status of the Active Directory Domain membership for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The fully qualified domain name of the Active Directory domain.
         * </p>
         * 
         * @param fqdn
         *        The fully qualified domain name of the Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fqdn(String fqdn);

        /**
         * <p>
         * The name of the IAM role to use when making API calls to the Directory Service.
         * </p>
         * 
         * @param iamRoleName
         *        The name of the IAM role to use when making API calls to the Directory Service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleName(String iamRoleName);
    }

    static final class BuilderImpl implements Builder {
        private String domain;

        private String status;

        private String fqdn;

        private String iamRoleName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbDomainMembership model) {
            domain(model.domain);
            status(model.status);
            fqdn(model.fqdn);
            iamRoleName(model.iamRoleName);
        }

        public final String getDomain() {
            return domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getFqdn() {
            return fqdn;
        }

        public final void setFqdn(String fqdn) {
            this.fqdn = fqdn;
        }

        @Override
        @Transient
        public final Builder fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public final String getIamRoleName() {
            return iamRoleName;
        }

        public final void setIamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
        }

        @Override
        @Transient
        public final Builder iamRoleName(String iamRoleName) {
            this.iamRoleName = iamRoleName;
            return this;
        }

        @Override
        public AwsRdsDbDomainMembership build() {
            return new AwsRdsDbDomainMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
