/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon RDS DB cluster snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbSnapshotDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbSnapshotDetails.Builder, AwsRdsDbSnapshotDetails> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbSnapshotIdentifier").getter(getter(AwsRdsDbSnapshotDetails::dbSnapshotIdentifier))
            .setter(setter(Builder::dbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbInstanceIdentifier").getter(getter(AwsRdsDbSnapshotDetails::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotCreateTime").getter(getter(AwsRdsDbSnapshotDetails::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCreateTime").build())
            .build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(AwsRdsDbSnapshotDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsRdsDbSnapshotDetails::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbSnapshotDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(AwsRdsDbSnapshotDetails::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsRdsDbSnapshotDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsRdsDbSnapshotDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> INSTANCE_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceCreateTime").getter(getter(AwsRdsDbSnapshotDetails::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(AwsRdsDbSnapshotDetails::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsRdsDbSnapshotDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(AwsRdsDbSnapshotDetails::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<String> SNAPSHOT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotType").getter(getter(AwsRdsDbSnapshotDetails::snapshotType))
            .setter(setter(Builder::snapshotType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(AwsRdsDbSnapshotDetails::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptionGroupName").getter(getter(AwsRdsDbSnapshotDetails::optionGroupName))
            .setter(setter(Builder::optionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()).build();

    private static final SdkField<Integer> PERCENT_PROGRESS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentProgress").getter(getter(AwsRdsDbSnapshotDetails::percentProgress))
            .setter(setter(Builder::percentProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentProgress").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(AwsRdsDbSnapshotDetails::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final SdkField<String> SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceDbSnapshotIdentifier")
            .getter(getter(AwsRdsDbSnapshotDetails::sourceDbSnapshotIdentifier))
            .setter(setter(Builder::sourceDbSnapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDbSnapshotIdentifier").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(AwsRdsDbSnapshotDetails::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(AwsRdsDbSnapshotDetails::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(AwsRdsDbSnapshotDetails::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsRdsDbSnapshotDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(AwsRdsDbSnapshotDetails::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IamDatabaseAuthenticationEnabled")
            .getter(getter(AwsRdsDbSnapshotDetails::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<List<AwsRdsDbProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<AwsRdsDbProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(AwsRdsDbSnapshotDetails::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(AwsRdsDbSnapshotDetails::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD,
            DB_INSTANCE_IDENTIFIER_FIELD, SNAPSHOT_CREATE_TIME_FIELD, ENGINE_FIELD, ALLOCATED_STORAGE_FIELD, STATUS_FIELD,
            PORT_FIELD, AVAILABILITY_ZONE_FIELD, VPC_ID_FIELD, INSTANCE_CREATE_TIME_FIELD, MASTER_USERNAME_FIELD,
            ENGINE_VERSION_FIELD, LICENSE_MODEL_FIELD, SNAPSHOT_TYPE_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD,
            PERCENT_PROGRESS_FIELD, SOURCE_REGION_FIELD, SOURCE_DB_SNAPSHOT_IDENTIFIER_FIELD, STORAGE_TYPE_FIELD,
            TDE_CREDENTIAL_ARN_FIELD, ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, TIMEZONE_FIELD,
            IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, PROCESSOR_FEATURES_FIELD, DBI_RESOURCE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dbSnapshotIdentifier;

    private final String dbInstanceIdentifier;

    private final String snapshotCreateTime;

    private final String engine;

    private final Integer allocatedStorage;

    private final String status;

    private final Integer port;

    private final String availabilityZone;

    private final String vpcId;

    private final String instanceCreateTime;

    private final String masterUsername;

    private final String engineVersion;

    private final String licenseModel;

    private final String snapshotType;

    private final Integer iops;

    private final String optionGroupName;

    private final Integer percentProgress;

    private final String sourceRegion;

    private final String sourceDbSnapshotIdentifier;

    private final String storageType;

    private final String tdeCredentialArn;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String timezone;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final List<AwsRdsDbProcessorFeature> processorFeatures;

    private final String dbiResourceId;

    private AwsRdsDbSnapshotDetails(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.engine = builder.engine;
        this.allocatedStorage = builder.allocatedStorage;
        this.status = builder.status;
        this.port = builder.port;
        this.availabilityZone = builder.availabilityZone;
        this.vpcId = builder.vpcId;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.masterUsername = builder.masterUsername;
        this.engineVersion = builder.engineVersion;
        this.licenseModel = builder.licenseModel;
        this.snapshotType = builder.snapshotType;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.percentProgress = builder.percentProgress;
        this.sourceRegion = builder.sourceRegion;
        this.sourceDbSnapshotIdentifier = builder.sourceDbSnapshotIdentifier;
        this.storageType = builder.storageType;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.timezone = builder.timezone;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.processorFeatures = builder.processorFeatures;
        this.dbiResourceId = builder.dbiResourceId;
    }

    /**
     * <p>
     * The name or ARN of the DB snapshot that is used to restore the DB instance.
     * </p>
     * 
     * @return The name or ARN of the DB snapshot that is used to restore the DB instance.
     */
    public final String dbSnapshotIdentifier() {
        return dbSnapshotIdentifier;
    }

    /**
     * <p>
     * A name for the DB instance.
     * </p>
     * 
     * @return A name for the DB instance.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * When the snapshot was taken in Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return When the snapshot was taken in Coordinated Universal Time (UTC).
     */
    public final String snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The name of the database engine to use for this DB instance.
     * </p>
     * 
     * @return The name of the database engine to use for this DB instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) to be initially allocated for the database instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) to be initially allocated for the database instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The status of this DB snapshot.
     * </p>
     * 
     * @return The status of this DB snapshot.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The port that the database engine was listening on at the time of the snapshot.
     * </p>
     * 
     * @return The port that the database engine was listening on at the time of the snapshot.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB snapshot.
     * </p>
     * 
     * @return Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB
     *         snapshot.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The VPC ID associated with the DB snapshot.
     * </p>
     * 
     * @return The VPC ID associated with the DB snapshot.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was taken,
     * was created.
     * </p>
     * 
     * @return Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was
     *         taken, was created.
     */
    public final String instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * The master user name for the DB snapshot.
     * </p>
     * 
     * @return The master user name for the DB snapshot.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The version of the database engine.
     * </p>
     * 
     * @return The version of the database engine.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * License model information for the restored DB instance.
     * </p>
     * 
     * @return License model information for the restored DB instance.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * The type of the DB snapshot.
     * </p>
     * 
     * @return The type of the DB snapshot.
     */
    public final String snapshotType() {
        return snapshotType;
    }

    /**
     * <p>
     * The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     * </p>
     * 
     * @return The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The option group name for the DB snapshot.
     * </p>
     * 
     * @return The option group name for the DB snapshot.
     */
    public final String optionGroupName() {
        return optionGroupName;
    }

    /**
     * <p>
     * The percentage of the estimated data that has been transferred.
     * </p>
     * 
     * @return The percentage of the estimated data that has been transferred.
     */
    public final Integer percentProgress() {
        return percentProgress;
    }

    /**
     * <p>
     * The Amazon Web Services Region that the DB snapshot was created in or copied from.
     * </p>
     * 
     * @return The Amazon Web Services Region that the DB snapshot was created in or copied from.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The DB snapshot ARN that the DB snapshot was copied from.
     * </p>
     * 
     * @return The DB snapshot ARN that the DB snapshot was copied from.
     */
    public final String sourceDbSnapshotIdentifier() {
        return sourceDbSnapshotIdentifier;
    }

    /**
     * <p>
     * The storage type associated with the DB snapshot.
     * </p>
     * 
     * @return The storage type associated with the DB snapshot.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * The ARN from the key store with which to associate the instance for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which to associate the instance for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * <p>
     * Whether the DB snapshot is encrypted.
     * </p>
     * 
     * @return Whether the DB snapshot is encrypted.
     */
    public final Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * If <code>Encrypted</code> is <code>true</code>, the KMS key identifier for the encrypted DB snapshot.
     * </p>
     * 
     * @return If <code>Encrypted</code> is <code>true</code>, the KMS key identifier for the encrypted DB snapshot.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The time zone of the DB snapshot.
     * </p>
     * 
     * @return The time zone of the DB snapshot.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Whether mapping of IAM accounts to database accounts is enabled.
     * </p>
     * 
     * @return Whether mapping of IAM accounts to database accounts is enabled.
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public final List<AwsRdsDbProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * <p>
     * The identifier for the source DB instance.
     * </p>
     * 
     * @return The identifier for the source DB instance.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSnapshotDetails)) {
            return false;
        }
        AwsRdsDbSnapshotDetails other = (AwsRdsDbSnapshotDetails) obj;
        return Objects.equals(dbSnapshotIdentifier(), other.dbSnapshotIdentifier())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime()) && Objects.equals(engine(), other.engine())
                && Objects.equals(allocatedStorage(), other.allocatedStorage()) && Objects.equals(status(), other.status())
                && Objects.equals(port(), other.port()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(vpcId(), other.vpcId()) && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(licenseModel(), other.licenseModel())
                && Objects.equals(snapshotType(), other.snapshotType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(optionGroupName(), other.optionGroupName())
                && Objects.equals(percentProgress(), other.percentProgress())
                && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(sourceDbSnapshotIdentifier(), other.sourceDbSnapshotIdentifier())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn()) && Objects.equals(encrypted(), other.encrypted())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(dbiResourceId(), other.dbiResourceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbSnapshotDetails").add("DbSnapshotIdentifier", dbSnapshotIdentifier())
                .add("DbInstanceIdentifier", dbInstanceIdentifier()).add("SnapshotCreateTime", snapshotCreateTime())
                .add("Engine", engine()).add("AllocatedStorage", allocatedStorage()).add("Status", status()).add("Port", port())
                .add("AvailabilityZone", availabilityZone()).add("VpcId", vpcId())
                .add("InstanceCreateTime", instanceCreateTime()).add("MasterUsername", masterUsername())
                .add("EngineVersion", engineVersion()).add("LicenseModel", licenseModel()).add("SnapshotType", snapshotType())
                .add("Iops", iops()).add("OptionGroupName", optionGroupName()).add("PercentProgress", percentProgress())
                .add("SourceRegion", sourceRegion()).add("SourceDbSnapshotIdentifier", sourceDbSnapshotIdentifier())
                .add("StorageType", storageType()).add("TdeCredentialArn", tdeCredentialArn()).add("Encrypted", encrypted())
                .add("KmsKeyId", kmsKeyId()).add("Timezone", timezone())
                .add("IamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("DbiResourceId", dbiResourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(dbSnapshotIdentifier()));
        case "DbInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "SnapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "SnapshotType":
            return Optional.ofNullable(clazz.cast(snapshotType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupName":
            return Optional.ofNullable(clazz.cast(optionGroupName()));
        case "PercentProgress":
            return Optional.ofNullable(clazz.cast(percentProgress()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "SourceDbSnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(sourceDbSnapshotIdentifier()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "IamDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSnapshotDetails, T> g) {
        return obj -> g.apply((AwsRdsDbSnapshotDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbSnapshotDetails> {
        /**
         * <p>
         * The name or ARN of the DB snapshot that is used to restore the DB instance.
         * </p>
         * 
         * @param dbSnapshotIdentifier
         *        The name or ARN of the DB snapshot that is used to restore the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSnapshotIdentifier(String dbSnapshotIdentifier);

        /**
         * <p>
         * A name for the DB instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        A name for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * When the snapshot was taken in Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param snapshotCreateTime
         *        When the snapshot was taken in Coordinated Universal Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(String snapshotCreateTime);

        /**
         * <p>
         * The name of the database engine to use for this DB instance.
         * </p>
         * 
         * @param engine
         *        The name of the database engine to use for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The amount of storage (in gigabytes) to be initially allocated for the database instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) to be initially allocated for the database instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The status of this DB snapshot.
         * </p>
         * 
         * @param status
         *        The status of this DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The port that the database engine was listening on at the time of the snapshot.
         * </p>
         * 
         * @param port
         *        The port that the database engine was listening on at the time of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB
         * snapshot.
         * </p>
         * 
         * @param availabilityZone
         *        Specifies the name of the Availability Zone in which the DB instance was located at the time of the DB
         *        snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The VPC ID associated with the DB snapshot.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID associated with the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot was
         * taken, was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        Specifies the time in Coordinated Universal Time (UTC) when the DB instance, from which the snapshot
         *        was taken, was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(String instanceCreateTime);

        /**
         * <p>
         * The master user name for the DB snapshot.
         * </p>
         * 
         * @param masterUsername
         *        The master user name for the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The version of the database engine.
         * </p>
         * 
         * @param engineVersion
         *        The version of the database engine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * License model information for the restored DB instance.
         * </p>
         * 
         * @param licenseModel
         *        License model information for the restored DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The type of the DB snapshot.
         * </p>
         * 
         * @param snapshotType
         *        The type of the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotType(String snapshotType);

        /**
         * <p>
         * The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
         * </p>
         * 
         * @param iops
         *        The provisioned IOPS (I/O operations per second) value of the DB instance at the time of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The option group name for the DB snapshot.
         * </p>
         * 
         * @param optionGroupName
         *        The option group name for the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupName(String optionGroupName);

        /**
         * <p>
         * The percentage of the estimated data that has been transferred.
         * </p>
         * 
         * @param percentProgress
         *        The percentage of the estimated data that has been transferred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentProgress(Integer percentProgress);

        /**
         * <p>
         * The Amazon Web Services Region that the DB snapshot was created in or copied from.
         * </p>
         * 
         * @param sourceRegion
         *        The Amazon Web Services Region that the DB snapshot was created in or copied from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The DB snapshot ARN that the DB snapshot was copied from.
         * </p>
         * 
         * @param sourceDbSnapshotIdentifier
         *        The DB snapshot ARN that the DB snapshot was copied from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier);

        /**
         * <p>
         * The storage type associated with the DB snapshot.
         * </p>
         * 
         * @param storageType
         *        The storage type associated with the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The ARN from the key store with which to associate the instance for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which to associate the instance for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * Whether the DB snapshot is encrypted.
         * </p>
         * 
         * @param encrypted
         *        Whether the DB snapshot is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * If <code>Encrypted</code> is <code>true</code>, the KMS key identifier for the encrypted DB snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>Encrypted</code> is <code>true</code>, the KMS key identifier for the encrypted DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The time zone of the DB snapshot.
         * </p>
         * 
         * @param timezone
         *        The time zone of the DB snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Whether mapping of IAM accounts to database accounts is enabled.
         * </p>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        Whether mapping of IAM accounts to database accounts is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AwsRdsDbProcessorFeature>.Builder} avoiding
         * the need to create one manually via {@link List<AwsRdsDbProcessorFeature>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AwsRdsDbProcessorFeature>.Builder#build()} is called
         * immediately and its result is passed to {@link #processorFeatures(List<AwsRdsDbProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on {@link List<AwsRdsDbProcessorFeature>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(List<AwsRdsDbProcessorFeature>)
         */
        Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures);

        /**
         * <p>
         * The identifier for the source DB instance.
         * </p>
         * 
         * @param dbiResourceId
         *        The identifier for the source DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);
    }

    static final class BuilderImpl implements Builder {
        private String dbSnapshotIdentifier;

        private String dbInstanceIdentifier;

        private String snapshotCreateTime;

        private String engine;

        private Integer allocatedStorage;

        private String status;

        private Integer port;

        private String availabilityZone;

        private String vpcId;

        private String instanceCreateTime;

        private String masterUsername;

        private String engineVersion;

        private String licenseModel;

        private String snapshotType;

        private Integer iops;

        private String optionGroupName;

        private Integer percentProgress;

        private String sourceRegion;

        private String sourceDbSnapshotIdentifier;

        private String storageType;

        private String tdeCredentialArn;

        private Boolean encrypted;

        private String kmsKeyId;

        private String timezone;

        private Boolean iamDatabaseAuthenticationEnabled;

        private List<AwsRdsDbProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private String dbiResourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSnapshotDetails model) {
            dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            snapshotCreateTime(model.snapshotCreateTime);
            engine(model.engine);
            allocatedStorage(model.allocatedStorage);
            status(model.status);
            port(model.port);
            availabilityZone(model.availabilityZone);
            vpcId(model.vpcId);
            instanceCreateTime(model.instanceCreateTime);
            masterUsername(model.masterUsername);
            engineVersion(model.engineVersion);
            licenseModel(model.licenseModel);
            snapshotType(model.snapshotType);
            iops(model.iops);
            optionGroupName(model.optionGroupName);
            percentProgress(model.percentProgress);
            sourceRegion(model.sourceRegion);
            sourceDbSnapshotIdentifier(model.sourceDbSnapshotIdentifier);
            storageType(model.storageType);
            tdeCredentialArn(model.tdeCredentialArn);
            encrypted(model.encrypted);
            kmsKeyId(model.kmsKeyId);
            timezone(model.timezone);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            processorFeatures(model.processorFeatures);
            dbiResourceId(model.dbiResourceId);
        }

        public final String getDbSnapshotIdentifier() {
            return dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        @Transient
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        @Transient
        public final Builder snapshotCreateTime(String snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        @Transient
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        @Transient
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getInstanceCreateTime() {
            return instanceCreateTime;
        }

        public final void setInstanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        @Transient
        public final Builder instanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        @Transient
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        @Transient
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final String getSnapshotType() {
            return snapshotType;
        }

        public final void setSnapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
        }

        @Override
        @Transient
        public final Builder snapshotType(String snapshotType) {
            this.snapshotType = snapshotType;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        @Transient
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Integer getPercentProgress() {
            return percentProgress;
        }

        public final void setPercentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        @Transient
        public final Builder percentProgress(Integer percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        @Transient
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceDbSnapshotIdentifier() {
            return sourceDbSnapshotIdentifier;
        }

        public final void setSourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier) {
            this.sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder sourceDbSnapshotIdentifier(String sourceDbSnapshotIdentifier) {
            this.sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        @Transient
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        @Transient
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final List<AwsRdsDbProcessorFeature.Builder> getProcessorFeatures() {
            List<AwsRdsDbProcessorFeature.Builder> result = AwsRdsDbProcessorFeaturesCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<AwsRdsDbProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        @Transient
        public final Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> AwsRdsDbProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        @Transient
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        @Override
        public AwsRdsDbSnapshotDetails build() {
            return new AwsRdsDbSnapshotDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
