/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an Amazon RDS event notification subscription. The subscription allows Amazon RDS to post events to an
 * SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsEventSubscriptionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsEventSubscriptionDetails.Builder, AwsRdsEventSubscriptionDetails> {
    private static final SdkField<String> CUST_SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustSubscriptionId").getter(getter(AwsRdsEventSubscriptionDetails::custSubscriptionId))
            .setter(setter(Builder::custSubscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustSubscriptionId").build())
            .build();

    private static final SdkField<String> CUSTOMER_AWS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerAwsId").getter(getter(AwsRdsEventSubscriptionDetails::customerAwsId))
            .setter(setter(Builder::customerAwsId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerAwsId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsRdsEventSubscriptionDetails::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<String>> EVENT_CATEGORIES_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EventCategoriesList")
            .getter(getter(AwsRdsEventSubscriptionDetails::eventCategoriesList))
            .setter(setter(Builder::eventCategoriesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventCategoriesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EVENT_SUBSCRIPTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventSubscriptionArn").getter(getter(AwsRdsEventSubscriptionDetails::eventSubscriptionArn))
            .setter(setter(Builder::eventSubscriptionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSubscriptionArn").build())
            .build();

    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnsTopicArn").getter(getter(AwsRdsEventSubscriptionDetails::snsTopicArn))
            .setter(setter(Builder::snsTopicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()).build();

    private static final SdkField<List<String>> SOURCE_IDS_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceIdsList")
            .getter(getter(AwsRdsEventSubscriptionDetails::sourceIdsList))
            .setter(setter(Builder::sourceIdsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIdsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(AwsRdsEventSubscriptionDetails::sourceType))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsEventSubscriptionDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBSCRIPTION_CREATION_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionCreationTime").getter(getter(AwsRdsEventSubscriptionDetails::subscriptionCreationTime))
            .setter(setter(Builder::subscriptionCreationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUST_SUBSCRIPTION_ID_FIELD,
            CUSTOMER_AWS_ID_FIELD, ENABLED_FIELD, EVENT_CATEGORIES_LIST_FIELD, EVENT_SUBSCRIPTION_ARN_FIELD, SNS_TOPIC_ARN_FIELD,
            SOURCE_IDS_LIST_FIELD, SOURCE_TYPE_FIELD, STATUS_FIELD, SUBSCRIPTION_CREATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String custSubscriptionId;

    private final String customerAwsId;

    private final Boolean enabled;

    private final List<String> eventCategoriesList;

    private final String eventSubscriptionArn;

    private final String snsTopicArn;

    private final List<String> sourceIdsList;

    private final String sourceType;

    private final String status;

    private final String subscriptionCreationTime;

    private AwsRdsEventSubscriptionDetails(BuilderImpl builder) {
        this.custSubscriptionId = builder.custSubscriptionId;
        this.customerAwsId = builder.customerAwsId;
        this.enabled = builder.enabled;
        this.eventCategoriesList = builder.eventCategoriesList;
        this.eventSubscriptionArn = builder.eventSubscriptionArn;
        this.snsTopicArn = builder.snsTopicArn;
        this.sourceIdsList = builder.sourceIdsList;
        this.sourceType = builder.sourceType;
        this.status = builder.status;
        this.subscriptionCreationTime = builder.subscriptionCreationTime;
    }

    /**
     * <p>
     * The identifier of the account that is associated with the event notification subscription.
     * </p>
     * 
     * @return The identifier of the account that is associated with the event notification subscription.
     */
    public final String custSubscriptionId() {
        return custSubscriptionId;
    }

    /**
     * <p>
     * The identifier of the event notification subscription.
     * </p>
     * 
     * @return The identifier of the event notification subscription.
     */
    public final String customerAwsId() {
        return customerAwsId;
    }

    /**
     * <p>
     * Whether the event notification subscription is enabled.
     * </p>
     * 
     * @return Whether the event notification subscription is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the EventCategoriesList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEventCategoriesList() {
        return eventCategoriesList != null && !(eventCategoriesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of event categories for the event notification subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEventCategoriesList} method.
     * </p>
     * 
     * @return The list of event categories for the event notification subscription.
     */
    public final List<String> eventCategoriesList() {
        return eventCategoriesList;
    }

    /**
     * <p>
     * The ARN of the event notification subscription.
     * </p>
     * 
     * @return The ARN of the event notification subscription.
     */
    public final String eventSubscriptionArn() {
        return eventSubscriptionArn;
    }

    /**
     * <p>
     * The ARN of the SNS topic to post the event notifications to.
     * </p>
     * 
     * @return The ARN of the SNS topic to post the event notifications to.
     */
    public final String snsTopicArn() {
        return snsTopicArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceIdsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceIdsList() {
        return sourceIdsList != null && !(sourceIdsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of source identifiers for the event notification subscription.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceIdsList} method.
     * </p>
     * 
     * @return A list of source identifiers for the event notification subscription.
     */
    public final List<String> sourceIdsList() {
        return sourceIdsList;
    }

    /**
     * <p>
     * The source type for the event notification subscription.
     * </p>
     * 
     * @return The source type for the event notification subscription.
     */
    public final String sourceType() {
        return sourceType;
    }

    /**
     * <p>
     * The status of the event notification subscription.
     * </p>
     * <p>
     * Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> |
     * <code>no-permission</code> | <code>topic-not-exist</code>
     * </p>
     * 
     * @return The status of the event notification subscription.</p>
     *         <p>
     *         Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> |
     *         <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The datetime when the event notification subscription was created.
     * </p>
     * <p>
     * Uses the <code>date-time</code> format specified in <a href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC
     * 3339 section 5.6, Internet Date/Time Format</a>. The value cannot contain spaces. For example,
     * <code>2020-03-22T13:22:13.933Z</code>.
     * </p>
     * 
     * @return The datetime when the event notification subscription was created.</p>
     *         <p>
     *         Uses the <code>date-time</code> format specified in <a
     *         href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
     *         Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
     */
    public final String subscriptionCreationTime() {
        return subscriptionCreationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(custSubscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(customerAwsId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasEventCategoriesList() ? eventCategoriesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventSubscriptionArn());
        hashCode = 31 * hashCode + Objects.hashCode(snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceIdsList() ? sourceIdsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceType());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionCreationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsEventSubscriptionDetails)) {
            return false;
        }
        AwsRdsEventSubscriptionDetails other = (AwsRdsEventSubscriptionDetails) obj;
        return Objects.equals(custSubscriptionId(), other.custSubscriptionId())
                && Objects.equals(customerAwsId(), other.customerAwsId()) && Objects.equals(enabled(), other.enabled())
                && hasEventCategoriesList() == other.hasEventCategoriesList()
                && Objects.equals(eventCategoriesList(), other.eventCategoriesList())
                && Objects.equals(eventSubscriptionArn(), other.eventSubscriptionArn())
                && Objects.equals(snsTopicArn(), other.snsTopicArn()) && hasSourceIdsList() == other.hasSourceIdsList()
                && Objects.equals(sourceIdsList(), other.sourceIdsList()) && Objects.equals(sourceType(), other.sourceType())
                && Objects.equals(status(), other.status())
                && Objects.equals(subscriptionCreationTime(), other.subscriptionCreationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsEventSubscriptionDetails").add("CustSubscriptionId", custSubscriptionId())
                .add("CustomerAwsId", customerAwsId()).add("Enabled", enabled())
                .add("EventCategoriesList", hasEventCategoriesList() ? eventCategoriesList() : null)
                .add("EventSubscriptionArn", eventSubscriptionArn()).add("SnsTopicArn", snsTopicArn())
                .add("SourceIdsList", hasSourceIdsList() ? sourceIdsList() : null).add("SourceType", sourceType())
                .add("Status", status()).add("SubscriptionCreationTime", subscriptionCreationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustSubscriptionId":
            return Optional.ofNullable(clazz.cast(custSubscriptionId()));
        case "CustomerAwsId":
            return Optional.ofNullable(clazz.cast(customerAwsId()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "EventCategoriesList":
            return Optional.ofNullable(clazz.cast(eventCategoriesList()));
        case "EventSubscriptionArn":
            return Optional.ofNullable(clazz.cast(eventSubscriptionArn()));
        case "SnsTopicArn":
            return Optional.ofNullable(clazz.cast(snsTopicArn()));
        case "SourceIdsList":
            return Optional.ofNullable(clazz.cast(sourceIdsList()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceType()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubscriptionCreationTime":
            return Optional.ofNullable(clazz.cast(subscriptionCreationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsEventSubscriptionDetails, T> g) {
        return obj -> g.apply((AwsRdsEventSubscriptionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsEventSubscriptionDetails> {
        /**
         * <p>
         * The identifier of the account that is associated with the event notification subscription.
         * </p>
         * 
         * @param custSubscriptionId
         *        The identifier of the account that is associated with the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custSubscriptionId(String custSubscriptionId);

        /**
         * <p>
         * The identifier of the event notification subscription.
         * </p>
         * 
         * @param customerAwsId
         *        The identifier of the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerAwsId(String customerAwsId);

        /**
         * <p>
         * Whether the event notification subscription is enabled.
         * </p>
         * 
         * @param enabled
         *        Whether the event notification subscription is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The list of event categories for the event notification subscription.
         * </p>
         * 
         * @param eventCategoriesList
         *        The list of event categories for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(Collection<String> eventCategoriesList);

        /**
         * <p>
         * The list of event categories for the event notification subscription.
         * </p>
         * 
         * @param eventCategoriesList
         *        The list of event categories for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventCategoriesList(String... eventCategoriesList);

        /**
         * <p>
         * The ARN of the event notification subscription.
         * </p>
         * 
         * @param eventSubscriptionArn
         *        The ARN of the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventSubscriptionArn(String eventSubscriptionArn);

        /**
         * <p>
         * The ARN of the SNS topic to post the event notifications to.
         * </p>
         * 
         * @param snsTopicArn
         *        The ARN of the SNS topic to post the event notifications to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsTopicArn(String snsTopicArn);

        /**
         * <p>
         * A list of source identifiers for the event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of source identifiers for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(Collection<String> sourceIdsList);

        /**
         * <p>
         * A list of source identifiers for the event notification subscription.
         * </p>
         * 
         * @param sourceIdsList
         *        A list of source identifiers for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceIdsList(String... sourceIdsList);

        /**
         * <p>
         * The source type for the event notification subscription.
         * </p>
         * 
         * @param sourceType
         *        The source type for the event notification subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * The status of the event notification subscription.
         * </p>
         * <p>
         * Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> | <code>active</code> |
         * <code>no-permission</code> | <code>topic-not-exist</code>
         * </p>
         * 
         * @param status
         *        The status of the event notification subscription.</p>
         *        <p>
         *        Valid values: <code>creating</code> | <code>modifying</code> | <code>deleting</code> |
         *        <code>active</code> | <code>no-permission</code> | <code>topic-not-exist</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The datetime when the event notification subscription was created.
         * </p>
         * <p>
         * Uses the <code>date-time</code> format specified in <a
         * href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time Format</a>.
         * The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * </p>
         * 
         * @param subscriptionCreationTime
         *        The datetime when the event notification subscription was created.</p>
         *        <p>
         *        Uses the <code>date-time</code> format specified in <a
         *        href="https://tools.ietf.org/html/rfc3339#section-5.6">RFC 3339 section 5.6, Internet Date/Time
         *        Format</a>. The value cannot contain spaces. For example, <code>2020-03-22T13:22:13.933Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionCreationTime(String subscriptionCreationTime);
    }

    static final class BuilderImpl implements Builder {
        private String custSubscriptionId;

        private String customerAwsId;

        private Boolean enabled;

        private List<String> eventCategoriesList = DefaultSdkAutoConstructList.getInstance();

        private String eventSubscriptionArn;

        private String snsTopicArn;

        private List<String> sourceIdsList = DefaultSdkAutoConstructList.getInstance();

        private String sourceType;

        private String status;

        private String subscriptionCreationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsEventSubscriptionDetails model) {
            custSubscriptionId(model.custSubscriptionId);
            customerAwsId(model.customerAwsId);
            enabled(model.enabled);
            eventCategoriesList(model.eventCategoriesList);
            eventSubscriptionArn(model.eventSubscriptionArn);
            snsTopicArn(model.snsTopicArn);
            sourceIdsList(model.sourceIdsList);
            sourceType(model.sourceType);
            status(model.status);
            subscriptionCreationTime(model.subscriptionCreationTime);
        }

        public final String getCustSubscriptionId() {
            return custSubscriptionId;
        }

        public final void setCustSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
        }

        @Override
        @Transient
        public final Builder custSubscriptionId(String custSubscriptionId) {
            this.custSubscriptionId = custSubscriptionId;
            return this;
        }

        public final String getCustomerAwsId() {
            return customerAwsId;
        }

        public final void setCustomerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
        }

        @Override
        @Transient
        public final Builder customerAwsId(String customerAwsId) {
            this.customerAwsId = customerAwsId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Collection<String> getEventCategoriesList() {
            if (eventCategoriesList instanceof SdkAutoConstructList) {
                return null;
            }
            return eventCategoriesList;
        }

        public final void setEventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = NonEmptyStringListCopier.copy(eventCategoriesList);
        }

        @Override
        @Transient
        public final Builder eventCategoriesList(Collection<String> eventCategoriesList) {
            this.eventCategoriesList = NonEmptyStringListCopier.copy(eventCategoriesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventCategoriesList(String... eventCategoriesList) {
            eventCategoriesList(Arrays.asList(eventCategoriesList));
            return this;
        }

        public final String getEventSubscriptionArn() {
            return eventSubscriptionArn;
        }

        public final void setEventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
        }

        @Override
        @Transient
        public final Builder eventSubscriptionArn(String eventSubscriptionArn) {
            this.eventSubscriptionArn = eventSubscriptionArn;
            return this;
        }

        public final String getSnsTopicArn() {
            return snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final Collection<String> getSourceIdsList() {
            if (sourceIdsList instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceIdsList;
        }

        public final void setSourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = NonEmptyStringListCopier.copy(sourceIdsList);
        }

        @Override
        @Transient
        public final Builder sourceIdsList(Collection<String> sourceIdsList) {
            this.sourceIdsList = NonEmptyStringListCopier.copy(sourceIdsList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceIdsList(String... sourceIdsList) {
            sourceIdsList(Arrays.asList(sourceIdsList));
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        @Transient
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubscriptionCreationTime() {
            return subscriptionCreationTime;
        }

        public final void setSubscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
        }

        @Override
        @Transient
        public final Builder subscriptionCreationTime(String subscriptionCreationTime) {
            this.subscriptionCreationTime = subscriptionCreationTime;
            return this;
        }

        @Override
        public AwsRdsEventSubscriptionDetails build() {
            return new AwsRdsEventSubscriptionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
