/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the status of a cluster restore action. It only applies if the cluster was created by restoring a
 * snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterRestoreStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterRestoreStatus.Builder, AwsRedshiftClusterRestoreStatus> {
    private static final SdkField<Double> CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("CurrentRestoreRateInMegaBytesPerSecond")
            .getter(getter(AwsRedshiftClusterRestoreStatus::currentRestoreRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentRestoreRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CurrentRestoreRateInMegaBytesPerSecond").build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ElapsedTimeInSeconds").getter(getter(AwsRedshiftClusterRestoreStatus::elapsedTimeInSeconds))
            .setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("EstimatedTimeToCompletionInSeconds")
            .getter(getter(AwsRedshiftClusterRestoreStatus::estimatedTimeToCompletionInSeconds))
            .setter(setter(Builder::estimatedTimeToCompletionInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds")
                    .build()).build();

    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProgressInMegaBytes").getter(getter(AwsRedshiftClusterRestoreStatus::progressInMegaBytes))
            .setter(setter(Builder::progressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build())
            .build();

    private static final SdkField<Long> SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SnapshotSizeInMegaBytes").getter(getter(AwsRedshiftClusterRestoreStatus::snapshotSizeInMegaBytes))
            .setter(setter(Builder::snapshotSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSizeInMegaBytes").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRedshiftClusterRestoreStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD,
            ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double currentRestoreRateInMegaBytesPerSecond;

    private final Long elapsedTimeInSeconds;

    private final Long estimatedTimeToCompletionInSeconds;

    private final Long progressInMegaBytes;

    private final Long snapshotSizeInMegaBytes;

    private final String status;

    private AwsRedshiftClusterRestoreStatus(BuilderImpl builder) {
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.status = builder.status;
    }

    /**
     * <p>
     * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a
     * completed backup.
     * </p>
     * <p>
     * This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The number of megabytes per second being transferred from the backup storage. Returns the average rate
     *         for a completed backup.</p>
     *         <p>
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public final Double currentRestoreRateInMegaBytesPerSecond() {
        return currentRestoreRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to
     * finish.
     * </p>
     * <p>
     * This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The amount of time an in-progress restore has been running, or the amount of time it took a completed
     *         restore to finish.</p>
     *         <p>
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public final Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The estimate of the time remaining before the restore is complete. Returns 0 for a completed restore.
     * </p>
     * <p>
     * This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The estimate of the time remaining before the restore is complete. Returns 0 for a completed restore.</p>
     *         <p>
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public final Long estimatedTimeToCompletionInSeconds() {
        return estimatedTimeToCompletionInSeconds;
    }

    /**
     * <p>
     * The number of megabytes that were transferred from snapshot storage.
     * </p>
     * <p>
     * This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The number of megabytes that were transferred from snapshot storage.</p>
     *         <p>
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public final Long progressInMegaBytes() {
        return progressInMegaBytes;
    }

    /**
     * <p>
     * The size of the set of snapshot data that was used to restore the cluster.
     * </p>
     * <p>
     * This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The size of the set of snapshot data that was used to restore the cluster.</p>
     *         <p>
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public final Long snapshotSizeInMegaBytes() {
        return snapshotSizeInMegaBytes;
    }

    /**
     * <p>
     * The status of the restore action.
     * </p>
     * <p>
     * Valid values: <code>starting</code> | <code>restoring</code> | <code>completed</code> | <code>failed</code>
     * </p>
     * 
     * @return The status of the restore action.</p>
     *         <p>
     *         Valid values: <code>starting</code> | <code>restoring</code> | <code>completed</code> |
     *         <code>failed</code>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(currentRestoreRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterRestoreStatus)) {
            return false;
        }
        AwsRedshiftClusterRestoreStatus other = (AwsRedshiftClusterRestoreStatus) obj;
        return Objects.equals(currentRestoreRateInMegaBytesPerSecond(), other.currentRestoreRateInMegaBytesPerSecond())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds())
                && Objects.equals(progressInMegaBytes(), other.progressInMegaBytes())
                && Objects.equals(snapshotSizeInMegaBytes(), other.snapshotSizeInMegaBytes())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterRestoreStatus")
                .add("CurrentRestoreRateInMegaBytesPerSecond", currentRestoreRateInMegaBytesPerSecond())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds())
                .add("EstimatedTimeToCompletionInSeconds", estimatedTimeToCompletionInSeconds())
                .add("ProgressInMegaBytes", progressInMegaBytes()).add("SnapshotSizeInMegaBytes", snapshotSizeInMegaBytes())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CurrentRestoreRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentRestoreRateInMegaBytesPerSecond()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "EstimatedTimeToCompletionInSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompletionInSeconds()));
        case "ProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(progressInMegaBytes()));
        case "SnapshotSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(snapshotSizeInMegaBytes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterRestoreStatus, T> g) {
        return obj -> g.apply((AwsRedshiftClusterRestoreStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterRestoreStatus> {
        /**
         * <p>
         * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a
         * completed backup.
         * </p>
         * <p>
         * This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param currentRestoreRateInMegaBytesPerSecond
         *        The number of megabytes per second being transferred from the backup storage. Returns the average rate
         *        for a completed backup.</p>
         *        <p>
         *        This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond);

        /**
         * <p>
         * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore
         * to finish.
         * </p>
         * <p>
         * This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of time an in-progress restore has been running, or the amount of time it took a completed
         *        restore to finish.</p>
         *        <p>
         *        This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The estimate of the time remaining before the restore is complete. Returns 0 for a completed restore.
         * </p>
         * <p>
         * This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param estimatedTimeToCompletionInSeconds
         *        The estimate of the time remaining before the restore is complete. Returns 0 for a completed
         *        restore.</p>
         *        <p>
         *        This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds);

        /**
         * <p>
         * The number of megabytes that were transferred from snapshot storage.
         * </p>
         * <p>
         * This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param progressInMegaBytes
         *        The number of megabytes that were transferred from snapshot storage.</p>
         *        <p>
         *        This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressInMegaBytes(Long progressInMegaBytes);

        /**
         * <p>
         * The size of the set of snapshot data that was used to restore the cluster.
         * </p>
         * <p>
         * This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param snapshotSizeInMegaBytes
         *        The size of the set of snapshot data that was used to restore the cluster.</p>
         *        <p>
         *        This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes);

        /**
         * <p>
         * The status of the restore action.
         * </p>
         * <p>
         * Valid values: <code>starting</code> | <code>restoring</code> | <code>completed</code> | <code>failed</code>
         * </p>
         * 
         * @param status
         *        The status of the restore action.</p>
         *        <p>
         *        Valid values: <code>starting</code> | <code>restoring</code> | <code>completed</code> |
         *        <code>failed</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Double currentRestoreRateInMegaBytesPerSecond;

        private Long elapsedTimeInSeconds;

        private Long estimatedTimeToCompletionInSeconds;

        private Long progressInMegaBytes;

        private Long snapshotSizeInMegaBytes;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterRestoreStatus model) {
            currentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            progressInMegaBytes(model.progressInMegaBytes);
            snapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            status(model.status);
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return currentRestoreRateInMegaBytesPerSecond;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        @Transient
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        @Transient
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return estimatedTimeToCompletionInSeconds;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        @Transient
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final Long getProgressInMegaBytes() {
            return progressInMegaBytes;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        @Override
        @Transient
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return snapshotSizeInMegaBytes;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        @Override
        @Transient
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRedshiftClusterRestoreStatus build() {
            return new AwsRedshiftClusterRestoreStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
