/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about logging for the S3 bucket
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsS3BucketLoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsS3BucketLoggingConfiguration.Builder, AwsS3BucketLoggingConfiguration> {
    private static final SdkField<String> DESTINATION_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationBucketName").getter(getter(AwsS3BucketLoggingConfiguration::destinationBucketName))
            .setter(setter(Builder::destinationBucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationBucketName").build())
            .build();

    private static final SdkField<String> LOG_FILE_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFilePrefix").getter(getter(AwsS3BucketLoggingConfiguration::logFilePrefix))
            .setter(setter(Builder::logFilePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilePrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_BUCKET_NAME_FIELD,
            LOG_FILE_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String destinationBucketName;

    private final String logFilePrefix;

    private AwsS3BucketLoggingConfiguration(BuilderImpl builder) {
        this.destinationBucketName = builder.destinationBucketName;
        this.logFilePrefix = builder.logFilePrefix;
    }

    /**
     * <p>
     * The name of the S3 bucket where log files for the S3 bucket are stored.
     * </p>
     * 
     * @return The name of the S3 bucket where log files for the S3 bucket are stored.
     */
    public final String destinationBucketName() {
        return destinationBucketName;
    }

    /**
     * <p>
     * The prefix added to log files for the S3 bucket.
     * </p>
     * 
     * @return The prefix added to log files for the S3 bucket.
     */
    public final String logFilePrefix() {
        return logFilePrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationBucketName());
        hashCode = 31 * hashCode + Objects.hashCode(logFilePrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsS3BucketLoggingConfiguration)) {
            return false;
        }
        AwsS3BucketLoggingConfiguration other = (AwsS3BucketLoggingConfiguration) obj;
        return Objects.equals(destinationBucketName(), other.destinationBucketName())
                && Objects.equals(logFilePrefix(), other.logFilePrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsS3BucketLoggingConfiguration").add("DestinationBucketName", destinationBucketName())
                .add("LogFilePrefix", logFilePrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationBucketName":
            return Optional.ofNullable(clazz.cast(destinationBucketName()));
        case "LogFilePrefix":
            return Optional.ofNullable(clazz.cast(logFilePrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsS3BucketLoggingConfiguration, T> g) {
        return obj -> g.apply((AwsS3BucketLoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsS3BucketLoggingConfiguration> {
        /**
         * <p>
         * The name of the S3 bucket where log files for the S3 bucket are stored.
         * </p>
         * 
         * @param destinationBucketName
         *        The name of the S3 bucket where log files for the S3 bucket are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationBucketName(String destinationBucketName);

        /**
         * <p>
         * The prefix added to log files for the S3 bucket.
         * </p>
         * 
         * @param logFilePrefix
         *        The prefix added to log files for the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFilePrefix(String logFilePrefix);
    }

    static final class BuilderImpl implements Builder {
        private String destinationBucketName;

        private String logFilePrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsS3BucketLoggingConfiguration model) {
            destinationBucketName(model.destinationBucketName);
            logFilePrefix(model.logFilePrefix);
        }

        public final String getDestinationBucketName() {
            return destinationBucketName;
        }

        public final void setDestinationBucketName(String destinationBucketName) {
            this.destinationBucketName = destinationBucketName;
        }

        @Override
        @Transient
        public final Builder destinationBucketName(String destinationBucketName) {
            this.destinationBucketName = destinationBucketName;
            return this;
        }

        public final String getLogFilePrefix() {
            return logFilePrefix;
        }

        public final void setLogFilePrefix(String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
        }

        @Override
        @Transient
        public final Builder logFilePrefix(String logFilePrefix) {
            this.logFilePrefix = logFilePrefix;
            return this;
        }

        @Override
        public AwsS3BucketLoggingConfiguration build() {
            return new AwsS3BucketLoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
